/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.pro.income.controller.api;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.pro.income.bean.ClaimEntity;
import com.ejianc.business.pro.income.bean.ContractRegisterEntity;
import com.ejianc.business.pro.income.bean.ProductionEntity;
import com.ejianc.business.pro.income.service.IClaimService;
import com.ejianc.business.pro.income.service.IContractRegisterService;
import com.ejianc.business.pro.income.service.IProductionService;
import com.ejianc.business.pro.income.vo.ClaimVO;
import com.ejianc.business.pro.income.vo.ContractRegisterVO;
import com.ejianc.business.pro.income.vo.ProductionVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseEntity;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/proincomeContrantApi/"})
public class ProincomeContrantApi {
    @Autowired
    private IContractRegisterService service;
    @Autowired
    private IProductionService productionService;
    @Autowired
    private IClaimService claimService;

    @PostMapping(value={"updateRegistrationUseFlag"})
    public CommonResponse<String> updateRegistrationUseFlag(@RequestBody ClaimVO claimVO) {
        ClaimEntity entity = (ClaimEntity)((Object)this.claimService.selectById(claimVO.getId()));
        entity.setRegistrationUseFlag(claimVO.getRegistrationUseFlag());
        this.claimService.saveOrUpdate((Object)entity, false);
        return CommonResponse.success((String)"\u64cd\u4f5c\u6210\u529f\uff01");
    }

    @GetMapping(value={"/queryContranct"})
    public CommonResponse<BigDecimal> queryContranct(@RequestParam(value="projectId") Long projectId) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(ContractRegisterEntity::getProjectId, (Object)projectId);
        queryWrapper.eq(BaseEntity::getDr, (Object)0);
        queryWrapper.eq(ContractRegisterEntity::getSupplementFlag, (Object)0);
        queryWrapper.eq(BaseEntity::getTenantId, (Object)InvocationInfoProxy.getTenantid());
        queryWrapper.in(ContractRegisterEntity::getBillState, new Object[]{1, 3});
        List contractRegisterEntities = this.service.list((Wrapper)queryWrapper);
        BigDecimal totalContractTaxMny = new BigDecimal("0.00");
        if (!ListUtil.isNotEmpty((List)contractRegisterEntities)) {
            return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25,\u6ca1\u6709\u67e5\u8be2\u5230\u8be5\u9879\u76ee\u4e0b\u7684\u65bd\u5de5\u5408\u540c\uff01");
        }
        totalContractTaxMny = contractRegisterEntities.stream().map(ContractRegisterEntity::getContractTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);
        totalContractTaxMny = totalContractTaxMny.setScale(2, 4);
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", (Object)totalContractTaxMny);
    }

    @GetMapping(value={"/queryProduction"})
    public CommonResponse<BigDecimal> queryProduction(@RequestParam(value="orgId", required=false) Long orgId) {
        HashMap<String, BigDecimal> totalMny = new HashMap<String, BigDecimal>();
        QueryWrapper query = new QueryWrapper();
        query.select(new String[]{"IFNULL(SUM(production_tax_mny), 0) AS totalProductionMny"});
        if (orgId != null) {
            query.eq((Object)"org_id", (Object)orgId);
        } else {
            query.eq((Object)"org_id", (Object)InvocationInfoProxy.getOrgId());
        }
        query.eq((Object)"dr", (Object)0);
        query.eq((Object)"tenant_id", (Object)InvocationInfoProxy.getTenantid());
        query.in((Object)"bill_state", Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()));
        Map resultMap = this.productionService.getMap((Wrapper)query);
        totalMny.put("totalProductionMny", null != resultMap && null != resultMap.get("totalProductionMny") ? new BigDecimal(resultMap.get("totalProductionMny").toString()) : BigDecimal.ZERO);
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", totalMny.get("totalProductionMny"));
    }

    @GetMapping(value={"/queryTotalProduction"})
    public CommonResponse<Map<Long, ProductionVO>> queryTotalProduction() {
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"dr", (Object)0);
        query.eq((Object)"tenant_id", (Object)InvocationInfoProxy.getTenantid());
        query.in((Object)"bill_state", Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()));
        List list = this.productionService.list((Wrapper)query);
        if (CollectionUtils.isEmpty((Collection)list)) {
            return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25,\u6ca1\u6709\u67e5\u8be2\u5230\u4ea7\u503c\u62a5\u91cf\uff01");
        }
        Map<Long, List<ProductionEntity>> map = list.stream().collect(Collectors.groupingBy(ProductionEntity::getProjectId));
        HashMap pMap = new HashMap();
        map.forEach((k, v) -> {
            ProductionVO vo = new ProductionVO();
            vo.setProductionTaxMny(v.stream().filter(x -> x.getProductionTaxMny() != null).map(ProductionEntity::getProductionTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add));
            vo.setProjectId(k);
            vo.setProjectName(((ProductionEntity)((Object)((Object)v.get(0)))).getProjectName());
            vo.setProjectCode(((ProductionEntity)((Object)((Object)v.get(0)))).getProjectCode());
            pMap.put(k, vo);
        });
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", pMap);
    }

    @GetMapping(value={"/queryContranctMny"})
    public CommonResponse<ContractRegisterVO> queryContranctMny(@RequestParam(value="projectId") Long projectId) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(ContractRegisterEntity::getProjectId, (Object)projectId);
        queryWrapper.eq(BaseEntity::getDr, (Object)0);
        queryWrapper.eq(BaseEntity::getTenantId, (Object)InvocationInfoProxy.getTenantid());
        queryWrapper.in(ContractRegisterEntity::getBillState, new Object[]{1, 3});
        queryWrapper.eq(ContractRegisterEntity::getSupplementFlag, (Object)0);
        queryWrapper.orderByDesc(BaseEntity::getCreateTime);
        List contractRegisterEntities = this.service.list((Wrapper)queryWrapper);
        ContractRegisterVO vo = new ContractRegisterVO();
        if (ListUtil.isNotEmpty((List)contractRegisterEntities)) {
            vo.setContractTaxMny(contractRegisterEntities.stream().map(ContractRegisterEntity::getContractTaxMny).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add));
        } else {
            vo.setContractTaxMny(BigDecimal.ZERO);
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", (Object)vo);
    }

    @GetMapping(value={"/queryProductionByProject"})
    public CommonResponse<BigDecimal> queryProductionByProject(@RequestParam(value="projectId") Long projectId) {
        HashMap<String, BigDecimal> totalMny = new HashMap<String, BigDecimal>();
        QueryWrapper query = new QueryWrapper();
        query.select(new String[]{"IFNULL(SUM(production_tax_mny), 0) AS totalProductionMny"});
        query.eq((Object)"project_id", (Object)projectId);
        query.eq((Object)"dr", (Object)0);
        query.eq((Object)"tenant_id", (Object)InvocationInfoProxy.getTenantid());
        query.in((Object)"bill_state", Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()));
        Map resultMap = this.productionService.getMap((Wrapper)query);
        totalMny.put("totalProductionMny", null != resultMap && null != resultMap.get("totalProductionMny") ? new BigDecimal(resultMap.get("totalProductionMny").toString()) : BigDecimal.ZERO);
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", totalMny.get("totalProductionMny"));
    }
}

