package com.ejianc.business.pro.income.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.pro.income.bean.BudgetDetailEntity;
import com.ejianc.business.pro.income.enums.ExcelDetailTypeEnum;
import com.ejianc.business.pro.income.mapper.BudgetDetailMapper;
import com.ejianc.business.pro.income.service.IBudgetDetailService;
import com.ejianc.business.pro.income.vo.BudgetDetailVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 清单明细
 * 
 * @author generator
 * 
 */
@Service("budgetDetailService")
public class BudgetDetailServiceImpl extends BaseServiceImpl<BudgetDetailMapper, BudgetDetailEntity> implements IBudgetDetailService{

    @Autowired
    private BudgetDetailMapper mapper;

    @Override
    public void delDetailByBudgetId(Long budgetId) {
        baseMapper.delete(new QueryWrapper<BudgetDetailEntity>().eq("budget_id", budgetId));
    }

    @Override
    public void delDetailBatchByBudgetId(List<Long> ids) {
        baseMapper.delete(new QueryWrapper<BudgetDetailEntity>().in("budget_id", ids));
    }

    @Override
    public List<BudgetDetailVO> queryDetailList(Long budgetBid) {
        LambdaQueryWrapper<BudgetDetailEntity> lambd = new LambdaQueryWrapper<>();
        lambd.eq(BudgetDetailEntity::getBudgetBid,budgetBid);
        List<BudgetDetailEntity> list = super.list(lambd);
        return BeanMapper.mapList(list,BudgetDetailVO.class);
    }

    @Override
    public List<BudgetDetailEntity> queryDetailByBudgetIds(List<Long> budegtIds) {
        return baseMapper.selectList(new QueryWrapper<BudgetDetailEntity>()
                .eq("dr",0)
                .in("budget_id", budegtIds));
    }

    @Override
    public List<BudgetDetailVO> queryUnSubjectListByBudgetId(Long budgetId) {

        List<Long> excludePids = getHasSubjectDetailIds(budgetId);

        List<BudgetDetailVO> resp = new ArrayList<>();
        QueryWrapper<BudgetDetailEntity> query = new QueryWrapper<>();
        query.eq("budget_id", budgetId);
        query.eq("leaf_flag", true);
        query.notIn("detail_item_type", new String[]{ExcelDetailTypeEnum.定额_单价构成.getCode(), ExcelDetailTypeEnum.定额.getCode()});
        query.isNull("detail_subject_id");
        if(CollectionUtils.isNotEmpty(excludePids)) {
            query.notIn("parent_id", excludePids);
        }
        query.groupBy("detail_code");
        List<BudgetDetailEntity> detailList = super.list(query);

        if(CollectionUtils.isNotEmpty(detailList)) {
            resp = BeanMapper.mapList(detailList, BudgetDetailVO.class);
        }

        //TODO 插入成本科目匹配表

        return resp;
    }

    private List<Long> getHasSubjectDetailIds(Long budgetId) {
        return mapper.getHasSubjectDetailIds(budgetId);

    }


    @Override
    public void saveDetailSubjectInfo(List<BudgetDetailVO> saveList) {
        List<Long> excludePids = getHasSubjectDetailIds(saveList.get(0).getBudgetId());

        //过滤掉为设置成本科目的项
        Map<String, BudgetDetailVO> codeMap = saveList.stream().filter(item -> null != item.getDetailSubjectId())
                .collect(Collectors.toMap(BudgetDetailVO::getDetailCode, item -> item));

        if(MapUtils.isNotEmpty(codeMap)) {
            QueryWrapper<BudgetDetailEntity> query = new QueryWrapper<>();
            query.eq("budget_id", saveList.get(0).getBudgetId());
            query.eq("leaf_flag", true);
            query.in("detail_code", codeMap.keySet());
            query.notIn("detail_item_type", new String[]{ExcelDetailTypeEnum.定额_单价构成.getCode(), ExcelDetailTypeEnum.定额.getCode()});
            query.isNull("detail_subject_id");
            if(CollectionUtils.isNotEmpty(excludePids)) {
                query.notIn("parent_id", excludePids);
            }
            List<BudgetDetailEntity> detailList = super.list(query);

            if(CollectionUtils.isNotEmpty(detailList)) {
                detailList.stream().forEach(item -> {
                    item.setDetailSubjectId(codeMap.get(item.getDetailCode()).getDetailSubjectId());
                    item.setDetailSubjectName(codeMap.get(item.getDetailCode()).getDetailSubjectName());
                });
                super.saveOrUpdateBatch(detailList, detailList.size(), false);
            }

        }
    }
}
