package com.ejianc.business.pro.income.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.pro.income.bean.ClaimDetailEntity;
import com.ejianc.business.pro.income.bean.ClaimEntity;
import com.ejianc.business.pro.income.bean.ClaimRecordsEntity;
import com.ejianc.business.pro.income.bean.ContractRegisterEntity;
import com.ejianc.business.pro.income.cons.CommonConstants;
import com.ejianc.business.pro.income.enums.BillPushStatusEnum;
import com.ejianc.business.pro.income.service.*;
import com.ejianc.business.pro.income.utils.ParamUtil;
import com.ejianc.business.pro.income.vo.*;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.*;
import com.ejianc.framework.core.util.ExcelExport;
import dm.jdbc.util.DateUtil;
import org.apache.commons.lang3.StringUtils;
import org.apache.tools.ant.util.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 洽商签证索赔
 * 
 * @author generator
 * 
 */
@Controller
@RequestMapping("claim")
public class ClaimController implements Serializable {
	private static final long serialVersionUID = 1L;
	
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    private static final String INCOME_NEGOTIATE_CODE = "INCOME_NEGOTIATE"; //变更洽商单单据编码生成规则
    private static final String INCOME_VISA_CODE = "INCOME_VISA"; //经济签证单单据编码生成规则
    private static final String PROINCOME_CLAIM_CODE = "PROINCOME_CLAIM"; //索赔单单据编码生成规则

    private static final String QS = "QS"; //变更洽商单
    private static final String QZ = "QZ"; //经济签证单
    private static final String SP = "SP"; //索赔单

    public static final Map<String,String> BillCodeMap = new HashMap<>();

    static{
        BillCodeMap.put(QS,INCOME_NEGOTIATE_CODE);
        BillCodeMap.put(QZ,INCOME_VISA_CODE);
        BillCodeMap.put(SP,PROINCOME_CLAIM_CODE);
    }

    public static final Map<String,String> ReplyStatusMap = new HashMap<>();

    static{
        ReplyStatusMap.put("0","未批复");
        ReplyStatusMap.put("1","已批复");
        ReplyStatusMap.put("2","未通过");
    }

    @Autowired
    private IClaimService service;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IBudgetService budgetService;
    @Autowired
    private IAttachmentApi attachmentApi;
    @Autowired
    private IContractRegisterService contractRegisterService;
    @Autowired
    private IClaimRecordsService claimRecordsService;
    @Autowired
    private IClaimDetailService claimDetailService;




    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ClaimVO> saveOrUpdate(@RequestBody ClaimVO saveorUpdateVO) {
    	ClaimEntity entity = BeanMapper.map(saveorUpdateVO, ClaimEntity.class);
    	if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(INCOME_VISA_CODE, InvocationInfoProxy.getTenantid(), saveorUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        entity.setReplyStatus("0");
        entity.setUseFlag(0);
        entity.setUseCzFlag(0);
        entity.setRegistrationUseFlag(0);
    	service.saveOrUpdate(entity, false);
//        budgetService.updateUseId(entity.getId(),entity.getBillType(),saveorUpdateVO.getBudgetIds());
        claimRecordsService.updateClaimRecords(entity.getId(),entity.getReplyStatus(),saveorUpdateVO.getClaimRecordIds(),entity.getBillCode());

        ClaimVO vo = BeanMapper.map(entity, ClaimVO.class);
        return CommonResponse.success("保存或修改单据成功！",vo);
    }
    /**
     * @Description saveOrUpdate 修改
     */
    @RequestMapping(value = "/updateAll", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ClaimVO> updateAll(@RequestBody ClaimVO saveorUpdateVO) {
        ClaimEntity claimEntity = service.selectById(saveorUpdateVO.getId());
        List<Long> claimRecordIds = saveorUpdateVO.getClaimRecordIds();
        if (CollectionUtils.isNotEmpty(claimRecordIds)) {
            claimRecordIds.forEach(e -> {
                LambdaUpdateWrapper<ClaimRecordsEntity> lambda = new LambdaUpdateWrapper();
                lambda.eq(ClaimRecordsEntity::getId, e);
                lambda.set(ClaimRecordsEntity::getClaimId, saveorUpdateVO.getId());
                lambda.set(ClaimRecordsEntity::getClaimCode, claimEntity.getBillCode());
                lambda.set(ClaimRecordsEntity::getQuoteStatus, CommonConstants.SLZ);
                claimRecordsService.update(lambda);
            });
        }
        List<ClaimDetailVO> detailList = saveorUpdateVO.getDetailList();
        for (ClaimDetailVO claimDetailVO : detailList){
            claimDetailVO.setMid(saveorUpdateVO.getId());
        }
        List<ClaimDetailEntity> claimDetailEntities = BeanMapper.mapList(detailList, ClaimDetailEntity.class);
        if (CollectionUtils.isNotEmpty(claimDetailEntities)){
            claimDetailService.saveOrUpdateBatch(claimDetailEntities);
        }

        return CommonResponse.success("保存或修改单据成功！");
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ClaimVO> queryDetail(Long id) {
    	ClaimEntity entity = service.selectById(id);
    	ClaimVO vo = BeanMapper.map(entity, ClaimVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }
    
    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ClaimVO> vos) {
        service.removeByIds(vos.stream().map(ClaimVO::getId).collect(Collectors.toList()),true);
//        budgetService.deleteUseId(vos.stream().map(ClaimVO::getId).collect(Collectors.toList()));
        claimRecordsService.deleteClaimId(vos.stream().map(ClaimVO::getId).collect(Collectors.toList()));
        return CommonResponse.success("删除成功！");
    }
    
    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<ClaimVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("contractName");
        fuzzyFields.add("claimTitle");
        fuzzyFields.add("projectName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        if(OrgVO.ORG_TYPE_DEPARTMENT.toString().equals(InvocationInfoProxy.getOrgType())){
            param.getParams().put("orgId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getOrgId()));
        } else {
            param.getParams().put("parentOrgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentIdWithoutProjectDept(
                    InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        }

        IPage<ClaimEntity> page = service.queryPage(param,false);
        List<ClaimVO> claimVOS = BeanMapper.mapList(page.getRecords(), ClaimVO.class);
        claimVOS.forEach(e -> {
            e.setReplyStatusName(ReplyStatusMap.get(e.getReplyStatus()));
            long days = getDays(new Date(), e.getSubmitDate());
            if (e.getReplyStatus().equals("0") && days >= 21){
                String s = ReplyStatusMap.get(e.getReplyStatus()) + "(已过" + days + "天)";
                e.setReplyStatusName(s);
            }
        });
        IPage<ClaimVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(claimVOS);
        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    private long getDays(Date date,Date date2) {
            LocalDate localDate1 = date.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
            LocalDate localDate2 = date2.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();

            long diffDays = Math.abs(localDate2.toEpochDay() - localDate1.toEpochDay());
            return diffDays;
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
//        String billType = (String) param.getParams().get("billType").getValue();
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("contractName");
        fuzzyFields.add("claimTitle");
        fuzzyFields.add("projectName");
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        if(OrgVO.ORG_TYPE_DEPARTMENT.toString().equals(InvocationInfoProxy.getOrgType())){
            param.getParams().put("orgId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getOrgId()));
        } else {
            param.getParams().put("parentOrgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentIdWithoutProjectDept(
                    InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        }

        List<ClaimEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();

        List<ClaimVO> claimVOS = BeanMapper.mapList(list, ClaimVO.class);

        claimVOS.forEach(e -> {
            e.setBillStateName(BillStateEnum.getEnumByStateCode(e.getBillState()).getDescription());
            e.setReplyStatusName(ReplyStatusMap.get(e.getReplyStatus()));
            long days = getDays(new Date(), e.getSubmitDate());
            if (days >= 21){
                String s = ReplyStatusMap.get(e.getReplyStatus()) + "(已过" + days + "天)";
                e.setReplyStatusName(ReplyStatusMap.get(s));
            }
            if(e.getApprovalFlag() != null && e.getApprovalFlag() == 0){
                e.setApprovalFlagName("否");
            }
            if(e.getApprovalFlag() != null && e.getApprovalFlag() == 1){
                e.setApprovalFlagName("是");
            }


            if (QS.equals(e.getDjType())) {
                e.setBillTypeName("变更洽商单");
            }else if (QZ.equals(e.getDjType())) {
                e.setBillTypeName("签证");
            }else if (SP.equals(e.getDjType())) {
                e.setBillTypeName("索赔");
            }else {
                e.setBillTypeName(null);
            }
        });
        beans.put("records", claimVOS);
//        if(QS.equals(billType)){
//            ExcelExport.getInstance().export("negotiate-export.xlsx", beans, response);
//        } else if(QZ.equals(billType)){
//            ExcelExport.getInstance().export("visa-export.xlsx", beans, response);
//        } else if(SP.equals(billType)){
//            ExcelExport.getInstance().export("claim-export.xlsx", beans, response);
//        }
        ExcelExport.getInstance().export("claim-export.xlsx", beans, response);

    }

//    @PostMapping("*")
//    @ResponseBody
    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/updateReplyDate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> updateReplyDate(@RequestBody ClaimVO claim){
        ClaimEntity claimEntity = service.selectById(claim.getId());
        if (claimEntity!=null){
            LambdaUpdateWrapper<ClaimEntity> wrapper = new LambdaUpdateWrapper();
            wrapper.eq(ClaimEntity::getId,claim.getId());
            wrapper.set(ClaimEntity::getReplyDate,claim.getReplyDate());
            wrapper.set(ClaimEntity::getReplyStatus,claim.getReplyStatus());
            wrapper.set(ClaimEntity::getReplyMny,claim.getReplyMny());
            wrapper.set(ClaimEntity::getReplyTaxMny,claim.getReplyTaxMny());
            wrapper.set(ClaimEntity::getReplyTax,claim.getReplyTax());
            wrapper.set(ClaimEntity::getReplyDuration,claim.getReplyDuration());
            wrapper.set(ClaimEntity::getReplyDescription,claim.getReplyDescription());

//            ContractRegisterEntity contractRegisterEntity = contractRegisterService.selectById(claimEntity.getContractId());
//            if (BillPushStatusEnum.推送成功.getStatus().equals(contractRegisterEntity.getBillPushFlag())){
//                //签章洽商索赔更新合同池
//                claimEntity.setReplyTaxMny(claim.getReplyTaxMny());
//                claimEntity.setReplyMny(claim.getReplyMny());
//                claimEntity.setReplyTax(claim.getReplyTax());
//                claimEntity.setReplyStatus(claim.getReplyStatus());
//                boolean pushResult = service.updateContract(claimEntity,true);
//                if(pushResult) {
//                    wrapper.set(ClaimEntity::getBillPushFlag,BillPushStatusEnum.推送成功.getStatus());
//                } else {
//                    wrapper.set(ClaimEntity::getBillPushFlag,BillPushStatusEnum.未成功推送.getStatus());
//                }
//            }

            service.update(wrapper);

            LambdaUpdateWrapper<ClaimRecordsEntity> updateWrapper = new LambdaUpdateWrapper<>();
            updateWrapper.eq(ClaimRecordsEntity::getClaimId,claim.getId());
            updateWrapper.set(ClaimRecordsEntity::getReplyStatus,claim.getReplyStatus());
            claimRecordsService.update(updateWrapper);

            return CommonResponse.success();
        }else{
            return CommonResponse.error("单据不存在！");
        }
    }


    @GetMapping("queryBudgetList")
    @ResponseBody
    public CommonResponse<List<BudgetVO>> queryBudgetList(@RequestParam("id")Long id){
        List<BudgetVO> budgetVOS = budgetService.selectByUseId(id);
        return CommonResponse.success("查询成功",budgetVOS);
    }

    @GetMapping("queryClaimRecordsList")
    @ResponseBody
    public CommonResponse<List<ClaimRecordsVO>> queryClaimRecordsList(@RequestParam("id")Long id){
        List<ClaimRecordsVO> claimRecordsVOS = claimRecordsService.selectByClaimId(id);
        return CommonResponse.success("查询成功",claimRecordsVOS);
    }

    @GetMapping("queryRecordByContractId")
    @ResponseBody
    public CommonResponse<ClaimRecordVO> queryRecordByContractId(@RequestParam("id") Long contractId){
        ClaimRecordVO vo = service.queryRecordByContractId(contractId);
        return CommonResponse.success(vo);
    }

    @PostMapping("connectAppendix")
    @ResponseBody
    public CommonResponse<String> connectAppendix(@RequestBody AttachmentVO vo){
        ArrayList<AttachmentVO> list = new ArrayList();
        vo.setId(null);
        vo.setSourceType("102345678");
        vo.setRowState("add");
        list.add(vo);
        attachmentApi.insertBatch(list);
        return CommonResponse.success();
    }

    /**
     * 关联预算书
     * @param id
     * @return
     */
    @GetMapping("relevanceBudget")
    @ResponseBody
    public CommonResponse relevanceBudget(@RequestParam("id")Long id,@RequestParam("budgetIds")List<Long> budgetIds,@RequestParam("billType")String billType){
        budgetService.relevanceBudget(id,budgetIds,billType);
        return CommonResponse.success("关联成功");
    }

    /**
     * 取消关联预算书
     * @param budgetIds
     * @return
     */
    @GetMapping("deleteRelevanceBudget")
    @ResponseBody
    public CommonResponse deleteRelevanceBudget(@RequestParam("budgetIds")List<Long> budgetIds){
        budgetService.deleteRelevanceBudget(budgetIds);
        return CommonResponse.success("取消关联成功");
    }


    @PostMapping("updateMny")
    @ResponseBody
    public CommonResponse updateMny(@RequestBody ClaimVO claimVO){
        LambdaUpdateWrapper<ClaimEntity> wrapper = new LambdaUpdateWrapper();
        wrapper.eq(ClaimEntity::getId,claimVO.getId());
        wrapper.set(ClaimEntity::getClaimMny,claimVO.getClaimMny());
        wrapper.set(ClaimEntity::getClaimTaxMny,claimVO.getClaimTaxMny());
        wrapper.set(ClaimEntity::getClaimTax,claimVO.getClaimTax());
        service.update(wrapper);
        return CommonResponse.success("更新金额成功");
    }

    /**
     * 同步合同池
     * @param id
     * @return
     */
    @GetMapping(value = "/syncUpdateContract")
    @ResponseBody
    public CommonResponse<Boolean> syncUpdateContract(@RequestParam(value = "id") Long id) {
        ClaimEntity claimEntity = service.selectById(id);
        ContractRegisterEntity contractRegisterEntity = contractRegisterService.selectById(claimEntity.getContractId());
        if (null != contractRegisterEntity){
            if (contractRegisterEntity.getBillPushFlag()==null||contractRegisterEntity.getBillPushFlag().equals(BillPushStatusEnum.未成功推送.getStatus())){
                CommonResponse.error("请先将合同推送至合同池！");
            }
        }else{
            CommonResponse.error("合同不存在！");
        }
        return CommonResponse.success("同步合同池成功！", service.updateContract(claimEntity,true));
    }

    /**
     * @Description 参照
     * @Return void
     */
    @RequestMapping(value = "/refClaimData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<ClaimVO>> refClaimData(@RequestParam(defaultValue = "1") Integer pageNumber
            , @RequestParam(defaultValue = "10") Integer pageSize, @RequestParam(value = "searchText", required = false) String searchText
            , @RequestParam(value = "condition", required = false) String condition) {
        QueryParam queryParam = new QueryParam();
        queryParam.setPageIndex(pageNumber);
        queryParam.setPageSize(pageSize);
        queryParam.setSearchText(searchText);
        /** 模糊搜索配置字段示例 */
        queryParam.getFuzzyFields().add("projectName");
        queryParam.getFuzzyFields().add("contractName");
        queryParam.getFuzzyFields().add("billCode");
        queryParam.getFuzzyFields().add("claimTitle");

        queryParam.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        /** 数据隔离，如果当前登录组织为项目部，查询orgId，否则查询parentOrgId本下 */
        if(OrgVO.ORG_TYPE_DEPARTMENT.toString().equals(InvocationInfoProxy.getOrgType())){
            queryParam.getParams().put("orgId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getOrgId()));
        } else {
            queryParam.getParams().put("parentOrgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentIdWithoutProjectDept(
                    InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        }
        queryParam.getParams().put("bill_state", new Parameter(QueryParam.IN, Arrays.asList(1,3)));
        // 查询已批复的
//        queryParam.getParams().put("reply_status", new Parameter(QueryParam.EQ, CommonConstants.YPF));
//        queryParam.getParams().put("use_flag", new Parameter(QueryParam.NE, CommonConstants.SLZ));
//        ComplexParam useFlag = ParamUtil.getOrParam("useFlag", new Parameter(QueryParam.EQ, null), new Parameter(QueryParam.NE, CommonConstants.SLZ));
//        queryParam.getComplexParams().add(useFlag);
        queryParam.getOrderMap().put("createTime", "desc");

        boolean productType = false;
        Integer registrationUseFlag = null;
        if (StringUtils.isNotEmpty(condition)) {
            Map<String, Object> conditionMap = JSONObject.parseObject(condition, Map.class);
            if (null != conditionMap.get("projectId")) {
                Long projectId = Long.valueOf(conditionMap.get("projectId").toString());
                queryParam.getParams().put("projectId", new Parameter(QueryParam.EQ, projectId));
            }
            if (null != conditionMap.get("contractId")) {
                Long contractId = Long.valueOf(conditionMap.get("contractId").toString());
                queryParam.getParams().put("contractId", new Parameter(QueryParam.EQ, contractId));
            }
            if (null != conditionMap.get("productType")) {
                productType = Boolean.valueOf(conditionMap.get("productType").toString());
            }
            if (null != conditionMap.get("registrationUseFlag")) {
                registrationUseFlag = Integer.valueOf(conditionMap.get("registrationUseFlag").toString());
                queryParam.getParams().put("registrationUseFlag", new Parameter(QueryParam.EQ, registrationUseFlag));
            }

//            if (null != conditionMap.get("applyAdjustDate")) {
//                String applyAdjustDate = conditionMap.get("applyAdjustDate").toString();
//
//                if (null == conditionMap.get("lastApplyAdjustDate")) {
//                    queryParam.getParams().put("commit_date", new Parameter(QueryParam.LE, applyAdjustDate));
//                }else {
//                    String lastApplyAdjustDate = conditionMap.get("lastApplyAdjustDate").toString();
//                    queryParam.getParams().put("commit_date", new Parameter(QueryParam.BETWEEN, lastApplyAdjustDate + "," + applyAdjustDate));
//                }
//            }
//            if (null != conditionMap.get("useFlag")) {
//                int useFlag = Integer.parseInt(conditionMap.get("useFlag").toString());
//                if(useFlag == 0){
//                    // 未被引用
//                    if (null != conditionMap.get("costAdjustId")){
//                        Long costAdjustId = Long.valueOf(conditionMap.get("costAdjustId").toString());
//                        ComplexParam complexParam = ParamUtil.getOrParam("costAdjustId",  new Parameter(QueryParam.EQ, null),new Parameter(QueryParam.EQ, costAdjustId));
//                        queryParam.getComplexParams().add(complexParam);
//                    }else{
//                        queryParam.getParams().put("costAdjustId", new Parameter(QueryParam.EQ, null));
//                    }
//                } else {
//                    // 被引用
//                    queryParam.getParams().put("costAdjustId", new Parameter(QueryParam.NE, null));
//                }
//            }
        }

        logger.info("registrationUseFlag: {}", registrationUseFlag);
        if(null == registrationUseFlag) {
            ComplexParam useFlag = ParamUtil.getOrParam(productType ? "useCzFlag" : "useFlag", new Parameter(QueryParam.EQ, null), new Parameter(QueryParam.NE, CommonConstants.SLZ));
            queryParam.getComplexParams().add(useFlag);
        }

        IPage<ClaimEntity> pageData = service.queryPage(queryParam, false);
        IPage<ClaimVO> result = new Page<>(pageData.getCurrent(), pageData.getSize(), pageData.getTotal());
        List<ClaimVO> list = BeanMapper.mapList(pageData.getRecords(), ClaimVO.class);
        for (ClaimVO vo : list) {
            if (QS.equals(vo.getDjType())) {
                vo.setBillTypeName("变更洽商单");
            }else if (QZ.equals(vo.getDjType())) {
                vo.setBillTypeName("签证");
            }else if (SP.equals(vo.getDjType())) {
                vo.setBillTypeName("索赔");
            }else {
                vo.setBillTypeName(null);
            }

            if ("0".equals(vo.getReplyStatus())) {
                vo.setReplyStatusName("未批复");
            }else if ("1".equals(vo.getReplyStatus())) {
                vo.setReplyStatusName("已批复");
            }else if ("2".equals(vo.getReplyStatus())) {
                vo.setReplyStatusName("未通过");
            }else {
                vo.setReplyStatusName(null);
            }

        }



        result.setRecords(list);
        return CommonResponse.success("查询参照数据成功！", result);
    }


}
