package com.ejianc.business.pro.change.service.impl;

import com.ejianc.business.pro.change.bean.DesignChangeEntity;
import com.ejianc.business.pro.change.service.IDesignChangeService;
import com.ejianc.business.pro.change.vo.DesignChangeVO;
import com.ejianc.business.pro.income.bean.ClaimRecordsEntity;
import com.ejianc.business.pro.income.service.IClaimRecordsService;
import com.ejianc.business.pro.income.vo.ClaimRecordsVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Map;

import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;

@Service("designChange")
public class DesignChangeBpmServiceImpl implements ICommonBusinessService {

	@Autowired
	private IClaimRecordsService claimservice;

	@Autowired
	IDesignChangeService service;
    /**
     * 提交前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO
        return CommonResponse.success();
    }

    ;

    /**
     * 提交完回调
     *
     * @param
     * @return
     */
    @Override
    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO
        return CommonResponse.success();
    }

    /**
     * 有审批流的撤回前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    ;

    /**
     * 有审批流的撤回后回调
     *
     * @param
     * @return
     */
    @Override
    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    ;

    /**
     * 审批节点审批中时节点审批前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    ;

    /**
     * 审批节点审批中时节点审批后回调
     *
     * @param billId       //单据id
     * @param state        //单据状态
     * @param billTypeCode //单据类型code
     * @param taskId       //该流程id
     * @param isEnd        //该节点是否结束
     * @return
     */
    @Override
    public CommonResponse<String> afterInApprovalBack(Long billId, Integer state, String billTypeCode, String taskId, Boolean isEnd, String sign, Map<String, Object> other) {
        return CommonResponse.success();
    }

    ;

    /**
     * 终审审核前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO
        return CommonResponse.success();
    }

    /**
     * 终审审核完回调
     *
     * @param
     * @return
     */
    @Override
    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		DesignChangeEntity entity = service.selectById(billId);
		DesignChangeVO vo = BeanMapper.map(entity, DesignChangeVO.class);
		ClaimRecordsVO claimRecordsVO = new ClaimRecordsVO();
        claimRecordsVO.setEmployeeName(vo.getManagerName());
        claimRecordsVO.setOrgId(vo.getOrgId());
        claimRecordsVO.setOrgName(vo.getOrgName());
        claimRecordsVO.setProjectId(vo.getProjectId());
        claimRecordsVO.setProjectName(vo.getProjectName());
        claimRecordsVO.setParentOrgName(vo.getSecondaryUnits());
        claimRecordsVO.setOwnerName(vo.getSecondaryUnits());
        claimRecordsVO.setClaimTitle(vo.getContactFormName());
        claimRecordsVO.setHappenDate(vo.getDocumentTime());
        claimRecordsVO.setExplainText(vo.getDescriptionChanges());
        ClaimRecordsEntity insert = claimservice.insert(claimRecordsVO);
        if (insert == null || insert.getId() == null) {
            throw new BusinessException("网络异常， 创建合同签证记录失败， 请稍后再试");
        }
        //ClaimRecordsEntity claimRecords = claimservice.getById(insert.getId());
        String claimCode = insert.getBillCode();
        entity.setContractorVisaRecord(claimCode);
        vo.setContractorVisaRecord(claimCode);
        return CommonResponse.success();
    }

    /**
     * 弃审前事件回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO
        return CommonResponse.success();
    }

    /**
     * 弃审后事件回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO
        return CommonResponse.success();
    }

}
