/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.pro.income.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.pro.income.bean.SettleReportEntity;
import com.ejianc.business.pro.income.service.ISettleReportService;
import com.ejianc.business.pro.income.vo.SettleReportVO;
import com.ejianc.foundation.share.api.IProjectSetApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import com.ejianc.framework.skeleton.template.BaseEntity;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="settleReport")
public class SettleReportBpmServiceImpl
implements ICommonBusinessService {
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private ISettleReportService service;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IProjectSetApi projectSetApi;

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        SettleReportEntity entity = (SettleReportEntity)((Object)this.service.selectById(billId));
        SettleReportVO settlementVO = (SettleReportVO)BeanMapper.map((Object)((Object)entity), SettleReportVO.class);
        boolean pool = this.service.pushSettleToPool(settlementVO);
        if (!pool) {
            return CommonResponse.error((String)"\u63a8\u9001\u7ed3\u7b97\u6c60\u5931\u8d25");
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        SettleReportEntity entity = (SettleReportEntity)((Object)this.service.selectById(billId));
        CommonResponse res = this.projectSetApi.changeProjectStatus(entity.getProjectId(), null, null, "8", null, null);
        if (!res.isSuccess()) {
            this.logger.info("\u7ed3\u7b97\u62a5\u5ba1\u3010{}\u3011\u66f4\u65b0\u3010\u9879\u76ee\u6c60\u3011\u7ed3\u7b97\u72b6\u6001\u4e3a\u7ed3\u7b97\u4e2d\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a{}", (Object)entity.getBillCode(), (Object)res.getMsg());
            throw new BusinessException("\u7ed3\u7b97\u62a5\u5ba1\u3010" + entity.getBillCode() + "\u3011\u66f4\u65b0\u3010\u9879\u76ee\u6c60\u3011\u7ed3\u7b97\u72b6\u6001\u4e3a\u7ed3\u7b97\u4e2d\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a" + res.getMsg());
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        CommonResponse res = this.billTypeApi.checkQuote(billTypeCode, billId);
        this.logger.info("\u5e73\u53f0\u8fd4\u56de\u67e5\u8be2\u88ab\u5f15\u7528\u60c5\u51b5" + res.isSuccess() + "----" + res.getMsg());
        if (!res.isSuccess()) {
            return CommonResponse.error((String)res.getMsg());
        }
        SettleReportEntity settleReportEntity = (SettleReportEntity)((Object)this.service.selectById(billId));
        LambdaQueryWrapper lambda = new LambdaQueryWrapper();
        lambda.eq(BaseEntity::getTenantId, (Object)InvocationInfoProxy.getTenantid());
        lambda.eq(BaseEntity::getDr, (Object)0);
        lambda.ne(BaseEntity::getId, (Object)billId);
        lambda.eq(SettleReportEntity::getContractId, (Object)settleReportEntity.getContractId());
        lambda.notIn(SettleReportEntity::getBillState, new Object[]{1, 3});
        List list = this.service.list((Wrapper)lambda);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            throw new BusinessException("\u5f53\u524d\u5408\u540c\u4e0b\u5b58\u5728\u975e\u5ba1\u6279\u901a\u8fc7\u6001\u7684\u7ed3\u7b97\u62a5\u5ba1\uff0c\u4e0d\u5141\u8bb8\u64a4\u56de!");
        }
        boolean pool = this.service.delSettleFromPool(billId);
        if (!pool) {
            return CommonResponse.error((String)"\u5f03\u5ba1\u63a8\u9001\u7ed3\u7b97\u6c60\u5931\u8d25");
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }
}

