package com.ejianc.business.pro.income.bean;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.business.pro.income.vo.BudgetCostElectricVO;
import com.ejianc.business.pro.income.vo.BudgetQuantitiesElectricVO;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import com.ejianc.business.pro.income.bean.BudgetSubEntity;
import com.ejianc.business.pro.income.bean.BudgetMeasureEntity;
import com.ejianc.business.pro.income.bean.BudgetOtherEntity;
import com.ejianc.business.pro.income.bean.BudgetFeeEntity;
import com.ejianc.business.pro.income.bean.BudgetCostEntity;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 项目预算书
 * 
 * @author generator
 * 
 */
 @TableName("ejc_income_budget")
public class BudgetEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="budget_model")
    private Integer budgetModel; // 模式,0-清单模式，1-费用项模式，2-郑州一建预算清单
    @TableField(value="bill_code")
    private String billCode; // 单据编号
    @TableField(value="org_id")
    private Long orgId; // 组织
    @TableField(value="org_code")
    private String orgCode; // 组织编码
    @TableField(value="org_name")
    private String orgName; // 组织名称
    @TableField(value="parent_org_id")
    private Long parentOrgId; // 所属组织
    @TableField(value="parent_org_code")
    private String parentOrgCode; // 所属组织编码
    @TableField(value="parent_org_name")
    private String parentOrgName; // 所属组织名称
    @TableField(value="project_id")
    private Long projectId; // 项目
    @TableField(value="project_code")
    private String projectCode; // 项目编码
    @TableField(value="project_name")
    private String projectName; // 项目名称
    @TableField(value="contract_id")
    private Long contractId; // 合同
    @TableField(value="contract_code")
    private String contractCode; // 合同编码
    @TableField(value="contract_name")
    private String contractName; // 合同名称
    @TableField(value="budget_name")
    private String budgetName; // 预算书名称
    @TableField(value="budget_source")
    private Integer budgetSource; // 预算来源:0-合同，1-变更，2-签证，3-索赔，4-审定预算书，5-其它
    @TableField(value="budget_category_id")
    private Long budgetCategoryId; // 预算分类
    @TableField(value="budget_category_name")
    private String budgetCategoryName; // 预算分类名称
    @TableField(value="income_flag")
    private Integer incomeFlag; // 是否收入：0-否，1-是
    @TableField(value="tax_rate")
    private BigDecimal taxRate; // 税率
    @TableField(value="budget_mny")
    private BigDecimal budgetMny; // 金额(无税)
    @TableField(value="budget_tax_mny")
    private BigDecimal budgetTaxMny; // 金额(含税) --- 预算内部审定金额
    @TableField(value="budget_tax")
    private BigDecimal budgetTax; // 税额
    @TableField(value="accounting_id")
    private Long accountingId; // 核算对象
    @TableField(value="accounting_name")
    private String accountingName; // 核算对象名称
    @TableField(value="employee_id")
    private Long employeeId; // 经办人
    @TableField(value="employee_name")
    private String employeeName; // 经办人名称
    @TableField(value="dept_id")
    private Long deptId; // 经办部门
    @TableField(value="dept_name")
    private String deptName; // 经办部门名称
    @TableField(value="sub_total_mny")
    private BigDecimal subTotalMny; // 分部分项金额(无税)
    @TableField(value="sub_total_tax_mny")
    private BigDecimal subTotalTaxMny; // 分部分项金额(含税)
    @TableField(value="sub_total_tax")
    private BigDecimal subTotalTax; // 分部分项税额
    @TableField(value="measure_total_mny")
    private BigDecimal measureTotalMny; // 措施项金额(无税)
    @TableField(value="measure_total_tax_mny")
    private BigDecimal measureTotalTaxMny; // 措施项金额(含税)
    @TableField(value="measure_total_tax")
    private BigDecimal measureTotalTax; // 措施项税额
    @TableField(value="other_total_mny")
    private BigDecimal otherTotalMny; // 其它项金额(无税)
    @TableField(value="other_total_tax_mny")
    private BigDecimal otherTotalTaxMny; // 其它项金额(含税)
    @TableField(value="other_total_tax")
    private BigDecimal otherTotalTax; // 其它项税额
    @TableField(value="fee_total_mny")
    private BigDecimal feeTotalMny; // 费税金额(无税)
    @TableField(value="fee_total_tax_mny")
    private BigDecimal feeTotalTaxMny; // 费税金额(含税)
    @TableField(value="fee_total_tax")
    private BigDecimal feeTotalTax; // 费税税额
    @TableField(value="bill_state")
    private Integer billState; // 单据状态
    @TableField(value="use_type")
    private String useType; // 引用类型(QS-洽商，QZ-签证，SP-索赔)
    @TableField(value="use_id")
    private Long useId; // 引用主键

    @TableField(value="contract_mny")
    private BigDecimal contractMny; // 合同金额(无税)
    @TableField(value="contract_tax_mny")
    private BigDecimal contractTaxMny; // 合同金额(含税)
    @TableField(value="customer_id")
    private Long customerId; // 发包单位
    @TableField(value="customer_name")
    private String customerName; // 发包单位名称
    @TableField(value="project_scale")
    private String projectScale; // 工程规模
    @TableField(value="contract_valuation_type")
    private Long contractValuationType; // 计价方式
    @TableField(value="reply_state")
    private String replyState; // 是否需要甲方审核：0-否，1-是
    @TableField(value="budget_type")
    private String budgetType; // 预算类型：1-施工图预算，2-补充协议预算，3-其他
    @TableField(value="budget_description")
    private String budgetDescription; // 预算书描述
    @TableField(value="apply_mny")
    private BigDecimal applyMny; // 预算报审金额(无税)
    @TableField(value="apply_tax_mny")
    private BigDecimal applyTaxMny; // 预算报审金额(含税)
    @TableField(value="memo")
    private String memo; // 备注
    @TableField(value = "reply_date")
    private Date replyDate; // 甲方批复日期
    @TableField(value="reply_mny")
    private BigDecimal replyMny; // 甲方批复金额(无税)
    @TableField(value="reply_tax_mny")
    private BigDecimal replyTaxMny; // 甲方批复金额(含税)
    @TableField(value="reply_memo")
    private String replyMemo; // 甲方批复说明

    @TableField(value = "subject_org_category_name")
    private String subjectOrgCategoryName;//项目成本专业类型名称
    @TableField(value = "subject_org_category_id")
    private String subjectOrgCategoryId;//项目成本专业类型id
    /**
     * 提交日期
     */
    @TableField("commit_date")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date commitDate;


    @TableField(exist=false)
    @SubEntity(serviceName="budgetSubService",pidName = "budgetId")
    private List<BudgetSubEntity> subVos = new ArrayList<>(); // 分部分项清单
    @TableField(exist=false)
    @SubEntity(serviceName="budgetMeasureService",pidName = "budgetId")
    private List<BudgetMeasureEntity> measureVos = new ArrayList<>(); // 措施项清单
    @TableField(exist=false)
    @SubEntity(serviceName="budgetOtherService",pidName = "budgetId")
    private List<BudgetOtherEntity> otherVos = new ArrayList<>(); // 其他项清单
    @TableField(exist=false)
    @SubEntity(serviceName="budgetFeeService",pidName = "budgetId")
    private List<BudgetFeeEntity> feeVos = new ArrayList<>(); // 费税清单
    @TableField(exist=false)
    @SubEntity(serviceName="budgetCostService",pidName = "budgetId")
    private List<BudgetCostEntity> costVos = new ArrayList<>(); // 费用项清单
    @TableField(exist=false)
    @SubEntity(serviceName="budgetNumService",pidName = "budgetId")
    private List<BudgetNumEntity> numVos = new ArrayList<>(); // 工程量指标
    @TableField(exist=false)
    @SubEntity(serviceName="budgetPriceService",pidName = "budgetId")
    private List<BudgetPriceEntity> priceVos = new ArrayList<>(); // 造价指标

    @TableField(exist = false)
    @SubEntity(serviceName = "budgetQuantitiesElectricService", pidName = "budgetId")
    private List<BudgetQuantitiesElectricEntity> electricQuantitiesVos = new ArrayList<>(); // 造价指标

    @TableField(exist = false)
    @SubEntity(serviceName = "budgetCostElectricService", pidName = "budgetId")
    private List<BudgetCostElectricEntity> electricCostVos = new ArrayList<>(); // 造价指标

    public Date getCommitDate() {
        return commitDate;
    }

    public void setCommitDate(Date commitDate) {
        this.commitDate = commitDate;
    }

    public String getSubjectOrgCategoryName() {
        return subjectOrgCategoryName;
    }

    public void setSubjectOrgCategoryName(String subjectOrgCategoryName) {
        this.subjectOrgCategoryName = subjectOrgCategoryName;
    }

    public String getSubjectOrgCategoryId() {
        return subjectOrgCategoryId;
    }

    public void setSubjectOrgCategoryId(String subjectOrgCategoryId) {
        this.subjectOrgCategoryId = subjectOrgCategoryId;
    }

    public List<BudgetQuantitiesElectricEntity> getElectricQuantitiesVos() {
        return electricQuantitiesVos;
    }

    public void setElectricQuantitiesVos(List<BudgetQuantitiesElectricEntity> electricQuantitiesVos) {
        this.electricQuantitiesVos = electricQuantitiesVos;
    }

    public List<BudgetCostElectricEntity> getElectricCostVos() {
        return electricCostVos;
    }

    public void setElectricCostVos(List<BudgetCostElectricEntity> electricCostVos) {
        this.electricCostVos = electricCostVos;
    }

    public BigDecimal getBudgetTax() {
        return budgetTax;
    }

    public void setBudgetTax(BigDecimal budgetTax) {
        this.budgetTax = budgetTax;
    }

    public BigDecimal getSubTotalTax() {
        return subTotalTax;
    }

    public void setSubTotalTax(BigDecimal subTotalTax) {
        this.subTotalTax = subTotalTax;
    }

    public BigDecimal getMeasureTotalTax() {
        return measureTotalTax;
    }

    public void setMeasureTotalTax(BigDecimal measureTotalTax) {
        this.measureTotalTax = measureTotalTax;
    }

    public BigDecimal getOtherTotalTax() {
        return otherTotalTax;
    }

    public void setOtherTotalTax(BigDecimal otherTotalTax) {
        this.otherTotalTax = otherTotalTax;
    }

    public BigDecimal getFeeTotalTax() {
        return feeTotalTax;
    }

    public void setFeeTotalTax(BigDecimal feeTotalTax) {
        this.feeTotalTax = feeTotalTax;
    }

    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }

    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }

    /**
     * 模式,0-清单模式，1-费用项模式
     */
    public Integer getBudgetModel() {
        return budgetModel;
    }

    /**
     * 模式,0-清单模式，1-费用项模式
     */
    public void setBudgetModel(Integer budgetModel) {
        this.budgetModel = budgetModel;
    }
    /**
     * 单据编号
     */
    public String getBillCode() {
        return billCode;
    }

    /**
     * 单据编号
     */
    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    /**
     * 组织
     */
    public Long getOrgId() {
        return orgId;
    }

    /**
     * 组织
     */
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    /**
     * 组织名称
     */
    public String getOrgName() {
        return orgName;
    }

    /**
     * 组织名称
     */
    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    /**
     * 所属组织
     */
    public Long getParentOrgId() {
        return parentOrgId;
    }

    /**
     * 所属组织
     */
    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    /**
     * 所属组织名称
     */
    public String getParentOrgName() {
        return parentOrgName;
    }

    /**
     * 所属组织名称
     */
    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    /**
     * 项目
     */
    public Long getProjectId() {
        return projectId;
    }

    /**
     * 项目
     */
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    /**
     * 项目编码
     */
    public String getProjectCode() {
        return projectCode;
    }

    /**
     * 项目编码
     */
    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    /**
     * 项目名称
     */
    public String getProjectName() {
        return projectName;
    }

    /**
     * 项目名称
     */
    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    /**
     * 合同
     */
    public Long getContractId() {
        return contractId;
    }

    /**
     * 合同
     */
    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }
    /**
     * 合同编码
     */
    public String getContractCode() {
        return contractCode;
    }

    /**
     * 合同编码
     */
    public void setContractCode(String contractCode) {
        this.contractCode = contractCode;
    }
    /**
     * 合同名称
     */
    public String getContractName() {
        return contractName;
    }

    /**
     * 合同名称
     */
    public void setContractName(String contractName) {
        this.contractName = contractName;
    }
    /**
     * 预算书名称
     */
    public String getBudgetName() {
        return budgetName;
    }

    /**
     * 预算书名称
     */
    public void setBudgetName(String budgetName) {
        this.budgetName = budgetName;
    }
    /**
     * 预算来源:0-合同，1-变更，2-签证，3-索赔，4-审定预算书，5-其它
     */
    public Integer getBudgetSource() {
        return budgetSource;
    }

    /**
     * 预算来源:0-合同，1-变更，2-签证，3-索赔，4-审定预算书，5-其它
     */
    public void setBudgetSource(Integer budgetSource) {
        this.budgetSource = budgetSource;
    }
    /**
     * 预算分类
     */
    public Long getBudgetCategoryId() {
        return budgetCategoryId;
    }

    /**
     * 预算分类
     */
    public void setBudgetCategoryId(Long budgetCategoryId) {
        this.budgetCategoryId = budgetCategoryId;
    }
    /**
     * 预算分类名称
     */
    public String getBudgetCategoryName() {
        return budgetCategoryName;
    }

    /**
     * 预算分类名称
     */
    public void setBudgetCategoryName(String budgetCategoryName) {
        this.budgetCategoryName = budgetCategoryName;
    }
    /**
     * 是否收入：0-否，1-是
     */
    public Integer getIncomeFlag() {
        return incomeFlag;
    }

    /**
     * 是否收入：0-否，1-是
     */
    public void setIncomeFlag(Integer incomeFlag) {
        this.incomeFlag = incomeFlag;
    }
    /**
     * 税率
     */
    public BigDecimal getTaxRate() {
        return taxRate;
    }

    /**
     * 税率
     */
    public void setTaxRate(BigDecimal taxRate) {
        this.taxRate = taxRate;
    }
    /**
     * 金额(无税)
     */
    public BigDecimal getBudgetMny() {
        return budgetMny;
    }

    /**
     * 金额(无税)
     */
    public void setBudgetMny(BigDecimal budgetMny) {
        this.budgetMny = budgetMny;
    }
    /**
     * 金额(含税)
     */
    public BigDecimal getBudgetTaxMny() {
        return budgetTaxMny;
    }

    /**
     * 金额(含税)
     */
    public void setBudgetTaxMny(BigDecimal budgetTaxMny) {
        this.budgetTaxMny = budgetTaxMny;
    }
    /**
     * 核算对象
     */
    public Long getAccountingId() {
        return accountingId;
    }

    /**
     * 核算对象
     */
    public void setAccountingId(Long accountingId) {
        this.accountingId = accountingId;
    }
    /**
     * 核算对象名称
     */
    public String getAccountingName() {
        return accountingName;
    }

    /**
     * 核算对象名称
     */
    public void setAccountingName(String accountingName) {
        this.accountingName = accountingName;
    }
    /**
     * 经办人
     */
    public Long getEmployeeId() {
        return employeeId;
    }

    /**
     * 经办人
     */
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    /**
     * 经办人名称
     */
    public String getEmployeeName() {
        return employeeName;
    }

    /**
     * 经办人名称
     */
    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    /**
     * 经办部门
     */
    public Long getDeptId() {
        return deptId;
    }

    /**
     * 经办部门
     */
    public void setDeptId(Long deptId) {
        this.deptId = deptId;
    }
    /**
     * 经办部门名称
     */
    public String getDeptName() {
        return deptName;
    }

    /**
     * 经办部门名称
     */
    public void setDeptName(String deptName) {
        this.deptName = deptName;
    }

    public BigDecimal getSubTotalMny() {
        return subTotalMny;
    }

    public void setSubTotalMny(BigDecimal subTotalMny) {
        this.subTotalMny = subTotalMny;
    }

    public BigDecimal getSubTotalTaxMny() {
        return subTotalTaxMny;
    }

    public void setSubTotalTaxMny(BigDecimal subTotalTaxMny) {
        this.subTotalTaxMny = subTotalTaxMny;
    }

    public BigDecimal getMeasureTotalMny() {
        return measureTotalMny;
    }

    public void setMeasureTotalMny(BigDecimal measureTotalMny) {
        this.measureTotalMny = measureTotalMny;
    }

    public BigDecimal getMeasureTotalTaxMny() {
        return measureTotalTaxMny;
    }

    public void setMeasureTotalTaxMny(BigDecimal measureTotalTaxMny) {
        this.measureTotalTaxMny = measureTotalTaxMny;
    }

    public BigDecimal getOtherTotalMny() {
        return otherTotalMny;
    }

    public void setOtherTotalMny(BigDecimal otherTotalMny) {
        this.otherTotalMny = otherTotalMny;
    }

    public BigDecimal getOtherTotalTaxMny() {
        return otherTotalTaxMny;
    }

    public void setOtherTotalTaxMny(BigDecimal otherTotalTaxMny) {
        this.otherTotalTaxMny = otherTotalTaxMny;
    }

    public BigDecimal getFeeTotalMny() {
        return feeTotalMny;
    }

    public void setFeeTotalMny(BigDecimal feeTotalMny) {
        this.feeTotalMny = feeTotalMny;
    }

    public BigDecimal getFeeTotalTaxMny() {
        return feeTotalTaxMny;
    }

    public void setFeeTotalTaxMny(BigDecimal feeTotalTaxMny) {
        this.feeTotalTaxMny = feeTotalTaxMny;
    }

    /**
     * 单据状态
     */
    public Integer getBillState() {
        return billState;
    }

    /**
     * 单据状态
     */
    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    /**
     * 引用类型(QS-洽商，QZ-签证，SP-索赔)
     */
    public String getUseType() {
        return useType;
    }

    /**
     * 引用类型(QS-洽商，QZ-签证，SP-索赔)
     */
    public void setUseType(String useType) {
        this.useType = useType;
    }
    /**
     * 引用主键
     */
    public Long getUseId() {
        return useId;
    }

    /**
     * 引用主键
     */
    public void setUseId(Long useId) {
        this.useId = useId;
    }

    public BigDecimal getContractMny() {
        return contractMny;
    }

    public void setContractMny(BigDecimal contractMny) {
        this.contractMny = contractMny;
    }

    public BigDecimal getContractTaxMny() {
        return contractTaxMny;
    }

    public void setContractTaxMny(BigDecimal contractTaxMny) {
        this.contractTaxMny = contractTaxMny;
    }

    public Long getCustomerId() {
        return customerId;
    }

    public void setCustomerId(Long customerId) {
        this.customerId = customerId;
    }

    public String getCustomerName() {
        return customerName;
    }

    public void setCustomerName(String customerName) {
        this.customerName = customerName;
    }

    public String getProjectScale() {
        return projectScale;
    }

    public void setProjectScale(String projectScale) {
        this.projectScale = projectScale;
    }

    public Long getContractValuationType() {
        return contractValuationType;
    }

    public void setContractValuationType(Long contractValuationType) {
        this.contractValuationType = contractValuationType;
    }

    public String getReplyState() {
        return replyState;
    }

    public void setReplyState(String replyState) {
        this.replyState = replyState;
    }

    public String getBudgetType() {
        return budgetType;
    }

    public void setBudgetType(String budgetType) {
        this.budgetType = budgetType;
    }

    public String getBudgetDescription() {
        return budgetDescription;
    }

    public void setBudgetDescription(String budgetDescription) {
        this.budgetDescription = budgetDescription;
    }

    public BigDecimal getApplyMny() {
        return applyMny;
    }

    public void setApplyMny(BigDecimal applyMny) {
        this.applyMny = applyMny;
    }

    public BigDecimal getApplyTaxMny() {
        return applyTaxMny;
    }

    public void setApplyTaxMny(BigDecimal applyTaxMny) {
        this.applyTaxMny = applyTaxMny;
    }

    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public Date getReplyDate() {
        return replyDate;
    }

    public void setReplyDate(Date replyDate) {
        this.replyDate = replyDate;
    }

    public BigDecimal getReplyMny() {
        return replyMny;
    }

    public void setReplyMny(BigDecimal replyMny) {
        this.replyMny = replyMny;
    }

    public BigDecimal getReplyTaxMny() {
        return replyTaxMny;
    }

    public void setReplyTaxMny(BigDecimal replyTaxMny) {
        this.replyTaxMny = replyTaxMny;
    }

    public String getReplyMemo() {
        return replyMemo;
    }

    public void setReplyMemo(String replyMemo) {
        this.replyMemo = replyMemo;
    }

    public List<BudgetSubEntity> getSubVos() {
        return subVos;
    }

    public void setSubVos(List<BudgetSubEntity> subVos) {
        this.subVos = subVos;
    }

    public List<BudgetMeasureEntity> getMeasureVos() {
        return measureVos;
    }

    public void setMeasureVos(List<BudgetMeasureEntity> measureVos) {
        this.measureVos = measureVos;
    }

    public List<BudgetOtherEntity> getOtherVos() {
        return otherVos;
    }

    public void setOtherVos(List<BudgetOtherEntity> otherVos) {
        this.otherVos = otherVos;
    }

    public List<BudgetFeeEntity> getFeeVos() {
        return feeVos;
    }

    public void setFeeVos(List<BudgetFeeEntity> feeVos) {
        this.feeVos = feeVos;
    }

    public List<BudgetCostEntity> getCostVos() {
        return costVos;
    }

    public void setCostVos(List<BudgetCostEntity> costVos) {
        this.costVos = costVos;
    }

    public List<BudgetNumEntity> getNumVos() {
        return numVos;
    }

    public void setNumVos(List<BudgetNumEntity> numVos) {
        this.numVos = numVos;
    }

    public List<BudgetPriceEntity> getPriceVos() {
        return priceVos;
    }

    public void setPriceVos(List<BudgetPriceEntity> priceVos) {
        this.priceVos = priceVos;
    }
}
