/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.pro.income.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.pro.income.bean.BudgetDetailEntity;
import com.ejianc.business.pro.income.enums.ExcelDetailTypeEnum;
import com.ejianc.business.pro.income.mapper.BudgetDetailMapper;
import com.ejianc.business.pro.income.service.IBudgetDetailService;
import com.ejianc.business.pro.income.vo.BudgetDetailVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="budgetDetailService")
public class BudgetDetailServiceImpl
extends BaseServiceImpl<BudgetDetailMapper, BudgetDetailEntity>
implements IBudgetDetailService {
    @Autowired
    private BudgetDetailMapper mapper;

    @Override
    public void delDetailByBudgetId(Long budgetId) {
        ((BudgetDetailMapper)this.baseMapper).delete((Wrapper)new QueryWrapper().eq((Object)"budget_id", (Object)budgetId));
    }

    @Override
    public void delDetailBatchByBudgetId(List<Long> ids) {
        ((BudgetDetailMapper)this.baseMapper).delete((Wrapper)new QueryWrapper().in((Object)"budget_id", ids));
    }

    @Override
    public List<BudgetDetailVO> queryDetailList(Long budgetBid) {
        LambdaQueryWrapper lambd = new LambdaQueryWrapper();
        lambd.eq(BudgetDetailEntity::getBudgetBid, (Object)budgetBid);
        List list = super.list((Wrapper)lambd);
        return BeanMapper.mapList((Iterable)list, BudgetDetailVO.class);
    }

    @Override
    public List<BudgetDetailEntity> queryDetailByBudgetIds(List<Long> budegtIds) {
        return ((BudgetDetailMapper)this.baseMapper).selectList((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"dr", (Object)0)).in((Object)"budget_id", budegtIds));
    }

    @Override
    public List<BudgetDetailVO> queryUnSubjectListByBudgetId(Long budgetId) {
        List<Long> excludePids = this.getHasSubjectDetailIds(budgetId);
        List<Object> resp = new ArrayList<BudgetDetailVO>();
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"budget_id", (Object)budgetId);
        query.eq((Object)"leaf_flag", (Object)true);
        query.notIn((Object)"detail_item_type", (Object[])new String[]{ExcelDetailTypeEnum.\u5b9a\u989d_\u5355\u4ef7\u6784\u6210.getCode(), ExcelDetailTypeEnum.\u5b9a\u989d.getCode()});
        query.isNull((Object)"detail_subject_id");
        if (CollectionUtils.isNotEmpty(excludePids)) {
            query.notIn((Object)"parent_id", excludePids);
        }
        query.groupBy((Object[])new String[]{"detail_code"});
        List detailList = super.list((Wrapper)query);
        if (CollectionUtils.isNotEmpty((Collection)detailList)) {
            resp = BeanMapper.mapList((Iterable)detailList, BudgetDetailVO.class);
        }
        return resp;
    }

    private List<Long> getHasSubjectDetailIds(Long budgetId) {
        return this.mapper.getHasSubjectDetailIds(budgetId);
    }

    @Override
    public void saveDetailSubjectInfo(List<BudgetDetailVO> saveList) {
        List<Long> excludePids = this.getHasSubjectDetailIds(saveList.get(0).getBudgetId());
        Map<String, BudgetDetailVO> codeMap = saveList.stream().filter(item -> null != item.getDetailSubjectId()).collect(Collectors.toMap(BudgetDetailVO::getDetailCode, item -> item));
        if (MapUtils.isNotEmpty(codeMap)) {
            List detailList;
            QueryWrapper query = new QueryWrapper();
            query.eq((Object)"budget_id", (Object)saveList.get(0).getBudgetId());
            query.eq((Object)"leaf_flag", (Object)true);
            query.in((Object)"detail_code", codeMap.keySet());
            query.notIn((Object)"detail_item_type", (Object[])new String[]{ExcelDetailTypeEnum.\u5b9a\u989d_\u5355\u4ef7\u6784\u6210.getCode(), ExcelDetailTypeEnum.\u5b9a\u989d.getCode()});
            query.isNull((Object)"detail_subject_id");
            if (CollectionUtils.isNotEmpty(excludePids)) {
                query.notIn((Object)"parent_id", excludePids);
            }
            if (CollectionUtils.isNotEmpty((Collection)(detailList = super.list((Wrapper)query)))) {
                detailList.stream().forEach(item -> {
                    item.setDetailSubjectId(((BudgetDetailVO)codeMap.get(item.getDetailCode())).getDetailSubjectId());
                    item.setDetailSubjectName(((BudgetDetailVO)codeMap.get(item.getDetailCode())).getDetailSubjectName());
                });
                super.saveOrUpdateBatch(detailList, detailList.size(), false);
            }
        }
    }
}

