/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.pro.income.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.contractbase.pool.contractpool.api.IContractPoolApi;
import com.ejianc.business.contractbase.pool.contractpool.vo.ContractPoolVO;
import com.ejianc.business.contractbase.pool.enums.UpdateLevelEnum;
import com.ejianc.business.pro.income.bean.ClaimEntity;
import com.ejianc.business.pro.income.bean.ContractRegisterEntity;
import com.ejianc.business.pro.income.bean.FinalizedEntity;
import com.ejianc.business.pro.income.bean.ProductionEntity;
import com.ejianc.business.pro.income.bean.QuoteEntity;
import com.ejianc.business.pro.income.mapper.ClaimMapper;
import com.ejianc.business.pro.income.mapper.ContractRegisterMapper;
import com.ejianc.business.pro.income.service.IClaimService;
import com.ejianc.business.pro.income.service.IContractRegisterService;
import com.ejianc.business.pro.income.service.IFinalizedService;
import com.ejianc.business.pro.income.service.IProductionService;
import com.ejianc.business.pro.income.service.IQuoteService;
import com.ejianc.business.pro.income.utils.CommonUtils;
import com.ejianc.business.pro.income.utils.MathUtil;
import com.ejianc.business.pro.income.vo.ClaimRecordVO;
import com.ejianc.business.pro.income.vo.ClaimVO;
import com.ejianc.business.pro.income.vo.ReportVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="claimService")
public class ClaimServiceImpl
extends BaseServiceImpl<ClaimMapper, ClaimEntity>
implements IClaimService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IContractRegisterService registerService;
    @Autowired
    private IClaimService claimService;
    @Autowired
    private IProductionService productionService;
    @Autowired
    private IQuoteService quoteService;
    @Autowired
    private IFinalizedService finalizedService;
    @Autowired
    private ContractRegisterMapper contractRegisterMapper;
    @Autowired
    private IContractPoolApi contractPoolApi;
    @Autowired
    private IContractRegisterService contractRegisterService;

    @Override
    public ClaimRecordVO queryRecordByContractId(Long contractId) {
        ContractRegisterEntity entity = (ContractRegisterEntity)((Object)this.registerService.selectById(contractId));
        ClaimRecordVO claimRecordVO = new ClaimRecordVO();
        claimRecordVO.setChangeStatus(entity.getChangeStatus());
        claimRecordVO.setIsFinish(entity.getIsFinish());
        claimRecordVO.setIsRelieve(entity.getIsRelieve());
        claimRecordVO.setIsSuspend(entity.getIsSuspend());
        LambdaUpdateWrapper wrapper = new LambdaUpdateWrapper();
        wrapper.eq(ClaimEntity::getContractId, (Object)contractId);
        wrapper.eq(BaseEntity::getDr, (Object)0);
        wrapper.in(ClaimEntity::getBillState, new Object[]{1, 3});
        wrapper.eq(BaseEntity::getTenantId, (Object)InvocationInfoProxy.getTenantid());
        List list = this.list((Wrapper)wrapper);
        BigDecimal sumNegotiateMny = BigDecimal.ZERO;
        BigDecimal sumNegotiateTaxMny = BigDecimal.ZERO;
        BigDecimal sumVisaMny = BigDecimal.ZERO;
        BigDecimal sumVisaTaxMny = BigDecimal.ZERO;
        BigDecimal sumClaimMny = BigDecimal.ZERO;
        BigDecimal sumClaimTaxMny = BigDecimal.ZERO;
        BigDecimal sumMny = BigDecimal.ZERO;
        BigDecimal sumTaxMny = BigDecimal.ZERO;
        List claimVOS = new ArrayList();
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            claimVOS = BeanMapper.mapList((Iterable)list, ClaimVO.class);
            for (ClaimVO vo : claimVOS) {
                if ("QS".equals(vo.getBillType())) {
                    vo.setBillType("\u53d8\u66f4\u6d3d\u5546\u5355");
                    sumNegotiateMny = MathUtil.safeAdd(sumNegotiateMny, vo.getClaimMny());
                    sumNegotiateTaxMny = MathUtil.safeAdd(sumNegotiateTaxMny, vo.getClaimTaxMny());
                } else if ("QZ".equals(vo.getBillType())) {
                    vo.setBillType("\u7ecf\u6d4e\u7b7e\u8bc1\u5355");
                    sumVisaMny = MathUtil.safeAdd(sumVisaMny, vo.getClaimMny());
                    sumVisaTaxMny = MathUtil.safeAdd(sumVisaTaxMny, vo.getClaimTaxMny());
                } else if ("SP".equals(vo.getBillType())) {
                    vo.setBillType("\u7d22\u8d54\u5355");
                    sumClaimMny = MathUtil.safeAdd(sumClaimMny, vo.getClaimMny());
                    sumClaimTaxMny = MathUtil.safeAdd(sumClaimTaxMny, vo.getClaimTaxMny());
                }
                sumMny = MathUtil.safeAdd(sumMny, vo.getClaimMny());
                sumTaxMny = MathUtil.safeAdd(sumTaxMny, vo.getClaimTaxMny());
            }
        }
        claimRecordVO.setContractId(contractId);
        claimRecordVO.setSumNegotiateMny(sumNegotiateMny);
        claimRecordVO.setSumNegotiateTaxMny(sumNegotiateTaxMny);
        claimRecordVO.setSumVisaMny(sumVisaMny);
        claimRecordVO.setSumVisaTaxMny(sumVisaTaxMny);
        claimRecordVO.setSumClaimMny(sumClaimMny);
        claimRecordVO.setSumClaimTaxMny(sumClaimTaxMny);
        claimRecordVO.setSumMny(sumMny);
        claimRecordVO.setSumTaxMny(sumTaxMny);
        claimRecordVO.setClaimRecord(claimVOS);
        return claimRecordVO;
    }

    @Override
    public boolean updateContract(ClaimEntity claimEntity, Boolean flag) {
        ContractPoolVO data = new ContractPoolVO();
        try {
            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
            queryWrapper.eq(ClaimEntity::getContractId, (Object)claimEntity.getContractId());
            queryWrapper.ne(BaseEntity::getId, (Object)claimEntity.getId());
            queryWrapper.in(ClaimEntity::getBillState, new Object[]{1, 3});
            queryWrapper.eq(BaseEntity::getDr, (Object)0);
            List list = this.claimService.list((Wrapper)queryWrapper);
            BigDecimal totalClaimTaxMny = BigDecimal.ZERO;
            BigDecimal totalClaimMny = BigDecimal.ZERO;
            BigDecimal totalClaimTax = BigDecimal.ZERO;
            BigDecimal totalReplyTaxMny = BigDecimal.ZERO;
            BigDecimal totalReplyMny = BigDecimal.ZERO;
            BigDecimal totalReplyTax = BigDecimal.ZERO;
            if (CollectionUtils.isNotEmpty((Collection)list)) {
                totalClaimTaxMny = list.stream().map(ClaimEntity::getClaimTaxMny).reduce(BigDecimal::add).get();
                totalClaimMny = list.stream().map(ClaimEntity::getClaimMny).reduce(BigDecimal::add).get();
                totalClaimTax = list.stream().map(ClaimEntity::getClaimTax).reduce(BigDecimal::add).get();
                List collect = list.stream().filter(e -> "1".equals(e.getReplyStatus())).collect(Collectors.toList());
                if (CollectionUtils.isNotEmpty(collect)) {
                    totalReplyTaxMny = collect.stream().map(ClaimEntity::getReplyTaxMny).reduce(BigDecimal::add).get();
                    totalReplyMny = collect.stream().map(ClaimEntity::getReplyMny).reduce(BigDecimal::add).get();
                    totalReplyTax = collect.stream().map(ClaimEntity::getReplyTax).reduce(BigDecimal::add).get();
                }
            }
            if (flag.booleanValue()) {
                totalClaimTaxMny = MathUtil.safeAdd(totalClaimTaxMny, claimEntity.getClaimTaxMny());
                totalClaimMny = MathUtil.safeAdd(totalClaimMny, claimEntity.getClaimMny());
                totalClaimTax = MathUtil.safeAdd(totalClaimTax, claimEntity.getClaimTax());
                if ("1".equals(claimEntity.getReplyStatus())) {
                    totalReplyTaxMny = MathUtil.safeAdd(totalReplyTaxMny, claimEntity.getReplyTaxMny());
                    totalReplyMny = MathUtil.safeAdd(totalReplyMny, claimEntity.getReplyMny());
                    totalReplyTax = MathUtil.safeAdd(totalReplyTax, claimEntity.getReplyTax());
                }
            }
            data.setId(claimEntity.getContractId());
            data.setUpdateLevel(UpdateLevelEnum.\u66f4\u65b0\u975e\u7a7a\u5b57\u6bb5.getLevelCode());
            data.setSourceId(claimEntity.getContractId());
            data.setTotalClaimTaxMny(totalClaimTaxMny);
            data.setTotalClaimMny(totalClaimMny);
            data.setTotalClaimTax(totalClaimTax);
            data.setTotalTeplyTaxMny(totalReplyTaxMny);
            data.setTotalTeplyMny(totalReplyMny);
            data.setTotalTeplyTax(totalReplyTax);
            CommonResponse transDataResp = this.contractPoolApi.saveOrUpdateContract(data);
            if (transDataResp.isSuccess()) {
                return true;
            }
            this.logger.error("\u5408\u540cid-{}\u66f4\u65b0\u5408\u540c\u6c60\u5931\u8d25\uff0c{}", (Object)claimEntity.getContractId(), (Object)transDataResp.getMsg());
        }
        catch (Exception e2) {
            this.logger.error("\u5408\u540c-{}\u66f4\u65b0\u5408\u540c\u6c60\u5931\u8d25\uff0c", (Object)claimEntity.getContractId(), (Object)e2);
        }
        return false;
    }

    @Override
    public Boolean updateCostAdjustId(Long costAdjustId, List<Long> claimIdsList) {
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.eq(ClaimEntity::getCostAdjustId, (Object)costAdjustId);
        updateWrapper.set(ClaimEntity::getCostAdjustId, null);
        this.update((Wrapper)updateWrapper);
        if (ListUtil.isNotEmpty(claimIdsList)) {
            LambdaUpdateWrapper wrapper = new LambdaUpdateWrapper();
            wrapper.in(BaseEntity::getId, claimIdsList);
            wrapper.set(ClaimEntity::getCostAdjustId, (Object)costAdjustId);
            this.update((Wrapper)wrapper);
        }
        return true;
    }

    @Override
    public ReportVO queryDataByProjectId(Long projectId) {
        ReportVO reportVO = new ReportVO();
        LambdaQueryWrapper lambdaContract = Wrappers.lambdaQuery();
        lambdaContract.in(ContractRegisterEntity::getBillState, new Object[]{1, 3});
        lambdaContract.eq(ContractRegisterEntity::getProjectId, (Object)projectId);
        List contractRegisterEntities = this.contractRegisterService.list((Wrapper)lambdaContract);
        if (CollectionUtils.isNotEmpty((Collection)contractRegisterEntities)) {
            BigDecimal sghtMny = contractRegisterEntities.stream().filter(s -> s.getBaseMoney() != null).map(ContractRegisterEntity::getBaseTaxMoney).reduce(BigDecimal.ZERO, BigDecimal::add);
            reportVO.setSghtMny(sghtMny);
        }
        LambdaQueryWrapper lambdaClaim = Wrappers.lambdaQuery();
        lambdaClaim.in(ClaimEntity::getBillState, new Object[]{1, 3});
        lambdaClaim.eq(ClaimEntity::getProjectId, (Object)projectId);
        List claimEntities = super.list((Wrapper)lambdaClaim);
        BigDecimal qzspMny = BigDecimal.ZERO;
        for (ClaimEntity entity : claimEntities) {
            BigDecimal taxMny = entity.getReplyTaxMny();
            if (taxMny == null) {
                taxMny = entity.getClaimTaxMny();
            }
            if (taxMny == null) continue;
            qzspMny = qzspMny.add(taxMny);
        }
        reportVO.setQzspMny(qzspMny);
        LambdaQueryWrapper lambdaProduction = Wrappers.lambdaQuery();
        lambdaProduction.in(ProductionEntity::getBillState, new Object[]{1, 3});
        lambdaProduction.eq(ProductionEntity::getProjectId, (Object)projectId);
        List productionEntities = this.productionService.list((Wrapper)lambdaProduction);
        if (CollectionUtils.isNotEmpty((Collection)productionEntities)) {
            BigDecimal czMny = productionEntities.stream().filter(s -> s.getProductionTaxMny() != null).map(ProductionEntity::getProductionTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);
            reportVO.setCzMny(czMny);
        }
        LambdaQueryWrapper lambdaQuote = Wrappers.lambdaQuery();
        lambdaQuote.in(QuoteEntity::getBillState, new Object[]{1, 3});
        lambdaQuote.eq(QuoteEntity::getProjectId, (Object)projectId);
        List quoteEntityList = this.quoteService.list((Wrapper)lambdaQuote);
        BigDecimal jfpfMny = BigDecimal.ZERO;
        for (QuoteEntity entity : quoteEntityList) {
            BigDecimal taxMny = entity.getReplyTaxMny();
            if (taxMny == null) {
                taxMny = entity.getQuoteTaxMny();
            }
            if (taxMny == null) continue;
            jfpfMny = jfpfMny.add(taxMny);
        }
        reportVO.setJfpfMny(jfpfMny);
        LambdaQueryWrapper lambdaFinalized = Wrappers.lambdaQuery();
        lambdaFinalized.in(FinalizedEntity::getBillState, new Object[]{1, 3});
        lambdaFinalized.eq(FinalizedEntity::getProjectId, (Object)projectId);
        List FinalizedEntityList = this.finalizedService.list((Wrapper)lambdaFinalized);
        BigDecimal jgjsMny = BigDecimal.ZERO;
        for (FinalizedEntity entity : FinalizedEntityList) {
            BigDecimal taxMny = entity.getFinalInstanceMny();
            if (taxMny == null) {
                taxMny = entity.getFirstInstanceMny();
            }
            if (taxMny == null) {
                taxMny = entity.getReportSettleMny();
            }
            if (taxMny == null) continue;
            jgjsMny = jgjsMny.add(taxMny);
        }
        reportVO.setJgjsMny(jgjsMny);
        this.logger.info("reportVO : {}", (Object)reportVO.toString());
        BigDecimal sumHkMny = this.contractRegisterMapper.getSumHkMny(projectId);
        reportVO.setHkMny(sumHkMny);
        reportVO.setCzhkDiffMny(ComputeUtil.safeSub((BigDecimal)reportVO.getCzMny(), (BigDecimal)reportVO.getHkMny()));
        reportVO.setCzhkRate(CommonUtils.calculateRate2(reportVO.getHkMny(), reportVO.getCzMny()));
        reportVO.setCzpfDiffMny(ComputeUtil.safeSub((BigDecimal)reportVO.getCzMny(), (BigDecimal)reportVO.getJfpfMny()));
        reportVO.setPfczRate(CommonUtils.calculateRate2(reportVO.getJfpfMny(), reportVO.getCzMny()));
        reportVO.setPfhkDiffMny(ComputeUtil.safeSub((BigDecimal)reportVO.getJfpfMny(), (BigDecimal)reportVO.getHkMny()));
        reportVO.setHkpfRate(CommonUtils.calculateRate2(reportVO.getHkMny(), reportVO.getJfpfMny()));
        this.logger.info("reportVO : {}", (Object)reportVO.toString());
        return reportVO;
    }
}

