package com.ejianc.business.pro.income.service;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Constants;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.hr.vo.TypeVO;
import com.ejianc.business.pro.deskTop.vo.ProincomeDynamicVO;
import com.ejianc.business.pro.income.bean.ContractRegisterEntity;
import com.ejianc.business.pro.income.vo.*;
import com.ejianc.business.pro.warn.SqlParam;
import com.ejianc.foundation.support.vo.CustomerIncomeInfoVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.IBaseService;
import org.apache.ibatis.annotations.Param;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

/**
 * 施工合同登记
 * 
 * @author generator
 * 
 */
public interface IContractRegisterService extends IBaseService<ContractRegisterEntity> {

    ContractRegisterVO saveOrUpdate(ContractRegisterVO saveorUpdateVO);

    JSONObject pageList(QueryParam param);

    Map<String,Object> countContractAmount(QueryParam param);

    List<ContractRegisterVO> excelExport(QueryParam param);

    ContractRegisterVO addRegisterByRevId(Long reviewId);
    
    ContractRegisterVO addSupplementByConId(Long mainContractId);
    
    RegisterSupplementHistoryVO querySupplementRecord(Long id);

    List<ContractRegisterEntity> queryRegisterByReviewId(Long reviewId);

    boolean pushContract(ContractRegisterVO map,Boolean updateLevel);

    boolean delContractFromPool(Long billId);

    List<Map<String,Object>> queryBudgetWarnContract(List<SqlParam> sqlParamList);

    List<Map<String,Object>> queryCostWarnContract(List<SqlParam> sqlParamList);

    ContractReviewVO queryReviewByProject(Long projectId);

    List<Map<String,Object>> queryContractRegisterWarnContract(List<SqlParam> sqlParamList);

     CommonResponse<ContractRegisterVO> pushToCw(ContractRegisterEntity contractEntity);

    CustomerIncomeInfoVO queryCustomerInfo(Long customerId);
    List<CustomerCountWithYearVO> queryCountByCustomerId(Long customerId,String dateIn);

    /**
     * 根据customerId分组，查询施工合同累计金额
     * @param wrapper
     * @return
     */
    List<CustomerIncomeInfoVO> queryCustomerSum(QueryWrapper wrapper);

    /**
     * 查询施工合同登记and导入历史导入合同数据
     * @param page
     * @param wrapper
     * @return
     */
    List<ContractRegisterVO> queryPageContractAndHistoryExport(Page<ContractRegisterVO> page, QueryWrapper wrapper);


    /**
     * 施工合同评审-根据评审类型分类查询
     *      审批中数量
     *      待用印数量
     *      待返还数量
     *      登记中数量
     *      待交底数量
     */
    List<ProincomeDynamicVO> queryDynamic();

    List<Long> queryListByProjectId(List<Long> ids);

    /**
     * 经营部门户查询定案阶段分类
     */
    List<TypeVO> querySettleReportProgressType();
}
