package com.ejianc.business.pro.other.controller;

import java.io.Serializable;

import com.ejianc.business.pro.other.history.OtherChangeHistoryVO;
import com.ejianc.business.pro.other.vo.OtherContractVO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.auth.session.SessionManager;


import com.ejianc.business.pro.other.bean.OtherChangeEntity;
import com.ejianc.business.pro.other.service.IOtherChangeService;
import com.ejianc.business.pro.other.vo.OtherChangeVO;

/**
 * 其他收入合同变更实体
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("otherChange")
public class OtherChangeController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IOrgApi iOrgApi;

    @Autowired
    private IOtherChangeService service;

    @Autowired
    private SessionManager sessionManager;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<OtherChangeVO> saveOrUpdate(@RequestBody OtherChangeVO saveorUpdateVO) {
        return CommonResponse.success("保存或修改单据成功！",service.saveOrUpdate(saveorUpdateVO));
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<OtherChangeVO> queryDetail(Long id) {
    	OtherChangeEntity entity = service.selectById(id);
    	OtherChangeVO vo = BeanMapper.map(entity, OtherChangeVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<OtherChangeVO> vos) {
        service.deleteChange(vos);
        return CommonResponse.success("删除成功");
    }
    /**
     * 根据主键ID查询供方详情
     *
     * @param id
     * @return
     */
    @RequestMapping(value = "/queryDetailChange", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<OtherContractVO> queryDetailChange(@RequestParam Long id) {
        OtherContractVO vo= service.queryDetailChange(id);
        return CommonResponse.success(vo);
    }

    /**
     * 合同变更历史记录
     * @param id
     * @return
     */
    @RequestMapping(value = "/queryChangeHistory", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<OtherChangeHistoryVO> queryChangeHistory(@RequestParam Long id) {
        OtherChangeHistoryVO vo = service.queryChangeHistory(id);
        return CommonResponse.success(vo);
    }
}
