package com.ejianc.business.pro.income.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.pro.income.mapper.BudgetCostMapper;
import com.ejianc.business.pro.income.bean.BudgetCostEntity;
import com.ejianc.business.pro.income.service.IBudgetCostService;

import java.util.List;

/**
 * 费用项清单
 * 
 * @author generator
 * 
 */
@Service("budgetCostService")
public class BudgetCostServiceImpl extends BaseServiceImpl<BudgetCostMapper, BudgetCostEntity> implements IBudgetCostService{

    @Override
    public void delCostByBudgetId(Long budgetId) {
        baseMapper.delete(new QueryWrapper<BudgetCostEntity>().eq("budget_id", budgetId));
    }

    @Override
    public void delCostBatchByBudgetId(List<Long> ids) {
        baseMapper.delete(new QueryWrapper<BudgetCostEntity>().in("budget_id", ids));
    }

    @Override
    public List<BudgetCostEntity> queryCostByBudgetIds(List<Long> budegtIds) {
        return baseMapper.selectList(new QueryWrapper<BudgetCostEntity>()
                .eq("dr",0)
                .in("budget_id", budegtIds));
    }
}
