package com.ejianc.business.pro.income.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.pro.income.bean.ContractRegisterEntity;
import com.ejianc.business.pro.income.service.IContractRegisterService;
import com.ejianc.business.pro.income.vo.ContractRelieveVO;
import com.ejianc.business.pro.income.vo.RegisterRelieveHistoryVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.pro.income.mapper.ContractRelieveMapper;
import com.ejianc.business.pro.income.bean.ContractRelieveEntity;
import com.ejianc.business.pro.income.service.IContractRelieveService;

import java.util.Date;
import java.util.List;

/**
 * 施工合同解除
 * 
 * @author generator
 * 
 */
@Service("contractRelieveService")
public class ContractRelieveServiceImpl extends BaseServiceImpl<ContractRelieveMapper, ContractRelieveEntity> implements IContractRelieveService{

    private static final String INCOME_CONTRACT_RELIEVE = "INCOME_CONTRACT_RELIEVE";//此处需要根据实际修改
    
    @Autowired
    private IBillCodeApi billCodeApi;

    @Autowired
    private SessionManager sessionManager;
    
    @Autowired
    private IContractRegisterService registerService;


    @Override
    public ContractRelieveVO saveOrUpdate(ContractRelieveVO saveorUpdateVO) {
        ContractRelieveEntity entity = BeanMapper.map(saveorUpdateVO, ContractRelieveEntity.class);
        if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(INCOME_CONTRACT_RELIEVE, InvocationInfoProxy.getTenantid(), saveorUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        super.saveOrUpdate(entity, false);
        
        return BeanMapper.map(this.selectById(entity.getId()), ContractRelieveVO.class);
    }

    @Override
    public ContractRelieveVO addRelieveByConId(Long registerId) {
        ContractRegisterEntity entity = registerService.selectById(registerId);

        ContractRelieveVO vo = new ContractRelieveVO();
        vo.setProjectId(entity.getProjectId());
        vo.setProjectName(entity.getProjectName());
        vo.setProjectCode(entity.getProjectCode());
        vo.setOrgId(entity.getOrgId());
        vo.setOrgCode(entity.getOrgCode());
        vo.setOrgName(entity.getOrgName());
        vo.setParentOrgId(entity.getParentOrgId());
        vo.setParentOrgCode(entity.getParentOrgCode());
        vo.setParentOrgName(entity.getParentOrgName());
        vo.setRegisterId(registerId);
        vo.setContractName(entity.getContractName());
        vo.setCustomerId(entity.getCustomerId());
        vo.setCustomerName(entity.getCustomerName());
        vo.setSupplierId(entity.getSupplierId());
        vo.setSupplierName(entity.getSupplierName());
        vo.setConstructionPartner(entity.getConstructionPartner());
        vo.setTaxRate(entity.getTaxRate());
        vo.setTaxMny(entity.getTaxMny());
        vo.setContractMny(entity.getContractMny());
        vo.setContractTaxMny(entity.getContractTaxMny());
        vo.setEmployeeId(sessionManager.getUserContext().getEmployeeId());
        vo.setEmployeeName(sessionManager.getUserContext().getUserName());
        vo.setDeptId(sessionManager.getUserContext().getDeptId());
        vo.setDeptName(sessionManager.getUserContext().getDeptName());
        vo.setRelieveDate(new Date());
        
        vo.setContractPartyc(entity.getContractPartyc());
        vo.setConjoinedContractTotalMny(entity.getConjoinedContractTotalMny());
        vo.setReviewId(entity.getReviewId());
        
        return vo;
    }

    @Override
    public RegisterRelieveHistoryVO queryRelieveRecord(Long id) {
        ContractRegisterEntity entity = registerService.selectById(id);

        RegisterRelieveHistoryVO vo = new RegisterRelieveHistoryVO();
        vo.setRegisterId(entity.getId());
        vo.setChangeStatus(entity.getChangeStatus());
        vo.setIsFinish(entity.getIsFinish());
        vo.setIsRelieve(entity.getIsRelieve());
        vo.setIsSuspend(entity.getIsSuspend());

        LambdaQueryWrapper<ContractRelieveEntity> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(ContractRelieveEntity::getRegisterId, id);
        wrapper.orderByDesc(ContractRelieveEntity::getRelieveDate);
        List<ContractRelieveEntity> list = super.list(wrapper);
        vo.setDetailList(BeanMapper.mapList(list, ContractRelieveVO.class));
        
        return vo;
    }
}
