/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.pro.income.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.cwdataexchange.PMContractPush.api.IPMContractApi;
import com.ejianc.business.cwdataexchange.PMContractPush.vo.PMContractVO;
import com.ejianc.business.pro.income.bean.ContractRegisterChangeEntity;
import com.ejianc.business.pro.income.bean.ContractRegisterEntity;
import com.ejianc.business.pro.income.mapper.ContractRegisterChangeMapper;
import com.ejianc.business.pro.income.service.IContractRegisterChangeService;
import com.ejianc.business.pro.income.service.IContractRegisterService;
import com.ejianc.business.pro.income.vo.ContractChangePayNodeVO;
import com.ejianc.business.pro.income.vo.ContractChangePayRemarkVO;
import com.ejianc.business.pro.income.vo.ContractRegisterChangeVO;
import com.ejianc.business.pro.income.vo.RegisterChangeHistoryVO;
import com.ejianc.foundation.share.api.IProjectSetApi;
import com.ejianc.foundation.share.vo.ProjectPoolSetVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IDefdocApi;
import com.ejianc.foundation.support.vo.DefdocDetailVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="contractRegisterChangeService")
public class ContractRegisterChangeServiceImpl
extends BaseServiceImpl<ContractRegisterChangeMapper, ContractRegisterChangeEntity>
implements IContractRegisterChangeService {
    private static final String INCOME_CONTRACT_REGISTER_CHANGE = "INCOME_CONTRACT_REGISTER_CHANGE";
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IContractRegisterService registerService;
    @Autowired
    private IPMContractApi contractApi;
    @Autowired
    private IProjectSetApi projectSetApi;
    @Autowired
    private IDefdocApi defdocApi;

    @Override
    public ContractRegisterChangeVO saveOrUpdate(ContractRegisterChangeVO saveorUpdateVO) {
        LambdaQueryWrapper lambda;
        if (saveorUpdateVO.getConjoinedManageType() != null) {
            if (saveorUpdateVO.getConjoinedManageType().equals(1) && saveorUpdateVO.getThisChangeTaxMny() != null && saveorUpdateVO.getContractBaseTaxMnyNoConjoined() != null && saveorUpdateVO.getThisChangeTaxMny().compareTo(saveorUpdateVO.getContractBaseTaxMnyNoConjoined()) != 0) {
                throw new BusinessException("\u5e76\u5217\u5173\u7cfb\u65f6\uff0c\u2018\u672c\u6b21\u53d8\u66f4\u91d1\u989d\u2019\u4e0e\u2018\u542b\u7a0e\u5408\u540c\u7b7e\u8ba2\u91d1\u989d\uff08\u4e0d\u542b\u8054\u5408\u4f53\uff09\u2019\u5e94\u76f8\u7b49\uff01");
            }
            if (saveorUpdateVO.getConjoinedManageType().equals(2) && saveorUpdateVO.getThisChangeTaxMny() != null && saveorUpdateVO.getContractBaseTaxMny() != null && saveorUpdateVO.getThisChangeTaxMny().compareTo(saveorUpdateVO.getContractBaseTaxMny()) != 0) {
                throw new BusinessException("\u5408\u5e76\u5173\u7cfb\u65f6\uff0c\u2018\u672c\u6b21\u53d8\u66f4\u91d1\u989d\u2019\u4e0e\u2018\u542b\u7a0e\u5408\u540c\u7b7e\u8ba2\u603b\u91d1\u989d\u2019\u5e94\u76f8\u7b49\uff01");
            }
        }
        ContractRegisterChangeEntity entity = (ContractRegisterChangeEntity)((Object)BeanMapper.map((Object)saveorUpdateVO, ContractRegisterChangeEntity.class));
        Long tenantId = InvocationInfoProxy.getTenantid();
        if (entity.getId() == null || entity.getId() == 0L) {
            if (null == entity.getChangeVersion() || entity.getChangeVersion() == 0) {
                entity.setChangeVersion(1);
            } else {
                entity.setChangeVersion(entity.getChangeVersion() + 1);
            }
            if ("2".equals(saveorUpdateVO.getChangeStatus())) {
                throw new BusinessException("\u5408\u540c\u5b58\u5728\u53d8\u66f4\u4e2d\u5355\u636e\uff0c\u4e0d\u5141\u8bb8\u4fdd\u5b58!");
            }
            if (entity.getChangeVersion() < 10) {
                entity.setBillCode(entity.getMainContractCode() + "-1-0" + entity.getChangeVersion());
            } else {
                entity.setBillCode(entity.getMainContractCode() + "-1-" + entity.getChangeVersion());
            }
            lambda = new LambdaQueryWrapper();
            lambda.eq(BaseEntity::getTenantId, (Object)tenantId);
            lambda.eq(ContractRegisterChangeEntity::getBillCode, (Object)entity.getBillCode());
            lambda.ne(ContractRegisterChangeEntity::getRegisterId, (Object)entity.getRegisterId());
            List entityList = super.list((Wrapper)lambda);
            if (ListUtil.isNotEmpty((List)entityList)) {
                throw new BusinessException("\u5b58\u5728\u76f8\u540c\u7f16\u7801\uff0c\u4e0d\u5141\u8bb8\u4fdd\u5b58!");
            }
        } else {
            if (StringUtils.isEmpty((CharSequence)entity.getBillCode())) {
                entity.setBillCode(null);
            }
            lambda = new LambdaQueryWrapper();
            lambda.eq(ContractRegisterChangeEntity::getBillCode, (Object)entity.getBillCode());
            lambda.eq(BaseEntity::getTenantId, (Object)tenantId);
            lambda.ne(BaseEntity::getId, (Object)entity.getId());
            lambda.ne(ContractRegisterChangeEntity::getRegisterId, (Object)entity.getRegisterId());
            List entityList = super.list((Wrapper)lambda);
            if (ListUtil.isNotEmpty((List)entityList)) {
                throw new BusinessException("\u5b58\u5728\u76f8\u540c\u7f16\u7801\uff0c\u4e0d\u5141\u8bb8\u4fdd\u5b58!");
            }
        }
        entity.setContractTaxMny(ComputeUtil.safeAdd((BigDecimal)entity.getContractTaxMnyNew(), (BigDecimal)entity.getThisChangeTaxMny()));
        entity.setContractMny(ComputeUtil.safeAdd((BigDecimal)entity.getContractMnyNew(), (BigDecimal)entity.getThisChangeMny()));
        entity.setTaxMny(ComputeUtil.safeAdd((BigDecimal)entity.getTaxMnyNew(), (BigDecimal)entity.getThisChangeTax()));
        super.saveOrUpdate((Object)entity, false);
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.set(ContractRegisterEntity::getChangingTaxMny, (Object)entity.getContractTaxMny());
        updateWrapper.set(ContractRegisterEntity::getChangingMny, (Object)entity.getContractMny());
        updateWrapper.set(ContractRegisterEntity::getChangeId, (Object)entity.getId());
        updateWrapper.set(ContractRegisterEntity::getChangeStatus, (Object)"2");
        updateWrapper.set(ContractRegisterEntity::getChangeCode, (Object)entity.getBillCode());
        updateWrapper.eq(BaseEntity::getId, (Object)entity.getRegisterId());
        this.registerService.update((Wrapper)updateWrapper);
        return (ContractRegisterChangeVO)BeanMapper.map((Object)this.selectById(entity.getId()), ContractRegisterChangeVO.class);
    }

    @Override
    public void deleteChange(List<ContractRegisterChangeVO> vos) {
        for (ContractRegisterChangeVO vo : vos) {
            ContractRegisterChangeEntity changeEntity = (ContractRegisterChangeEntity)((Object)super.selectById((Serializable)vo.getId()));
            LambdaUpdateWrapper wrapper = new LambdaUpdateWrapper();
            wrapper.set(ContractRegisterEntity::getChangingTaxMny, (Object)BigDecimal.ZERO);
            wrapper.set(ContractRegisterEntity::getChangingMny, (Object)BigDecimal.ZERO);
            if (changeEntity.getChangeVersion() == 1) {
                wrapper.set(ContractRegisterEntity::getChangeStatus, (Object)1);
            } else {
                wrapper.set(ContractRegisterEntity::getChangeStatus, (Object)3);
            }
            wrapper.eq(BaseEntity::getId, (Object)changeEntity.getRegisterId());
            this.registerService.update((Wrapper)wrapper);
            super.removeById((Serializable)vo, false);
        }
    }

    @Override
    public ContractRegisterChangeVO addChangeByConId(Long registerId) {
        ContractRegisterEntity entity = (ContractRegisterEntity)((Object)this.registerService.selectById(registerId));
        ContractRegisterChangeVO vo = (ContractRegisterChangeVO)BeanMapper.map((Object)((Object)entity), ContractRegisterChangeVO.class);
        vo.setCwNatureAccounting("3");
        vo.setCostAccounting(Integer.valueOf(2));
        vo.setId(null);
        vo.setRegisterId(entity.getId());
        vo.setChangeTime(new Date());
        vo.setBeforeChangeTaxMny(entity.getContractTaxMny());
        vo.setBeforeChangeMny(entity.getContractMny());
        vo.setMainContractId(entity.getId());
        vo.setMainContractCode(entity.getBillCode());
        vo.setMainContractName(entity.getContractName());
        vo.setContractTaxMnyNew(entity.getContractTaxMny());
        vo.setContractMnyNew(entity.getContractMny());
        vo.setTaxMnyNew(entity.getTaxMny());
        vo.setBillState(null);
        vo.setCreateUserCode(null);
        vo.setCreateTime(null);
        vo.setUpdateUserCode(null);
        vo.setUpdateTime(null);
        vo.setChangeReason(null);
        vo.setContractBaseMny(null);
        vo.setContractBaseTaxMny(null);
        vo.setContractBaseMnyConjoined(null);
        vo.setContractBaseTaxMnyConjoined(null);
        vo.setContractBaseMnyNoConjoined(null);
        vo.setContractBaseTaxMnyNoConjoined(null);
        vo.setConjoinedManageType(null);
        List payRemarkVOS = BeanMapper.mapList(entity.getContractRegisterPayRemarkList(), ContractChangePayRemarkVO.class);
        List payNodeVOS = BeanMapper.mapList(entity.getContractRegisterPayNodeList(), ContractChangePayNodeVO.class);
        for (ContractChangePayRemarkVO payRemarkVO : payRemarkVOS) {
            payRemarkVO.setBillState(null);
            payRemarkVO.setCreateUserCode(null);
            payRemarkVO.setCreateTime(null);
            payRemarkVO.setUpdateUserCode(null);
            payRemarkVO.setUpdateTime(null);
        }
        for (ContractChangePayNodeVO payNodeVO : payNodeVOS) {
            payNodeVO.setBillState(null);
            payNodeVO.setCreateUserCode(null);
            payNodeVO.setCreateTime(null);
            payNodeVO.setUpdateUserCode(null);
            payNodeVO.setUpdateTime(null);
        }
        vo.setContractChangePayRemarkList(payRemarkVOS);
        vo.setContractChangePayNodeList(payNodeVOS);
        return vo;
    }

    @Override
    public RegisterChangeHistoryVO queryChangeRecord(Long id) {
        ArrayList<Integer> billStatus = new ArrayList<Integer>();
        billStatus.add(1);
        billStatus.add(3);
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(ContractRegisterChangeEntity::getRegisterId, (Object)id);
        wrapper.in(ContractRegisterChangeEntity::getBillState, billStatus);
        wrapper.orderByDesc(ContractRegisterChangeEntity::getUsedTime);
        List changeEntityList = this.list((Wrapper)wrapper);
        ContractRegisterEntity registerEntity = (ContractRegisterEntity)((Object)this.registerService.selectById(id));
        RegisterChangeHistoryVO vo = new RegisterChangeHistoryVO();
        vo.setRegisterId(registerEntity.getId());
        vo.setContractTaxMny(registerEntity.getContractTaxMny() == null ? BigDecimal.ZERO : registerEntity.getContractTaxMny());
        vo.setContractMny(registerEntity.getContractMny() == null ? BigDecimal.ZERO : registerEntity.getContractMny());
        vo.setBaseTaxMoney(registerEntity.getBaseTaxMoney() == null ? BigDecimal.ZERO : registerEntity.getBaseTaxMoney());
        vo.setBaseMoney(registerEntity.getBaseMoney() == null ? BigDecimal.ZERO : registerEntity.getBaseMoney());
        vo.setChangeStatus(registerEntity.getChangeStatus());
        vo.setIsFinish(registerEntity.getIsFinish());
        vo.setIsRelieve(registerEntity.getIsRelieve());
        vo.setIsSuspend(registerEntity.getIsSuspend());
        BigDecimal changeMny = ComputeUtil.safeSub((BigDecimal)vo.getContractTaxMny(), (BigDecimal)vo.getBaseTaxMoney());
        vo.setSumChangeMny(changeMny);
        BigDecimal sumChangeRate = BigDecimal.ZERO;
        if (vo.getBaseTaxMoney().compareTo(BigDecimal.ZERO) != 0) {
            sumChangeRate = ComputeUtil.safeMultiply((BigDecimal)ComputeUtil.safeDiv((BigDecimal)vo.getSumChangeMny(), (BigDecimal)vo.getBaseTaxMoney()), (BigDecimal)new BigDecimal("100"));
        }
        vo.setSumScale(sumChangeRate);
        List changeVOList = BeanMapper.mapList((Iterable)changeEntityList, ContractRegisterChangeVO.class);
        int index = 1;
        for (ContractRegisterChangeVO changeVO : changeVOList) {
            changeVO.setHistoryBillCode(registerEntity.getBillCode() + "-" + index);
            BigDecimal subtract = ComputeUtil.safeSub((BigDecimal)changeVO.getContractTaxMny(), (BigDecimal)changeVO.getBeforeChangeTaxMny());
            BigDecimal changeRate = BigDecimal.ZERO;
            if (changeVO.getBeforeChangeTaxMny() != null && changeVO.getBeforeChangeTaxMny().compareTo(BigDecimal.ZERO) != 0) {
                changeRate = ComputeUtil.safeMultiply((BigDecimal)ComputeUtil.safeDiv((BigDecimal)subtract, (BigDecimal)changeVO.getBeforeChangeTaxMny()), (BigDecimal)new BigDecimal("100"));
            }
            changeVO.setScale(changeRate);
            ++index;
        }
        vo.setChangeRecord(changeVOList);
        return vo;
    }

    @Override
    public CommonResponse<ContractRegisterChangeVO> pushToCw(ContractRegisterChangeEntity changeEntity) {
        this.logger.info("\u63a8\u9001\u8d22\u52a1\u4e2d\u95f4\u8868  ------------------------\u5f00\u59cb");
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        CommonResponse projectPoolSetVO = this.projectSetApi.getProjectId(changeEntity.getProjectId());
        PMContractVO pmContractVO = (PMContractVO)BeanMapper.map((Object)((Object)changeEntity), PMContractVO.class);
        pmContractVO.setZgbz(Integer.valueOf(0));
        pmContractVO.setBslx("\u53d8\u66f4\u5408\u540c");
        pmContractVO.setContractStatus(null);
        pmContractVO.setContractId(String.valueOf(changeEntity.getId()));
        if (changeEntity.getChangeTime() != null) {
            pmContractVO.setDjrq(sdf.format(changeEntity.getChangeTime()));
        }
        if (changeEntity.getSignDate() != null) {
            pmContractVO.setSignDate(sdf.format(changeEntity.getSignDate()));
        }
        pmContractVO.setContractCode(changeEntity.getBillCode());
        if (changeEntity.getBaseTaxMoney() != null) {
            pmContractVO.setHtljhsje(changeEntity.getBaseTaxMoney());
        }
        pmContractVO.setContractTypeName("\u65bd\u5de5\u5408\u540c");
        if (projectPoolSetVO != null && projectPoolSetVO.getData() != null) {
            CommonResponse defDocById;
            ProjectPoolSetVO data = (ProjectPoolSetVO)projectPoolSetVO.getData();
            if (data.getAreaName() != null) {
                pmContractVO.setSzs(data.getAreaName());
            }
            if (data.getAddress() != null) {
                pmContractVO.setXxdz(data.getAddress());
            }
            if (data.getEngineeringType() != null && (defDocById = this.defdocApi.getDefDocById(data.getEngineeringType())).getCode() == 0 && defDocById.getData() != null) {
                pmContractVO.setGclb(((DefdocDetailVO)defDocById.getData()).getName());
            }
            if (data.getMeasureType() != null && data.getMeasureType().equals(1506803511994617857L) && data.getMeasureValue() != null) {
                pmContractVO.setJzmj(data.getMeasureValue());
            }
            if (data.getPlanStartDate() != null) {
                pmContractVO.setKgrq(sdf.format(data.getPlanStartDate()));
            }
            if (data.getPlanEndDate() != null) {
                pmContractVO.setJgrq(sdf.format(data.getPlanEndDate()));
            }
            if (data.getProjectManagementName() != null) {
                pmContractVO.setXmfzr(data.getProjectManagementName());
            }
            if (data.getProjectManagementPhone() != null) {
                pmContractVO.setXmfzedh(data.getProjectManagementPhone());
            }
        }
        if (changeEntity.getThisChangeTaxMny() != null) {
            pmContractVO.setBcbgje(changeEntity.getThisChangeTaxMny());
        }
        CommonResponse pmContractVOCommonResponse = this.contractApi.saveContract(pmContractVO);
        this.logger.info("\u63a8\u9001\u8d22\u52a1\u4e2d\u95f4\u8868  ------------------------\u7ed3\u675f" + JSON.toJSONString((Object)pmContractVOCommonResponse));
        return CommonResponse.success((String)"\u63a8\u9001\u8d22\u52a1\u4e2d\u95f4\u8868\u6210\u529f\uff01", (Object)BeanMapper.map((Object)((Object)changeEntity), ContractRegisterChangeVO.class));
    }
}

