package com.ejianc.business.market.api;

import com.ejianc.business.market.hystrix.ProjectHystrix;
import com.ejianc.business.market.vo.ProjectSetVO;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;

@FeignClient(name= "ejc-promarket-web", url="${common.env.feign-client-url}", path="ejc-market-web", fallback = ProjectHystrix.class)
public interface IProjectApi {
    //查询项目详情
    @GetMapping("/api/project/queryProjectDetail")
    public CommonResponse<ProjectSetVO> queryProjectDetail(@RequestParam(value = "projectId") Long projectId);
}
