package com.ejianc.business.market.vo;

import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.Date;


/**
 * 成本关门台账
 *
 * @author Jiang
 */
public class CloseCostReportVO extends BaseVO {

    private Long id;//成本关门主表id
    private Long projectId;//项目id
    private String projectName;//项目名称
    private String businessStatus;//项目状态
    private BigDecimal contractMny;//调整后合同额
    private BigDecimal nicContractMny;//工程造价调整后总金额(不含暂列金额)
    private BigDecimal finalizedMny;//项目定案金额
    private BigDecimal receiveMny;//已收款额
    private BigDecimal totalPayDirectFees;//直接费总额
    private BigDecimal totalPaidDirectFees;//已支付直接费总额
    private BigDecimal totalUnderPayDirectFees;//结算欠付总额
    private BigDecimal zhijiefeizhanbi;//直接费占比
    private BigDecimal totalEstimatedIndirectTaxMny;//预计间接费、税金总支出
    private BigDecimal totalPaidIndirectTaxMny;//已支付间接费、税金总额
    private BigDecimal totalUnderPayIndirectTaxMny;//间接费、税金欠付
    private BigDecimal jianjiefeizhanbi;//间接费占比
    private BigDecimal totalEstimatedPayMny;//预计总支出
    private BigDecimal totalPaidMny;//已支付
    private BigDecimal totalUnderPayMny;//总欠付
    private BigDecimal proProFit;//盈亏金额
    private BigDecimal proProFitPer;//利润率
    private Long parentOrgId;//项目部
    private String parentOrgCode;
    private String parentOrgName;
    private Long orgId;//组织
    private String orgCode;//
    private String orgName;//
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date closeDate;//关门日期
    private Long engineeringTypeId;//工程类别id
    private String engineeringTypeName;//工程类别
    private BigDecimal targetcostProfit; // 目标利润率
    private BigDecimal processProfit; // 过程分析利润率
    private BigDecimal finishProfit; // 完工分析利润率
    private BigDecimal proProfitPer;//利润率
    private BigDecimal proProfit;//利润


    public BigDecimal getProProfit() {
        return proProfit;
    }

    public void setProProfit(BigDecimal proProfit) {
        this.proProfit = proProfit;
    }

    public BigDecimal getProProfitPer() {
        return proProfitPer;
    }

    public void setProProfitPer(BigDecimal proProfitPer) {
        this.proProfitPer = proProfitPer;
    }

    public BigDecimal getTargetcostProfit() {
        return targetcostProfit;
    }

    public void setTargetcostProfit(BigDecimal targetcostProfit) {
        this.targetcostProfit = targetcostProfit;
    }

    public BigDecimal getProcessProfit() {
        return processProfit;
    }

    public void setProcessProfit(BigDecimal processProfit) {
        this.processProfit = processProfit;
    }

    public BigDecimal getFinishProfit() {
        return finishProfit;
    }

    public void setFinishProfit(BigDecimal finishProfit) {
        this.finishProfit = finishProfit;
    }

    public Date getCloseDate() {
        return closeDate;
    }

    public void setCloseDate(Date closeDate) {
        this.closeDate = closeDate;
    }

    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public String getBusinessStatus() {
        return businessStatus;
    }

    public void setBusinessStatus(String businessStatus) {
        this.businessStatus = businessStatus;
    }

    public BigDecimal getContractMny() {
        return contractMny;
    }

    public void setContractMny(BigDecimal contractMny) {
        this.contractMny = contractMny;
    }

    public BigDecimal getFinalizedMny() {
        return finalizedMny;
    }

    public void setFinalizedMny(BigDecimal finalizedMny) {
        this.finalizedMny = finalizedMny;
    }

    public BigDecimal getReceiveMny() {
        return receiveMny;
    }

    public void setReceiveMny(BigDecimal receiveMny) {
        this.receiveMny = receiveMny;
    }

    public BigDecimal getTotalPayDirectFees() {
        return totalPayDirectFees;
    }

    public void setTotalPayDirectFees(BigDecimal totalPayDirectFees) {
        this.totalPayDirectFees = totalPayDirectFees;
    }

    public BigDecimal getTotalPaidDirectFees() {
        return totalPaidDirectFees;
    }

    public void setTotalPaidDirectFees(BigDecimal totalPaidDirectFees) {
        this.totalPaidDirectFees = totalPaidDirectFees;
    }

    public BigDecimal getTotalUnderPayDirectFees() {
        return totalUnderPayDirectFees;
    }

    public void setTotalUnderPayDirectFees(BigDecimal totalUnderPayDirectFees) {
        this.totalUnderPayDirectFees = totalUnderPayDirectFees;
    }

    public BigDecimal getZhijiefeizhanbi() {
        return zhijiefeizhanbi;
    }

    public void setZhijiefeizhanbi(BigDecimal zhijiefeizhanbi) {
        this.zhijiefeizhanbi = zhijiefeizhanbi;
    }

    public BigDecimal getTotalEstimatedIndirectTaxMny() {
        return totalEstimatedIndirectTaxMny;
    }

    public void setTotalEstimatedIndirectTaxMny(BigDecimal totalEstimatedIndirectTaxMny) {
        this.totalEstimatedIndirectTaxMny = totalEstimatedIndirectTaxMny;
    }

    public BigDecimal getTotalPaidIndirectTaxMny() {
        return totalPaidIndirectTaxMny;
    }

    public void setTotalPaidIndirectTaxMny(BigDecimal totalPaidIndirectTaxMny) {
        this.totalPaidIndirectTaxMny = totalPaidIndirectTaxMny;
    }

    public BigDecimal getTotalUnderPayIndirectTaxMny() {
        return totalUnderPayIndirectTaxMny;
    }

    public void setTotalUnderPayIndirectTaxMny(BigDecimal totalUnderPayIndirectTaxMny) {
        this.totalUnderPayIndirectTaxMny = totalUnderPayIndirectTaxMny;
    }

    public BigDecimal getJianjiefeizhanbi() {
        return jianjiefeizhanbi;
    }

    public void setJianjiefeizhanbi(BigDecimal jianjiefeizhanbi) {
        this.jianjiefeizhanbi = jianjiefeizhanbi;
    }

    public BigDecimal getTotalEstimatedPayMny() {
        return totalEstimatedPayMny;
    }

    public void setTotalEstimatedPayMny(BigDecimal totalEstimatedPayMny) {
        this.totalEstimatedPayMny = totalEstimatedPayMny;
    }

    public BigDecimal getTotalPaidMny() {
        return totalPaidMny;
    }

    public void setTotalPaidMny(BigDecimal totalPaidMny) {
        this.totalPaidMny = totalPaidMny;
    }

    public BigDecimal getTotalUnderPayMny() {
        return totalUnderPayMny;
    }

    public void setTotalUnderPayMny(BigDecimal totalUnderPayMny) {
        this.totalUnderPayMny = totalUnderPayMny;
    }

    public BigDecimal getProProFit() {
        return proProFit;
    }

    public void setProProFit(BigDecimal proProFit) {
        this.proProFit = proProFit;
    }

    public BigDecimal getProProFitPer() {
        return proProFitPer;
    }

    public void setProProFitPer(BigDecimal proProFitPer) {
        this.proProFitPer = proProFitPer;
    }

    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }

    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }

    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }

    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public Long getEngineeringTypeId() {
        return engineeringTypeId;
    }

    public void setEngineeringTypeId(Long engineeringTypeId) {
        this.engineeringTypeId = engineeringTypeId;
    }

    public String getEngineeringTypeName() {
        return engineeringTypeName;
    }

    public void setEngineeringTypeName(String engineeringTypeName) {
        this.engineeringTypeName = engineeringTypeName;
    }

    public BigDecimal getNicContractMny() {
        return nicContractMny;
    }

    public void setNicContractMny(BigDecimal nicContractMny) {
        this.nicContractMny = nicContractMny;
    }
}
