package com.ejianc.business.project.api;

import com.ejianc.business.project.hystrix.ProjectMarketSetHystrix;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

@FeignClient(name= "ejc-promarket-web", url="${common.env.feign-client-url}", path="ejc-promarket-web", fallback = ProjectMarketSetHystrix.class)
public interface IProjectMarketSetApi {


    @RequestMapping(value = "/api/projectSet/updateProjectJzsInfo", method = RequestMethod.GET)
    @ResponseBody
    CommonResponse<String> updateProjectJzsInfo(@RequestParam(value = "projectId") Long projectId,
                                                                            @RequestParam(value = "userId") Long userId,
                                                                            @RequestParam(value = "userName") String userName);



}
