package com.ejianc.business.enums;

import org.apache.commons.lang3.StringUtils;

/**
 * @author baipengyan
 * @date 2022/8/30
 * @description 结算状态
 */
public enum SettleStatusEnum {
	未决算("1"),
	决算中("8"),
	已决算("9");
	private final String code;

	SettleStatusEnum(String code) {
		this.code = code;
	}

	public static String getNameByCode(String settleStatus) {
		switch (settleStatus) {
			case "1":
				return "未决算";
			case "8":
				return "决算中";
			case "9":
				return "已决算";
			default:
				return null;
		}
	}

	public String getCode() {
		return code;
	}

	public static String getCodeByName(String name) {
		if (StringUtils.isBlank(name)) {
			return null;
		}
		for (SettleStatusEnum settleStatusEnum : SettleStatusEnum.values()) {
			if (name.equals(settleStatusEnum.toString())) {
				return settleStatusEnum.getCode();
			}
		}
		return null;
	}
}
