package com.ejianc.business.market.vo;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.Date;


/**
 * G9成本关门
 * 
 * @author generator
 * 
 */
public class CloseCostDesktopDTO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private Date commitDate; // 提交日期
    private String commitUserName; // 提交人名称
    private String commitUserCode; // 提交人账号
    private Date effectiveDate; // 生效日期
    private String billCode; // 单据编号
    private String billName; // 单据名称
    private Integer billState; // 单据状态
    private String billStateName; // 单据状态名称
    private Long orgId; // 项目部id
    private String orgCode; // 项目部编码
    private String orgName; // 项目部名称
    private Long parentOrgId; // 项目部所属组织id
    private String parentOrgCode; // 项目部所属组织编码
    private String parentOrgName; // 项目部所属组织名称
    private Long projectId; // 项目id
    private String projectCode; // 项目编码
    private String projectName; // 项目名称
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date closeDate; // 关门日期
    private Long employeeId; // 经办人id
    private String employeeName; // 经办人名称
    private Long departmentId; // 经办部门id
    private String departmentCode; // 经办部门编码
    private String departmentName; // 经办部门名称
    private String closeMemo; // 成本关门说明
    private String projectStatus; // 项目状态：1、在建 2、项目中止 3、竣工 4、保修 5、
    private BigDecimal contractMny; // 合同额
    private BigDecimal finalizedMny; // 工程定案金额
    private BigDecimal preTotalCost; // 预计总成本
    private BigDecimal preTotalOut; // 预计总欠付
    private BigDecimal proProfit; // 预计净利润
    private BigDecimal proProfitPer; // 预计利润率
    private String businessStatus; // 业务状态（项目状态子状态）：
    private BigDecimal targetcostProfit; // 目标利润率
    private BigDecimal processProfit; // 过程分析利润率
    private BigDecimal finishProfit; // 完工分析利润率
    

    public Date getCommitDate() {
        return commitDate;
    }

    public void setCommitDate(Date commitDate) {
        this.commitDate = commitDate;
    }
    public String getCommitUserName() {
        return commitUserName;
    }

    public void setCommitUserName(String commitUserName) {
        this.commitUserName = commitUserName;
    }
    public String getCommitUserCode() {
        return commitUserCode;
    }

    public void setCommitUserCode(String commitUserCode) {
        this.commitUserCode = commitUserCode;
    }
    public Date getEffectiveDate() {
        return effectiveDate;
    }

    public void setEffectiveDate(Date effectiveDate) {
        this.effectiveDate = effectiveDate;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public String getBillName() {
        return billName;
    }

    public void setBillName(String billName) {
        this.billName = billName;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getBillStateName() {
        return billStateName;
    }

    public void setBillStateName(String billStateName) {
        this.billStateName = billStateName;
    }
    public Long getOrgId() {
        return orgId;
    }
    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    public Long getProjectId() {
        return projectId;
    }
    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public Date getCloseDate() {
        return closeDate;
    }

    public void setCloseDate(Date closeDate) {
        this.closeDate = closeDate;
    }
    public Long getEmployeeId() {
        return employeeId;
    }
    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public Long getDepartmentId() {
        return departmentId;
    }
    @ReferDeserialTransfer
    public void setDepartmentId(Long departmentId) {
        this.departmentId = departmentId;
    }
    public String getDepartmentCode() {
        return departmentCode;
    }

    public void setDepartmentCode(String departmentCode) {
        this.departmentCode = departmentCode;
    }
    public String getDepartmentName() {
        return departmentName;
    }

    public void setDepartmentName(String departmentName) {
        this.departmentName = departmentName;
    }
    public String getCloseMemo() {
        return closeMemo;
    }

    public void setCloseMemo(String closeMemo) {
        this.closeMemo = closeMemo;
    }
    public String getProjectStatus() {
        return projectStatus;
    }

    public void setProjectStatus(String projectStatus) {
        this.projectStatus = projectStatus;
    }
    public BigDecimal getContractMny() {
        return contractMny;
    }

    public void setContractMny(BigDecimal contractMny) {
        this.contractMny = contractMny;
    }
    public BigDecimal getFinalizedMny() {
        return finalizedMny;
    }

    public void setFinalizedMny(BigDecimal finalizedMny) {
        this.finalizedMny = finalizedMny;
    }
    public BigDecimal getPreTotalCost() {
        return preTotalCost;
    }

    public void setPreTotalCost(BigDecimal preTotalCost) {
        this.preTotalCost = preTotalCost;
    }
    public BigDecimal getPreTotalOut() {
        return preTotalOut;
    }

    public void setPreTotalOut(BigDecimal preTotalOut) {
        this.preTotalOut = preTotalOut;
    }
    public BigDecimal getProProfit() {
        return proProfit;
    }

    public void setProProfit(BigDecimal proProfit) {
        this.proProfit = proProfit;
    }
    public BigDecimal getProProfitPer() {
        return proProfitPer;
    }

    public void setProProfitPer(BigDecimal proProfitPer) {
        this.proProfitPer = proProfitPer;
    }
    public String getBusinessStatus() {
        return businessStatus;
    }

    public void setBusinessStatus(String businessStatus) {
        this.businessStatus = businessStatus;
    }
    public BigDecimal getTargetcostProfit() {
        return targetcostProfit;
    }

    public void setTargetcostProfit(BigDecimal targetcostProfit) {
        this.targetcostProfit = targetcostProfit;
    }
    public BigDecimal getProcessProfit() {
        return processProfit;
    }

    public void setProcessProfit(BigDecimal processProfit) {
        this.processProfit = processProfit;
    }
    public BigDecimal getFinishProfit() {
        return finishProfit;
    }

    public void setFinishProfit(BigDecimal finishProfit) {
        this.finishProfit = finishProfit;
    }
    
}
