package com.ejianc.business.market.api;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.market.hystrix.ProjectPartHystrix;
import com.ejianc.business.market.hystrix.WorkReportHystrix;
import com.ejianc.business.market.vo.CompletionWorkReportVO;
import com.ejianc.business.market.vo.ProjectPartVO;
import com.ejianc.business.market.vo.WorkReportQueryVO;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import java.util.List;

@FeignClient(name= "ejc-promarket-web", url="${common.env.feign-client-url}", path="ejc-promarket-web", fallback = ProjectPartHystrix.class)
public interface IProjectPartApi {

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @GetMapping(value = "/projectPart/saveOrUpdate")
    @ResponseBody
    CommonResponse<ProjectPartVO> saveOrUpdate(@RequestBody ProjectPartVO saveOrUpdateVO);

}
