package com.ejianc.business.enums;

import org.apache.commons.lang3.StringUtils;

/**
 * @author baipengyan
 * @date 2022/8/30
 * @description 项目状态
 */
public enum ProjectStatusEnum {
	在建("1"),
	项目中止("2"),
	竣工("3");

	private final String code;

	ProjectStatusEnum(String code) {
		this.code = code;
	}

	public String getCode() {
		return code;
	}

	public static String getCodeByName(String name) {
		if (StringUtils.isBlank(name)) {
			return null;
		}
		for (ProjectStatusEnum projectStatusEnum : ProjectStatusEnum.values()) {
			if (name.equals(projectStatusEnum.toString())) {
				return projectStatusEnum.getCode();
			}
		}
		return null;
	}

	public static String getNameByCode(String code) {
		switch (code) {
			case "1":
				return "在建";
			case "2":
				return "项目中止";
			case "3":
				return "竣工";
			default:
				return null;
		}
	}
}
