package com.ejianc.business.project.vo;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;


/**
 * 项目信息统计表
 * 
 * @author generator
 * 
 */
public class ProjectInfoVO extends BaseVO {
    private static final long serialVersionUID = 1L;

    private String billCode; // 项目编码
    private String code; // 项目编码
    private String name; // 项目名称
    private String measureValue; // 度量值
    private String businessStatus; // 
    private Long engineeringType; // 工程类型：1、单体工程 2、群体工程 3、线性工程
    private String structureType; // 结构类型：1、全浇灌；2、框架结构；3钢结构；4砖混结构；5框架剪力墙结构
    private String areaName; // 地区
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date contractStartDate; // 合同开工日期
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date contractEndDate; // 合同竣工日期
    private Integer schedule; // 工期
    private List<UserInfoVO> userInfoVOS= new ArrayList<>(); ;//报备人员信息
    private Long yxId;//影像id
    private String kgwccz; // 完成产值
    private Long technologyNum;//方案个数
    private String labsubContractTaxMny; // 劳务分包合同金额,份数
    private String labsubCount; // 劳务分包合同金额,份数
    private String prosubContractTaxMny; // 专业分包合同金额,份数
    private String prosubCount; // 专业分包合同金额,份数
    private String rentContractTaxMny; // 设备租赁合同金额，份数
    private String rentCount; // 设备租赁合同金额，份数
    private String meetingCount; // 监理纪要个数
    private String buildPersonCount; // 施工日志个人个数
    private String buildProjectCount; // 施工日志项目个数


    public String getLabsubContractTaxMny() {
        return labsubContractTaxMny;
    }

    public void setLabsubContractTaxMny(String labsubContractTaxMny) {
        this.labsubContractTaxMny = labsubContractTaxMny;
    }

    public String getLabsubCount() {
        return labsubCount;
    }

    public void setLabsubCount(String labsubCount) {
        this.labsubCount = labsubCount;
    }

    public String getProsubContractTaxMny() {
        return prosubContractTaxMny;
    }

    public void setProsubContractTaxMny(String prosubContractTaxMny) {
        this.prosubContractTaxMny = prosubContractTaxMny;
    }

    public String getProsubCount() {
        return prosubCount;
    }

    public void setProsubCount(String prosubCount) {
        this.prosubCount = prosubCount;
    }

    public String getRentContractTaxMny() {
        return rentContractTaxMny;
    }

    public void setRentContractTaxMny(String rentContractTaxMny) {
        this.rentContractTaxMny = rentContractTaxMny;
    }

    public String getRentCount() {
        return rentCount;
    }

    public void setRentCount(String rentCount) {
        this.rentCount = rentCount;
    }

    public String getMeetingCount() {
        return meetingCount;
    }

    public void setMeetingCount(String meetingCount) {
        this.meetingCount = meetingCount;
    }

    public String getBuildPersonCount() {
        return buildPersonCount;
    }

    public void setBuildPersonCount(String buildPersonCount) {
        this.buildPersonCount = buildPersonCount;
    }

    public String getBuildProjectCount() {
        return buildProjectCount;
    }

    public void setBuildProjectCount(String buildProjectCount) {
        this.buildProjectCount = buildProjectCount;
    }

    public Long getTechnologyNum() {
        return technologyNum;
    }

    public void setTechnologyNum(Long technologyNum) {
        this.technologyNum = technologyNum;
    }

    public String getBillCode() {
        return code;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }
    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }
    public String getMeasureValue() {
        return measureValue;
    }

    public void setMeasureValue(String measureValue) {
        this.measureValue = measureValue;
    }
    public String getBusinessStatus() {
        return businessStatus;
    }

    public void setBusinessStatus(String businessStatus) {
        this.businessStatus = businessStatus;
    }

    @ReferSerialTransfer(referCode="support-defdoc")
    public Long getEngineeringType() {
        return engineeringType;
    }
    @ReferDeserialTransfer
    public void setEngineeringType(Long engineeringType) {
        this.engineeringType = engineeringType;
    }

    @ReferSerialTransfer(referCode="support-defdoc")
    public String getStructureType() {
        return structureType;
    }
    @ReferDeserialTransfer
    public void setStructureType(String structureType) {
        this.structureType = structureType;
    }
    public String getAreaName() {
        return areaName;
    }

    public void setAreaName(String areaName) {
        this.areaName = areaName;
    }
    public Date getContractStartDate() {
        return contractStartDate;
    }

    public void setContractStartDate(Date contractStartDate) {
        this.contractStartDate = contractStartDate;
    }
    public Date getContractEndDate() {
        return contractEndDate;
    }

    public void setContractEndDate(Date contractEndDate) {
        this.contractEndDate = contractEndDate;
    }
    public Integer getSchedule() {
        return schedule;
    }

    public void setSchedule(Integer schedule) {
        this.schedule = schedule;
    }

    public List<UserInfoVO> getUserInfoVOS() {
        return userInfoVOS;
    }

    public void setUserInfoVOS(List<UserInfoVO> userInfoVOS) {
        this.userInfoVOS = userInfoVOS;
    }

    public Long getYxId() {
        return yxId;
    }

    public void setYxId(Long yxId) {
        this.yxId = yxId;
    }

    public String getKgwccz() {
        return kgwccz;
    }

    public void setKgwccz(String kgwccz) {
        this.kgwccz = kgwccz;
    }
}
