package com.ejianc.business.enums;

import org.apache.commons.lang3.StringUtils;

/**
 * @author sunxy
 * @date 2023/4/14
 * @description 项目状态
 */
public enum ProjectStatusNewEnum {
	在建("1"),
	项目中止("2"),
	竣工("3"),
	合同状态("4"),
	决算状态("5"),
	资料状态("6"),
	资金管控状态("7");
	private final String code;

	ProjectStatusNewEnum(String code) {
		this.code = code;
	}

	public String getCode() {
		return code;
	}

	public static String getCodeByName(String name) {
		if (StringUtils.isBlank(name)) {
			return null;
		}
		for (ProjectStatusNewEnum projectStatusEnum : ProjectStatusNewEnum.values()) {
			if (name.equals(projectStatusEnum.toString())) {
				return projectStatusEnum.getCode();
			}
		}
		return null;
	}

	public static String getNameByCode(String code) {
		switch (code) {
			case "1":
				return "在建";
			case "2":
				return "项目中止";
			case "3":
				return "竣工";
			case "4":
				return "合同状态";
			case "5":
				return "决算状态";
			case "6":
				return "资料状态";
			case "7":
				return "资金管控状态";
			default:
				return null;
		}
	}
}
