package com.ejianc.business.market.vo;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.Date;


/**
 * 竣工报告
 * 
 * @author generator
 * 
 */
@ApiModel("竣工报告")
public class CompletionWorkReportVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    @ApiModelProperty("所属项目Id")
    private Long projectId;
    @ApiModelProperty("所属项目名称")
    private String projectName;
    @ApiModelProperty("单据编码")
    private String billCode;
    @ApiModelProperty("单据状态")
    private Integer billState;
    @ApiModelProperty("所属项目部Id")
    private Long orgId;
    @ApiModelProperty("所属项目部名称")
    private String orgName;
    @ApiModelProperty("项目组织编码")
    private String orgCode;
    @ApiModelProperty("项目部上级组织id")
    private Long parentOrgId;
    @ApiModelProperty("项目部上级组织编码")
    private String parentOrgCode;
    @ApiModelProperty("项目部上级组织名称")
    private String parentOrgName;
    @ApiModelProperty("经办人id")
    private Long employeeId;
    @ApiModelProperty("经办人")
    private String employeeName;
    @ApiModelProperty("经办人电话")
    private String employeePhone;
    @ApiModelProperty("经办人单位id")
    private Long departmentId;
    @ApiModelProperty("经办单位")
    private String departmentName;
    @ApiModelProperty("验收类型Id")
    private Long checkType;
    @ApiModelProperty("验收类型名称")
    private String checkTypeName;
    @ApiModelProperty("申请验收日期")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date applyCheckDate;
    @ApiModelProperty("备注")
    private String memo;
    @ApiModelProperty("单据状态名称")
    private String billStateName;
    @JsonFormat(
            pattern = "yyyy-MM-dd HH:mm:ss",
            timezone = "GMT+8"
    )
    private Date effectiveTime; // 生效时间
    private boolean completionAcceptanceFlag; // 是否竣工验收
    private Long patrolGroupId;// 所属巡检组id
    private String patrolGroup;// 所属巡检组名称
    private Long buildUnitId;// 施工单位id
    private String buildUnitName;// 施工单位名称
    private String measureValue; // 度量值
    private String partName; // 验收部位
    private String finishFlag; // 是否全部验收
    private Long structureType; // 结构类型
    private String mainIndexName; // 主要技术指标
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date serviceDate; // 业务日期
    private String fileFlag; // 是否上传附件
    private String problem; // 存在问题
    private Long projectManagementId; // 项目经理
    private String projectManagementName; // 项目经理名称

    public boolean isCompletionAcceptanceFlag() {
        return completionAcceptanceFlag;
    }

    public void setCompletionAcceptanceFlag(boolean completionAcceptanceFlag) {
        this.completionAcceptanceFlag = completionAcceptanceFlag;
    }

    public Date getEffectiveTime() {
        return effectiveTime;
    }

    public void setEffectiveTime(Date effectiveTime) {
        this.effectiveTime = effectiveTime;
    }
    

    /**
     * 所属项目Id
     */
    @ReferSerialTransfer(referCode = "project-set")
    public Long getProjectId() {
        return projectId;
    }

    /**
     * 所属项目Id
     */
    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    /**
     * 所属项目名称
     */
    public String getProjectName() {
        return projectName;
    }

    /**
     * 所属项目名称
     */
    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    /**
     * 单据编码
     */
    public String getBillCode() {
        return billCode;
    }

    /**
     * 单据编码
     */
    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    /**
     * 单据状态
     */
    public Integer getBillState() {
        return billState;
    }

    /**
     * 单据状态
     */
    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    /**
     * 所属项目部Id
     */
    @ReferSerialTransfer(referCode = "idm-org")
    public Long getOrgId() {
        return orgId;
    }

    /**
     * 所属项目部Id
     */
    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    /**
     * 所属项目部名称
     */
    public String getOrgName() {
        return orgName;
    }

    /**
     * 所属项目部名称
     */
    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    /**
     * 项目组织编码
     */
    public String getOrgCode() {
        return orgCode;
    }

    /**
     * 项目组织编码
     */
    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    /**
     * 项目部上级组织id
     */
    public Long getParentOrgId() {
        return parentOrgId;
    }

    /**
     * 项目部上级组织id
     */
    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    /**
     * 项目部上级组织编码
     */
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    /**
     * 项目部上级组织编码
     */
    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    /**
     * 项目部上级组织名称
     */
    public String getParentOrgName() {
        return parentOrgName;
    }

    /**
     * 项目部上级组织名称
     */
    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    /**
     * 经办人id
     */
    @ReferSerialTransfer(referCode = "idm-user")
    public Long getEmployeeId() {
        return employeeId;
    }

    /**
     * 经办人id
     */
    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    /**
     * 经办人
     */
    public String getEmployeeName() {
        return employeeName;
    }

    /**
     * 经办人
     */
    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    /**
     * 经办人电话
     */
    public String getEmployeePhone() {
        return employeePhone;
    }

    /**
     * 经办人电话
     */
    public void setEmployeePhone(String employeePhone) {
        this.employeePhone = employeePhone;
    }
    /**
     * 经办人单位id
     */
    @ReferSerialTransfer(referCode = "idm-dept")
    public Long getDepartmentId() {
        return departmentId;
    }

    /**
     * 经办人单位id
     */
    @ReferDeserialTransfer
    public void setDepartmentId(Long departmentId) {
        this.departmentId = departmentId;
    }
    /**
     * 经办单位
     */
    public String getDepartmentName() {
        return departmentName;
    }

    /**
     * 经办单位
     */
    public void setDepartmentName(String departmentName) {
        this.departmentName = departmentName;
    }
    /**
     * 验收类型Id
     */
    @ReferSerialTransfer(referCode = "support-defdoc")
    public Long getCheckType() {
        return checkType;
    }

    /**
     * 验收类型Id
     */
    @ReferDeserialTransfer
    public void setCheckType(Long checkType) {
        this.checkType = checkType;
    }
    /**
     * 验收类型名称
     */
    public String getCheckTypeName() {
        return checkTypeName;
    }

    /**
     * 验收类型名称
     */
    public void setCheckTypeName(String checkTypeName) {
        this.checkTypeName = checkTypeName;
    }
    /**
     * 申请验收日期
     */
    public Date getApplyCheckDate() {
        return applyCheckDate;
    }

    /**
     * 申请验收日期
     */
    public void setApplyCheckDate(Date applyCheckDate) {
        this.applyCheckDate = applyCheckDate;
    }
    /**
     * 备注
     */
    public String getMemo() {
        return memo;
    }

    /**
     * 备注
     */
    public void setMemo(String memo) {
        this.memo = memo;
    }

    public String getBillStateName() {
        return billStateName;
    }

    public void setBillStateName(String billStateName) {
        this.billStateName = billStateName;
    }

    public Long getPatrolGroupId() {
        return patrolGroupId;
    }

    public void setPatrolGroupId(Long patrolGroupId) {
        this.patrolGroupId = patrolGroupId;
    }

    public String getPatrolGroup() {
        return patrolGroup;
    }

    public void setPatrolGroup(String patrolGroup) {
        this.patrolGroup = patrolGroup;
    }
    @ReferSerialTransfer(referCode = "support-defdoc")
    public Long getBuildUnitId() {
        return buildUnitId;
    }
    @ReferDeserialTransfer
    public void setBuildUnitId(Long buildUnitId) {
        this.buildUnitId = buildUnitId;
    }

    public String getBuildUnitName() {
        return buildUnitName;
    }

    public void setBuildUnitName(String buildUnitName) {
        this.buildUnitName = buildUnitName;
    }

    public String getMeasureValue() {
        return measureValue;
    }

    public void setMeasureValue(String measureValue) {
        this.measureValue = measureValue;
    }

    public String getPartName() {
        return partName;
    }

    public void setPartName(String partName) {
        this.partName = partName;
    }

    public String getFinishFlag() {
        return finishFlag;
    }

    public void setFinishFlag(String finishFlag) {
        this.finishFlag = finishFlag;
    }
    @ReferSerialTransfer(referCode = "support-defdoc")
    public Long getStructureType() {
        return structureType;
    }
    @ReferDeserialTransfer
    public void setStructureType(Long structureType) {
        this.structureType = structureType;
    }

    public String getMainIndexName() {
        return mainIndexName;
    }

    public void setMainIndexName(String mainIndexName) {
        this.mainIndexName = mainIndexName;
    }

    public Date getServiceDate() {
        return serviceDate;
    }

    public void setServiceDate(Date serviceDate) {
        this.serviceDate = serviceDate;
    }

    public String getFileFlag() {
        return fileFlag;
    }

    public void setFileFlag(String fileFlag) {
        this.fileFlag = fileFlag;
    }

    public String getProblem() {
        return problem;
    }

    public void setProblem(String problem) {
        this.problem = problem;
    }
    @ReferSerialTransfer(referCode = "idm-employee")
    public Long getProjectManagementId() {
        return projectManagementId;
    }
    @ReferDeserialTransfer
    public void setProjectManagementId(Long projectManagementId) {
        this.projectManagementId = projectManagementId;
    }

    public String getProjectManagementName() {
        return projectManagementName;
    }

    public void setProjectManagementName(String projectManagementName) {
        this.projectManagementName = projectManagementName;
    }
}
