package com.ejianc.business.danger.vo;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 危大工程登记
 *
 * @author generator
 */
public class DangerProjectVO extends BaseVO {
    private static final long serialVersionUID = 1L;

    private String billCode; // 单据编码
    private Long orgId; // 组织id
    private String orgName; // 组织名称
    private Integer billState; // 单据状态
    private String createUserName; // 编制人
    private Long operatorId; // 经办人ID
    private String operatorName; // 经办人姓名
    private String updateUserName; // 修改者
    private String remark; // 备注
    private Long projectId; // 工程
    private String projectName; // 工程名称
    private String dangerType; // 类型(1-超危工程（论证）2-危大工程)
    private String partProjectId; // 分部分项工程
    private String partProjectName; // 分部分项工程名称
    private String dangerDescription; // 描述
    private String partProjectAddress; // 分部分项工程位置
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date estimateImplDate; // 计划实施时间
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date estimateFinishDate; // 计划完成时间
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date implDate; // 实际实施时间
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date finishDate; // 实际完成时间
    private Long zjlzfz; // 专家论证方案
    private String zjlzfzName; // 专家论证方案名称
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date zjlzfzDate; // 专家论证时间
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date discloseDate; // 交底时间
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date checkDate; // 验收时间

    private String dutyPerson; // 责任人
    private String isFinish; // 是否完成(1-是 2-否)
    private String tags;//方案类型
    /**
     * 已施完工:已施完工
     * 在施:有实际开始时间，为本年，无实际完成时间
     * 待施:有计划开始时间，为本年，无实际开始时间
     * 超期未施:当前日期大于计划开始时间，无实际实施时间
     * 超期未完成:当前时间大于计划完成时间，仍然未完成的
     */
    private String status;//状态

    private List<DangerProjectZiVO> dangerProjectZiList = new ArrayList<>(); // 危大工程登记子表

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    public String getCreateUserName() {
        return createUserName;
    }

    public void setCreateUserName(String createUserName) {
        this.createUserName = createUserName;
    }

    public Long getOperatorId() {
        return operatorId;
    }

    public void setOperatorId(Long operatorId) {
        this.operatorId = operatorId;
    }

    public String getOperatorName() {
        return operatorName;
    }

    public void setOperatorName(String operatorName) {
        this.operatorName = operatorName;
    }

    public String getUpdateUserName() {
        return updateUserName;
    }

    public void setUpdateUserName(String updateUserName) {
        this.updateUserName = updateUserName;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    @ReferSerialTransfer(referCode = "project-set")
    public Long getProjectId() {
        return projectId;
    }

    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public String getDangerType() {
        return dangerType;
    }

    public void setDangerType(String dangerType) {
        this.dangerType = dangerType;
    }

    public String getPartProjectId() {
        return partProjectId;
    }

    public void setPartProjectId(String partProjectId) {
        this.partProjectId = partProjectId;
    }

    public String getPartProjectName() {
        return partProjectName;
    }

    public void setPartProjectName(String partProjectName) {
        this.partProjectName = partProjectName;
    }

    public String getDangerDescription() {
        return dangerDescription;
    }

    public void setDangerDescription(String dangerDescription) {
        this.dangerDescription = dangerDescription;
    }

    public String getPartProjectAddress() {
        return partProjectAddress;
    }

    public void setPartProjectAddress(String partProjectAddress) {
        this.partProjectAddress = partProjectAddress;
    }

    public Date getEstimateImplDate() {
        return estimateImplDate;
    }

    public void setEstimateImplDate(Date estimateImplDate) {
        this.estimateImplDate = estimateImplDate;
    }

    @ReferSerialTransfer(referCode = "tech-all")
    public Long getZjlzfz() {
        return zjlzfz;
    }

    @ReferDeserialTransfer
    public void setZjlzfz(Long zjlzfz) {
        this.zjlzfz = zjlzfz;
    }

    public String getZjlzfzName() {
        return zjlzfzName;
    }

    public void setZjlzfzName(String zjlzfzName) {
        this.zjlzfzName = zjlzfzName;
    }

    public Date getZjlzfzDate() {
        return zjlzfzDate;
    }

    public void setZjlzfzDate(Date zjlzfzDate) {
        this.zjlzfzDate = zjlzfzDate;
    }

    public Date getDiscloseDate() {
        return discloseDate;
    }

    public void setDiscloseDate(Date discloseDate) {
        this.discloseDate = discloseDate;
    }

    public Date getCheckDate() {
        return checkDate;
    }

    public void setCheckDate(Date checkDate) {
        this.checkDate = checkDate;
    }

    public Date getFinishDate() {
        return finishDate;
    }

    public void setFinishDate(Date finishDate) {
        this.finishDate = finishDate;
    }

    public String getDutyPerson() {
        return dutyPerson;
    }

    public void setDutyPerson(String dutyPerson) {
        this.dutyPerson = dutyPerson;
    }

    public String getIsFinish() {
        return isFinish;
    }

    public void setIsFinish(String isFinish) {
        this.isFinish = isFinish;
    }

    public List<DangerProjectZiVO> getDangerProjectZiList() {
        return dangerProjectZiList;
    }

    public void setDangerProjectZiList(List<DangerProjectZiVO> dangerProjectZiList) {
        this.dangerProjectZiList = dangerProjectZiList;
    }

    public Date getEstimateFinishDate() {
        return estimateFinishDate;
    }

    public void setEstimateFinishDate(Date estimateFinishDate) {
        this.estimateFinishDate = estimateFinishDate;
    }

    public Date getImplDate() {
        return implDate;
    }

    public void setImplDate(Date implDate) {
        this.implDate = implDate;
    }

    public String getTags() {
        return tags;
    }

    public void setTags(String tags) {
        this.tags = tags;
    }

    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }
}
