package com.ejianc.business.enums;

import org.apache.commons.lang3.StringUtils;

/**
 * @author baipengyan
 * @date 2022/8/30
 * @description 业务状态
 */
public enum BusinessStatusEnum {
	未开工("1"),
	在施("2"),
	停工("3"),
	项目中止("4"),
	待竣工("5"),
	竣工("6"),
	复工("7"),
	缺陷责任期("12"),
	缺陷责任期结束("13");
	private final String code;

	BusinessStatusEnum(String code) {
		this.code = code;
	}

	public static String getNameByCode(String businessStatus) {
		switch (businessStatus) {
			case "1":
				return "未开工";
			case "2":
				return "在施";
			case "3":
				return "停工";
			case "4":
				return "项目中止";
			case "5":
				return "待竣工";
			case "6":
				return "竣工";
			case "7":
				return "复工";
			case "12":
				return "缺陷责任期";
			case "13":
				return "缺陷责任期结束";
			case "18":
				return "未决算";
			case "8":
				return "决算中";
			case "9":
				return "已决算";
			case "10":
				return "资料未归档";
			case "11":
				return "资料已归档";
			case "14":
				return "开账正常";
			case "15":
				return "资金冻结";
			case "16":
				return "成本关门";
			case "17":
				return "已销账";
			default:
				return businessStatus;
		}

	}

	public String getCode() {
		return code;
	}

	public static String getCodeByName(String name) {
		if (StringUtils.isBlank(name)) {
			return null;
		}
		for (BusinessStatusEnum businessStatusEnum : BusinessStatusEnum.values()) {
			if (name.equals(businessStatusEnum.toString())) {
				return businessStatusEnum.getCode();
			}
		}
		return null;
	}

	public static String getCodeByCode(String code) {
		if (StringUtils.isBlank(code)) {
			return null;
		}
		switch (code){
			case "1"://未开工
				return "1";
			case "2"://在施
				return "2";
			case "3"://停工
				return "3";
			case "4"://复工
				return "4";
			case "5"://待竣工
				return "5";
			case "6"://竣工
				return "6";
			case "7"://项目中止
				return "7";
		}
		return null;
	}
}
