package com.ejianc.business.market.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;


/**
 * 验收用印申请
 * 
 * @author generator
 * 
 */
public class CompletionReportSealVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private String billCode; // 单据编码
    private Long orgId; // 组织id
    private String orgName; // 组织名称
    private Integer billState; // 单据状态
    private String createUserName; // 编制人
    private Long operatorId; // 经办人ID
    private String operatorName; // 经办人姓名
    private String updateUserName; // 修改者
    private String remark; // 备注
    private Long applyUser; // 申请人
    private String applyUserName; // 申请人名称
    private Date serviceDate; // 申请日期
    private Long projectId; // 项目
    private String projectName; // 项目名称
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date planFinishDate; // 计划验收日期
    private Long departmentId; // 所属项目部
    private String departmentName; // 所属项目部名称
    private Long applyDepartment; // 申请部门
    private String applyDepartmentName; // 申请部门名称
    private Long patrolGroup; // 所属巡检组
    private String patrolGroupName; // 所属巡检组名称
    private String sealFileName; // 用印文件名称
    private String fileType; // 验收资料类别
    private Integer sealNum; // 份数
    

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getCreateUserName() {
        return createUserName;
    }

    public void setCreateUserName(String createUserName) {
        this.createUserName = createUserName;
    }
    public Long getOperatorId() {
        return operatorId;
    }

    public void setOperatorId(Long operatorId) {
        this.operatorId = operatorId;
    }
    public String getOperatorName() {
        return operatorName;
    }

    public void setOperatorName(String operatorName) {
        this.operatorName = operatorName;
    }
    public String getUpdateUserName() {
        return updateUserName;
    }

    public void setUpdateUserName(String updateUserName) {
        this.updateUserName = updateUserName;
    }
    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }
    @ReferSerialTransfer(referCode="idm-user")
    public Long getApplyUser() {
        return applyUser;
    }
    @ReferDeserialTransfer
    public void setApplyUser(Long applyUser) {
        this.applyUser = applyUser;
    }
    public String getApplyUserName() {
        return applyUserName;
    }

    public void setApplyUserName(String applyUserName) {
        this.applyUserName = applyUserName;
    }
    public Date getServiceDate() {
        return serviceDate;
    }

    public void setServiceDate(Date serviceDate) {
        this.serviceDate = serviceDate;
    }
    @ReferSerialTransfer(referCode="project-set")
    public Long getProjectId() {
        return projectId;
    }
    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public Date getPlanFinishDate() {
        return planFinishDate;
    }

    public void setPlanFinishDate(Date planFinishDate) {
        this.planFinishDate = planFinishDate;
    }
    @ReferSerialTransfer(referCode="idm-org")
    public Long getDepartmentId() {
        return departmentId;
    }
    @ReferDeserialTransfer
    public void setDepartmentId(Long departmentId) {
        this.departmentId = departmentId;
    }
    public String getDepartmentName() {
        return departmentName;
    }

    public void setDepartmentName(String departmentName) {
        this.departmentName = departmentName;
    }
    @ReferSerialTransfer(referCode="idm-dept")
    public Long getApplyDepartment() {
        return applyDepartment;
    }
    @ReferDeserialTransfer
    public void setApplyDepartment(Long applyDepartment) {
        this.applyDepartment = applyDepartment;
    }
    public String getApplyDepartmentName() {
        return applyDepartmentName;
    }

    public void setApplyDepartmentName(String applyDepartmentName) {
        this.applyDepartmentName = applyDepartmentName;
    }
    @ReferSerialTransfer(referCode="support-defdoc")
    public Long getPatrolGroup() {
        return patrolGroup;
    }
    @ReferDeserialTransfer
    public void setPatrolGroup(Long patrolGroup) {
        this.patrolGroup = patrolGroup;
    }
    public String getPatrolGroupName() {
        return patrolGroupName;
    }

    public void setPatrolGroupName(String patrolGroupName) {
        this.patrolGroupName = patrolGroupName;
    }
    public String getSealFileName() {
        return sealFileName;
    }

    public void setSealFileName(String sealFileName) {
        this.sealFileName = sealFileName;
    }
    public String getFileType() {
        return fileType;
    }

    public void setFileType(String fileType) {
        this.fileType = fileType;
    }
    public Integer getSealNum() {
        return sealNum;
    }

    public void setSealNum(Integer sealNum) {
        this.sealNum = sealNum;
    }
    
}
