package com.ejianc.business.market.service.impl;

import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.ejianc.business.market.bean.CompletionWorkReportEntity;
import com.ejianc.business.market.enums.BusinessStatusEnum;
import com.ejianc.business.market.enums.ProjectStatusEnum;
import com.ejianc.business.market.service.ICompletionWorkReportService;
import com.ejianc.foundation.share.api.IProjectSetApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Date;

@Service("completionWorkReport")
public class CompletionWorkReportBpmServiceImpl implements ICommonBusinessService {

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IProjectSetApi iProjectSetApi;
    @Autowired
    private ICompletionWorkReportService service;
    @Autowired
    private IProjectSetApi projectSetApi;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    /**
     * 提交前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO
        return CommonResponse.success();
    }

    ;

    /**
     * 提交完回调
     *
     * @param
     * @return
     */
    @Override
    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO
        return CommonResponse.success();
    }

    /**
     * 有审批流的撤回前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {

        return CommonResponse.error("该单据不支持弃审和撤回");
    }

    ;

    /**
     * 有审批流的撤回后回调
     *
     * @param
     * @return
     */
    @Override
    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    ;

    /**
     * 审批节点审批中时节点审批前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    ;

    /**
     * 终审审核前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO
        return CommonResponse.success();
    }

    /**
     * 终审审核完回调
     *
     * @param
     * @return
     */
    @Override
    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        CompletionWorkReportEntity completionWorkReportEntity = service.selectById(billId);
        if (completionWorkReportEntity != null) {
            UpdateWrapper<CompletionWorkReportEntity> updateWrapper = new UpdateWrapper<>();
            updateWrapper.eq("id", billId);
            updateWrapper.set("effective_time", new Date());
            //审批通过更新生效时间
            service.update(updateWrapper);

            // 更新【项目池】对应项目的项目状态为竣工，业务状态为竣工验收
            if (completionWorkReportEntity.isCompletionAcceptanceFlag()) {
                CommonResponse<String> res = iProjectSetApi.changeProjectStatus(completionWorkReportEntity.getProjectId(), ProjectStatusEnum.竣工.getCode(), BusinessStatusEnum.竣工验收.getCode(), null, null, null);
                if (!res.isSuccess()) {
                    logger.info("验收报告【{}】更新【项目池】项目状态为竣工，业务状态为竣工验收失败，失败原因：{}", completionWorkReportEntity.getBillCode(), res.getMsg());
                    throw new BusinessException("验收报告【" + completionWorkReportEntity.getBillCode() + "】更新【项目池】结算状态为结算中失败，失败原因：" + res.getMsg());
                }
            }
        }
        return CommonResponse.success();
    }

    /**
     * 弃审前事件回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO
        return CommonResponse.error("该单据不支持弃审和撤回");
    }

    /**
     * 弃审后事件回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO
        // 参数是单据类型编码字符串 根据需求是否打开下面代码
        /**CommonResponse<String> resp = billTypeApi.checkQuote(billTypeCode, billId);
         if(!resp.isSuccess()){
         return CommonResponse.error("无法撤回！"+resp.getMsg());
         }*/
        return CommonResponse.success();
    }

}
