package com.ejianc.business.market.service.impl;

import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.market.mapper.NodeCostAnalysisMapper;
import com.ejianc.business.market.bean.NodeCostAnalysisEntity;
import com.ejianc.business.market.service.INodeCostAnalysisService;

import java.util.Arrays;

/**
 * 节点成本分析实体
 * 
 * @author generator
 * 
 */
@Service("nodeCostAnalysisService")
public class NodeCostAnalysisServiceImpl extends BaseServiceImpl<NodeCostAnalysisMapper, NodeCostAnalysisEntity> implements INodeCostAnalysisService{

    /**
     * 判断是否能新增单据（除本单据外无未生效的单据）
     * @param id
     * @param projectId
     * @return
     */
    @Override
    public boolean getSaveBillFlag(Long id, Long projectId) {
        QueryParam queryParam = new QueryParam();
        if (null != id){
            queryParam.getParams().put("id", new Parameter(QueryParam.NE, id));
        }
        queryParam.getParams().put("projectId", new Parameter(QueryParam.EQ, projectId));
        queryParam.getParams().put("billState", new Parameter(QueryParam.NOT_IN,
                Arrays.asList(new Integer[]{BillStateEnum.COMMITED_STATE.getBillStateCode(),BillStateEnum.PASSED_STATE.getBillStateCode()})));
        return super.queryList(queryParam).isEmpty();
    }
}
