package com.ejianc.business.market.controller;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;

import cn.hutool.core.io.IoUtil;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.nio.charset.StandardCharsets;
import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.core.io.ClassPathResource;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.market.bean.NodeCostAnalysisEntity;
import com.ejianc.business.market.service.INodeCostAnalysisService;
import com.ejianc.business.market.vo.NodeCostAnalysisVO;

/**
 * 节点成本分析实体
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("nodeCostAnalysis")
public class NodeCostAnalysisController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "NODE_COST_ANALYSIS_";//此处需要根据实际修改

    @Autowired
    private INodeCostAnalysisService service;

    @Autowired
    private SessionManager sessionManager;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<NodeCostAnalysisVO> saveOrUpdate(@RequestBody NodeCostAnalysisVO saveOrUpdateVO) {
    	NodeCostAnalysisEntity entity = BeanMapper.map(saveOrUpdateVO, NodeCostAnalysisEntity.class);
    	if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
    	if (!service.getSaveBillFlag(saveOrUpdateVO.getId(), saveOrUpdateVO.getProjectId())){
    	    return CommonResponse.error("该项目下已存在未生效的节点成本分析单据，不能新增！");
        }
    	service.saveOrUpdate(entity, false);
    	NodeCostAnalysisVO vo = BeanMapper.map(entity, NodeCostAnalysisVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<NodeCostAnalysisVO> queryDetail(Long id) {
    	NodeCostAnalysisEntity entity = service.selectById(id);
    	NodeCostAnalysisVO vo = BeanMapper.map(entity, NodeCostAnalysisVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<NodeCostAnalysisVO> vos) {
        service.removeByIds(vos.stream().map(NodeCostAnalysisVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<NodeCostAnalysisVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("nodeName");

        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        //若当前上下文为项目部，则根据项目部Id来进行查询
        if (OrgVO.ORG_TYPE_DEPARTMENT.equals(Integer.valueOf(InvocationInfoProxy.getOrgType()))) {
            param.getParams().put("orgId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getOrgId()));
        } else {
            CommonResponse<List<OrgVO>> orgResp = iOrgApi.findChildrenByParentIdWithoutProjectDept(InvocationInfoProxy.getOrgId());
            if (!orgResp.isSuccess()) {
                logger.error("分页查询失败，获取当前本下组织信息失败, {}", orgResp.getMsg());
                return CommonResponse.error("查询失败，获取组织信息失败！");
            }
            param.getParams().put("parentOrgId", new Parameter(QueryParam.IN,
                    orgResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        }

        IPage<NodeCostAnalysisEntity> page = service.queryPage(param,false);
        IPage<NodeCostAnalysisVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), NodeCostAnalysisVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }



    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<NodeCostAnalysisEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("NodeCostAnalysis-export.xlsx", beans, response);
    }

    /**
     * 导出
     *
     * @param response 响应头
     */
    @PostMapping(value = "/analysisReportWordExport")
    public void analysisReportWordExport(HttpServletResponse response) throws IOException {
        ClassPathResource resource = new ClassPathResource("excel/工程成本分析报告.docx");
        IoUtil.copy(resource.getInputStream(), response.getOutputStream());
    }

    /**
     * 导出
     *
     * @param response 响应头
     */
    @PostMapping(value = "/analysisCollectExcelExport")
    public void analysisCollectExcelExport(HttpServletResponse response) throws IOException {
//        response.setHeader("Content-Disposition", "attachment;filename=" + new String("TestName".getBytes(StandardCharsets.UTF_8),StandardCharsets.ISO_8859_1));
        ClassPathResource resource = new ClassPathResource("excel/工程成本分析汇总表.xlsx");
        IoUtil.copy(resource.getInputStream(), response.getOutputStream());
    }


}
