package com.ejianc.business.market.controller;

import java.io.Serializable;

import com.ejianc.business.bid.api.BidManageApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IDefdocApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.DefdocDetailVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.*;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;

import com.ejianc.business.market.bean.ProjectSetEntity;
import com.ejianc.business.market.service.IProjectSetService;
import com.ejianc.business.market.vo.ProjectSetVO;

/**
 * 项目立项表
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("projectSet")
public class ProjectSetController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private BidManageApi bidManageApi;

    @Autowired
    private IDefdocApi defdocApi;

    private static final String BILL_CODE = "pro-market-project-001";//此处需要根据实际修改

    @Autowired
    private IProjectSetService service;

    @Autowired
    private SessionManager sessionManager;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ProjectSetVO> saveOrUpdate(@RequestBody ProjectSetVO saveOrUpdateVO) {
    	ProjectSetEntity entity = BeanMapper.map(saveOrUpdateVO, ProjectSetEntity.class);
        QueryParam param = new QueryParam();
    	if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(entity.getCode() == null) {
                if(billCode.isSuccess()) {
                    entity.setCode(billCode.getData());//此处需要根据实际修改 删除本行或者下一行
                }else{
                    throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
                }
            }
            if(saveOrUpdateVO.getProjectDepartmentId()!=null){
                param.getParams().put("projectDepartmentId",new Parameter(QueryParam.EQ,saveOrUpdateVO.getProjectDepartmentId()));
                List<ProjectSetEntity> list = service.queryList(param,false);
                if(!list.isEmpty()){
                    return CommonResponse.error("所选施工项目部已立项，无法新增立项！");
                }
            }
        }else {
            if(saveOrUpdateVO.getProjectDepartmentId()!=null){
                param.getParams().put("projectDepartmentId",new Parameter(QueryParam.EQ,saveOrUpdateVO.getProjectDepartmentId()));
                List<ProjectSetEntity> list = service.queryList(param,false);
                if(!list.isEmpty() && !list.get(0).getId().equals(saveOrUpdateVO.getId())){
                    return CommonResponse.error("所选施工项目部已立项，无法修改成该施工项目部立项！");
                }
            }
        }

    	if((null != entity.getMeasureType()) && StringUtils.isNotBlank(entity.getMeasureValue())) {
            CommonResponse<DefdocDetailVO> docResp =defdocApi.getDefDocById(entity.getMeasureType());
            if(!docResp.isSuccess() || null == docResp.getData()) {
                logger.error("根据Id-{}查询工程度量方式失败：{}", entity.getMeasureType(), JSONObject.toJSONString(docResp));
                return CommonResponse.error("查询度量方式档案信息失败！");
            }
            String measureUnitName = docResp.getData().getName();
            if(measureUnitName.contains("（")) {
                //替换中文括号
                measureUnitName = measureUnitName.replace("（", "(");
                measureUnitName = measureUnitName.replace("）", ")");
            }
            if(measureUnitName.contains("(")) {
                //提取括号中的内容
                measureUnitName = (measureUnitName.split("\\(")[1]).split("\\)")[0];
            }
    	    entity.setMeasure(entity.getMeasureValue()+measureUnitName);
        }

    	service.saveOrUpdate(entity, false);
    	ProjectSetVO vo = BeanMapper.map(entity, ProjectSetVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description saveBid 从中标工程中新增
     */
    @RequestMapping(value = "/saveBid", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ProjectSetVO> saveBid(@RequestBody ProjectSetVO saveOrUpdateVO) {

        ProjectSetEntity entity = BeanMapper.map(saveOrUpdateVO, ProjectSetEntity.class);
        if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setCode(billCode.getData());//此处需要根据实际修改 删除本行或者下一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }

        if((null != entity.getMeasureType()) && StringUtils.isNotBlank(entity.getMeasureValue())) {
            CommonResponse<DefdocDetailVO> docResp =defdocApi.getDefDocById(entity.getMeasureType());
            if(!docResp.isSuccess() || null == docResp.getData()) {
                logger.error("根据Id-{}查询工程度量方式失败：{}", entity.getMeasureType(), JSONObject.toJSONString(docResp));
                return CommonResponse.error("查询度量方式档案信息失败！");
            }
            entity.setMeasure(docResp.getData().getName()+entity.getMeasureValue());
        }
        service.saveOrUpdate(entity, false);
        bidManageApi.changeUseFlag(entity.getSourceBillId(),1);
        ProjectSetVO vo = BeanMapper.map(entity, ProjectSetVO.class);
        return CommonResponse.success("保存成功！",vo);
    }
    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ProjectSetVO> queryDetail(Long id) {
    	ProjectSetEntity entity = service.selectById(id);
    	ProjectSetVO vo = BeanMapper.map(entity, ProjectSetVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ProjectSetVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (ProjectSetVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        if(ListUtil.isNotEmpty(vos)){
            for (ProjectSetVO vo : vos) {
                ProjectSetEntity entity = service.selectById(vo.getId());
                bidManageApi.changeUseFlag(entity.getSourceBillId(),0);
                if(entity.getProjectDepartmentId()!=null){
                    /** 施工项目部不为空 */
                    CommonResponse<OrgVO> response = iOrgApi.getOneById(entity.getProjectDepartmentId());
                    if(!response.isSuccess()){
                        return CommonResponse.error("删除失败！查询施工项目部信息出错: "+response.getMsg());
                    }
                    /** 将施工项目部的项目编码置空，再保存 */
                    OrgVO orgVO = response.getData();
                    if(StringUtils.isNotEmpty(orgVO.getProjectCode())){
                        /** 不为空，置空，为空，不处理*/
                        orgVO.setProjectCode(null);
                        CommonResponse<OrgVO> resp = iOrgApi.saveOrgInfo(orgVO);
                        if(!resp.isSuccess()) {
                            return CommonResponse.error("删除失败！修改施工项目部信息出错: " + resp.getMsg());
                        }
                    }
                }
            }
        }
        service.removeByIds(vos.stream().map(ProjectSetVO::getId).collect(Collectors.toList()),true);


        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<ProjectSetVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        param.getFuzzyFields().add("code");
        param.getFuzzyFields().add("name");
        param.getFuzzyFields().add("shortName");
        param.getFuzzyFields().add("project_management_name");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        List<OrgVO> orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        //项目部 id
        List<Long> departmentIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            if(5 == org.getOrgType()) {
                //项目部
                departmentIds.add(org.getId());
            } else {
                //普通组织
                commonOrgIds.add(org.getId());
            }
        });
        /** 要求主表有orgId字段，保存单据所属组织 */
        if(commonOrgIds.size() != 0) {
            param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
        }else if(departmentIds.size() != 0){
            param.getParams().put("projectDepartmentId", new Parameter(QueryParam.IN, departmentIds));
        }else {
           return CommonResponse.success("查询列表数据成功！",new Page<>(1, param.getPageSize(), 0));
        }

        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */

        IPage<ProjectSetEntity> page = service.queryPage(param,false);
        IPage<ProjectSetVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());

        pageData.setRecords(BeanMapper.mapList(page.getRecords(), ProjectSetVO.class));
        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        param.getFuzzyFields().add("name");
        param.getFuzzyFields().add("shortName");
        param.getFuzzyFields().add("code");

        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));

        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<ProjectSetEntity> list = service.queryList(param);
        List<ProjectSetVO> voList = new ArrayList<>();
        if(list.size()>0){
            voList = BeanMapper.mapList(list,ProjectSetVO.class);
            for (ProjectSetVO vo: voList){
                vo.setBillStateName(BillStateEnum.getEnumByStateCode(vo.getBillState()).getDescription());
            }
        }
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", voList);
        ExcelExport.getInstance().export("projectSet-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/refProjectSetData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<ProjectSetVO>> refProjectSetData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<ProjectSetEntity> page = service.queryPage(param,false);
        IPage<ProjectSetVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), ProjectSetVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }

    @RequestMapping(value = "/getCurrentOrgParentInfo", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<OrgVO> getCurrentOrgParentInfo() {
        return iOrgApi.findParentByOrgId(InvocationInfoProxy.getOrgId());
    }

    @RequestMapping(value = "/getTotalInfo", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> getTotalInfo(@RequestBody QueryParam param) {
        JSONObject res = new JSONObject();

        /** 模糊搜索配置字段示例 */
        param.getFuzzyFields().add("code");
        param.getFuzzyFields().add("name");
        param.getFuzzyFields().add("project_management_name");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        List<OrgVO> orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        //项目部 id
        List<Long> departmentIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            if(5 == org.getOrgType()) {
                //项目部
                departmentIds.add(org.getId());
            } else {
                //普通组织
                commonOrgIds.add(org.getId());
            }
        });
        /** 要求主表有orgId字段，保存单据所属组织 */
        if(commonOrgIds.size() != 0) {
            param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
        }else if(departmentIds.size() != 0){
            param.getParams().put("projectDepartmentId", new Parameter(QueryParam.IN, departmentIds));
        }else {
            res.put("total",0);
            res.put("fatherTotal",0);
            res.put("eTotal",0);
            return CommonResponse.success(res);
        }

        List<ProjectSetEntity> setEntities = service.queryList(param,false);
        res.put("total",setEntities.size());
        if(param.getParams().get("attribute")!=null){
            Parameter parameter = param.getParams().get("attribute");
            if("1".equals(parameter.getValue())){
                res.put("fatherTotal",setEntities.size());
                res.put("eTotal",0);
            }else {
                res.put("fatherTotal",0);
                res.put("eTotal",setEntities.size());
            }
        }else {
            param.getParams().put("attribute",new Parameter(QueryParam.EQ,1));
            setEntities = service.queryList(param,false);
            res.put("fatherTotal",setEntities.size());
            param.getParams().put("attribute",new Parameter(QueryParam.EQ,2));
            setEntities = service.queryList(param,false);
            res.put("eTotal",setEntities.size());
        }
        return CommonResponse.success(res);
    }
}
