package com.ejianc.business.market.controller.projectSurvey;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.market.service.ProjectSurveyService;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import java.util.stream.Collectors;

/**
 * 领导门户-项目概况
 */
@RestController
@RequestMapping("/projectSurvey")
public class ProjectSurveyController {

    @Autowired
    private ProjectSurveyService service;

    //项目概况
    @RequestMapping(value = "/projectCount", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<JSONObject> projectCount(@RequestParam(value = "range", required = false) String range, @RequestParam(value = "name", required = false) String name, @RequestParam(value = "dateIn", required = false) String dateIn, @RequestParam(value = "orgId", required = false) Long orgId) {
        return service.projectCount(range, name, dateIn, orgId);
    }

    /**
     * 获取领导门户的项目的概况的 地图和地区分布柱状图 的数据
     */
//
    @RequestMapping(value = "/getProjectColumnarInfo", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<JSONObject> getProjectColumnarInfo(@RequestParam(value = "range", required = false) String range, @RequestParam(value = "name", required = false) String name, @RequestParam(value = "dateIn", required = false) String dateIn, @RequestParam(value = "orgId", required = false) Long orgId) {
        return service.getProjectColumnarInfo(range, name, dateIn, orgId);
    }
}
