package com.ejianc.business.market.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.labor.api.IProjectTeamApi;
import com.ejianc.business.market.vo.ProjectSetVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.api.IProjectSetApi;
import com.ejianc.foundation.share.vo.ProjectPoolSetVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.support.idworker.util.IdWorker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.market.mapper.ProjectSetMapper;
import com.ejianc.business.market.bean.ProjectSetEntity;
import com.ejianc.business.market.service.IProjectSetService;

import java.nio.charset.StandardCharsets;

/**
 * 项目立项
 * 
 * @author generator
 * 
 */
@Service("projectSetService")
public class ProjectSetServiceImpl extends BaseServiceImpl<ProjectSetMapper, ProjectSetEntity> implements IProjectSetService{

    @Autowired
    private IProjectSetApi iProjectSetApi;

    @Autowired
    private IOrgApi orgApi;

    @Autowired
    private IProjectTeamApi projectTeamApi;

    @Autowired
    private IProjectSetService service;
    @Override
    public CommonResponse<String> pushProjectPoolSet(ProjectSetEntity projectSetEntity, String billTypeCode) {

        ProjectSetVO projectSetVO = BeanMapper.map(projectSetEntity, ProjectSetVO.class);

        //项目部
        OrgVO projectDepartment = null;
        if(null == projectSetVO.getProjectDepartmentId()) {
            //创建项目部
            projectDepartment = generateProjectDepartment(projectSetVO, true);
            projectSetEntity.setProjectDepartmentId(projectDepartment.getId());
            projectSetEntity.setProjectDepartmentName(projectDepartment.getName());
        }else {
            projectDepartment = orgApi.getOneById(projectSetVO.getProjectDepartmentId()).getData();
            if(projectDepartment!=null){
                projectDepartment.setProjectCode(projectSetVO.getCode());
            }
        }

        //保存更新项目部信息
        if(null != projectDepartment) {
            CommonResponse<OrgVO> resp = orgApi.saveOrgInfo(projectDepartment);
            if(!resp.isSuccess()) {
                throw new BusinessException("提交项目信息失败，保存项目部信息出错: " + resp.getMsg());
            }
        }
        service.saveOrUpdate(projectSetEntity, false);

        // 初始化项目花名册
        projectTeamApi.initData(JSON.parseObject(JSONObject.toJSONString(projectSetEntity)));

        ProjectPoolSetVO projectPoolSetVO = BeanMapper.map(projectSetEntity, ProjectPoolSetVO.class);
        return iProjectSetApi.pushProjectPoolSet(JSONObject.toJSONString(projectPoolSetVO).getBytes(StandardCharsets.UTF_8));
    }

    /**
     * 生成项目对应的项目部信息
     *
     * @param
     * @return
     */
    private OrgVO generateProjectDepartment(ProjectSetVO projectSetVO, boolean isSyncProject) {
        if(projectSetVO.getOrgId() == null) {
            throw new BusinessException("提交项目信息失败，项目所属组织信息不存在。");
        }
        CommonResponse<OrgVO> response = orgApi.getOneById(projectSetVO.getOrgId());
        OrgVO parentOrg = null;
        if(response.isSuccess()) {
            parentOrg = response.getData();
        } else {
            throw new BusinessException("提交项目信息失败，查询项目所属组织信息失败: " + response.getMsg() );
        }
        if(null == parentOrg) {
            throw new BusinessException("提交项目信息失败，项目所属组织信息不存在。");
        }
        OrgVO projectDepartment = new OrgVO();
        projectDepartment.setId(IdWorker.getId());
        projectDepartment.setParentId(projectSetVO.getOrgId());
        projectDepartment.setTenantId(parentOrg.getTenantId());
        projectDepartment.setEnterpriseId(parentOrg.getEnterpriseId());
        projectDepartment.setIsParent(false);
        projectDepartment.setName(projectSetVO.getName());
        projectDepartment.setShortName(projectSetVO.getShortName());
        projectDepartment.setState(1);
        projectDepartment.setProjectCode(projectSetVO.getCode());
        projectDepartment.setProjectState(1);
        //项目部类型
        projectDepartment.setOrgType(OrgVO.ORG_TYPE_DEPARTMENT);

        return projectDepartment;
    }

}
