package com.ejianc.business.market.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.market.bean.CompletionWorkReportEntity;
import com.ejianc.business.market.bean.FinishWorkReportEntity;
import com.ejianc.business.market.bean.StartWorkReportEntity;
import com.ejianc.business.market.mapper.FinishWorkReportMapper;
import com.ejianc.business.market.service.ICompletionWorkReportService;
import com.ejianc.business.market.service.IFinishWorkReportService;
import com.ejianc.business.market.service.IProjectSetService;
import com.ejianc.business.market.service.IStartWorkReportService;
import com.ejianc.business.market.utils.CommonUtils;
import com.ejianc.business.market.vo.StartWorkReportVO;
import com.ejianc.business.targetcost.api.IDutyApi;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.api.IProjectPoolApi;
import com.ejianc.foundation.share.consts.ProjectBusinessStatusEnum;
import com.ejianc.foundation.share.vo.ProjectPoolSetVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 开工报告
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("startWorkReport")
public class StartWorkReportController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    @Autowired
    private IDutyApi dutyApi;

    private static final String BILL_CODE = "START_WORK_REPORT";//此处需要根据实际修改

    @Autowired
    private IStartWorkReportService service;

    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private ICompletionWorkReportService completionWorkReportService;

    @Autowired
    private IFinishWorkReportService finishWorkReportService;


    @Autowired
    private IProjectSetService projectSetService;

    @Autowired
    private IProjectPoolApi projectPoolApi;
    @Autowired
    private FinishWorkReportMapper finishWorkReportMapper;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<StartWorkReportVO> saveOrUpdate(@RequestBody StartWorkReportVO saveOrUpdateVO) {
        StartWorkReportEntity entity = BeanMapper.map(saveOrUpdateVO, StartWorkReportEntity.class);
        if(entity.getId() == null || entity.getId() == 0){

            CommonResponse commonResponse = service.checkProject(saveOrUpdateVO.getProjectId());
            if(!commonResponse.isSuccess()){
                return commonResponse;
            }
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        service.saveOrUpdate(entity, false);
        StartWorkReportVO vo = BeanMapper.map(entity, StartWorkReportVO.class);
        return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<StartWorkReportVO> queryDetail(Long id) {
        StartWorkReportEntity entity = service.selectById(id);
        StartWorkReportVO vo = BeanMapper.map(entity, StartWorkReportVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<StartWorkReportVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (StartWorkReportVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(StartWorkReportVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<StartWorkReportVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("departmentName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        UserContext userContextCache =sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if(StringUtils.isNotBlank(authOrgIds)){//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        }else {//pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        //项目部 id
        List<Long> departmentIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            if(5 == org.getOrgType()) {
                //项目部
                departmentIds.add(org.getId());
            } else {
                //普通组织
                commonOrgIds.add(org.getId());
            }
        });
        if(CollectionUtils.isNotEmpty(commonOrgIds)) {
            /** 要求主表有orgId字段，保存单据所属组织 */
            param.getParams().put("parentOrgId", new Parameter(QueryParam.IN, commonOrgIds));
        } else if(CollectionUtils.isNotEmpty(departmentIds)) {
            /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
            param.getParams().put("orgId", new Parameter(QueryParam.IN, departmentIds));
        }
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */

        IPage<StartWorkReportEntity> page = service.queryPage(param,false);
        IPage<StartWorkReportVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), StartWorkReportVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("departmentName");
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<StartWorkReportEntity> list = service.queryList(param);
        List<StartWorkReportVO> exportVOS = new ArrayList<>();
        list.forEach(vo -> {
            StartWorkReportVO exportVO = BeanMapper.map(vo, StartWorkReportVO.class);
            exportVO.setBillStateName(BillStateEnum.getEnumByStateCode(vo.getBillState()).getDescription());
            exportVOS.add(exportVO);
        });
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", exportVOS);
        ExcelExport.getInstance().export("StartWorkReport-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param
     * @Return void
     */
    @RequestMapping(value = "/refStartWorkReportData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<StartWorkReportVO>> refStartWorkReportData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                           String condition,
                                                                           String searchObject,
                                                                           String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<StartWorkReportEntity> page = service.queryPage(param,false);
        IPage<StartWorkReportVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), StartWorkReportVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
    }

    /**
     * @Description queryDetail 查询详情
     * @param projectId
     */
    @RequestMapping(value = "/queryDetailByProjectId", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<StartWorkReportVO>> queryDetailByProjectId(Long projectId) {
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("projectId",new Parameter(QueryParam.EQ,projectId));
        queryParam.getParams().put("billState", new Parameter(QueryParam.IN,
                Arrays.asList(new Integer[]{BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()})));
        List<StartWorkReportEntity> startWorkReportEntities = service.queryList(queryParam);
        List<StartWorkReportVO> startWorkReportVOS = BeanMapper.mapList(startWorkReportEntities, StartWorkReportVO.class);
        return CommonResponse.success("查询详情数据成功！",startWorkReportVOS);
    }

    /**
     * 根据项目校验报告唯一性
     * @param projectId
     * @param billId
     * @return
     */
    @GetMapping(value = "/startWorkReportCheck")
    @ResponseBody
    public CommonResponse<String> startWorkReportCheck(@RequestParam(value = "projectId") Long projectId,
                                                      @RequestParam(value = "billId", required = false) Long billId){

        QueryWrapper<StartWorkReportEntity> query = new QueryWrapper<>();
        query.eq("project_id", projectId);
        query.eq("bill_state", BillStateEnum.UNCOMMITED_STATE);
        query.eq("dr", BaseVO.DR_UNDELETE);
        StartWorkReportEntity one = service.getOne(query);
        if(one!=null && (null == billId || !one.getId().equals(billId))){
            return CommonResponse.error("该项目下已存在未生效单据！");
        }
        return CommonResponse.success("该项目适用当前单据！");
    }

    @PostMapping(value = "getBuildDutyInfo")
    @ResponseBody
    public CommonResponse<JSONObject> getBuildDutyInfo(@RequestBody JSONObject params) {
        JSONObject resp = new JSONObject();
        Long orgId = InvocationInfoProxy.getOrgId();
        if(params.containsKey("orgId")) {
            orgId = params.getLong("orgId");
        }
        int nearlyDays = -30;
        if(params.containsKey("nearlyDays")) {
            nearlyDays = params.getInteger("nearlyDays");
        }

        QueryParam queryParam = new QueryParam();
        queryParam.getOrderMap().put("createTime", "desc");
        queryParam.getParams().put("parentOrgId", new Parameter(QueryParam.IN,
                iOrgApi.findChildrenByParentIdWithoutProjectDept(orgId).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        queryParam.getParams().put("start_work_date", new Parameter(QueryParam.GE, DateUtils.addDays(new Date(), nearlyDays)));
        List<StartWorkReportEntity> dbList = service.queryList(queryParam);

        logger.info("*********查询符号条件开工报告数量：{}个", dbList.size());
        if(CollectionUtils.isNotEmpty(dbList)) {
            List<Long> projectIds = dbList.stream().map(StartWorkReportEntity::getProjectId).collect(Collectors.toList());

            //查询 状态为在施项目
            QueryParam prjQuery = new QueryParam();
            prjQuery.getParams().put("id", Parameter.getInInstance(projectIds));
            prjQuery.getParams().put("businessStatus", new Parameter(QueryParam.EQ, ProjectBusinessStatusEnum.正式开工.getBusinessStatus()));
            CommonResponse<JSONArray> prjResp= projectPoolApi.queryArray(prjQuery);
            if(!prjResp.isSuccess()) {
                logger.error("根据项目IDs-查询项目信息失败， {}", JSONObject.toJSON(projectIds), prjResp);
                return CommonResponse.error("查询项目信息失败！");
            }
            JSONArray projectJsonArr = prjResp.getData();
            logger.info("*********存在开工报告的 在施项目数：{}", projectJsonArr.size());
            if(projectJsonArr.size() != 0) {
                List<Long> validProjectIds = new ArrayList<>();
                JSONObject tmp = null;
                for(Object o : projectJsonArr) {
                    tmp = JSONObject.parseObject(JSONObject.toJSONString(o));
                    validProjectIds.add(tmp.getLong("id"));
                }
                resp.put("needNum", validProjectIds.size());
                resp.put("needProjectIds", JSONObject.toJSONString(validProjectIds));

                CommonResponse<List<Long>> extProjectIdsResp = dutyApi.queryDutyByProjectIds(validProjectIds);
                if(!extProjectIdsResp.isSuccess()) {
                    logger.error("根据项目IDs-查询项目策划信息失败， {}", JSONObject.toJSON(validProjectIds), extProjectIdsResp);
                    return CommonResponse.error("查询项目策划信息失败！");
                }
                logger.info("******项目策划项目数：{}", extProjectIdsResp.getData().size());
                List<Long> extProjectIds= extProjectIdsResp.getData();
                validProjectIds.removeAll(extProjectIds);

                resp.put("finishNum", extProjectIds.size());
                resp.put("finishProjectIds", extProjectIds);
                resp.put("unFinishNum", projectIds.size());
                resp.put("unFinishProjectIds", projectIds);
                return CommonResponse.success("查询成功！", resp);
            }
        }

        resp.put("needNum", 0);
        resp.put("needProjectIds", 0);
        resp.put("finishNum", 0);
        resp.put("finishProjectIds", new ArrayList<>());
        resp.put("unFinishNum", 0);
        resp.put("unFinishProjectIds", new ArrayList<>());
        return CommonResponse.success("查询成功！", resp);
    }

    /**
     * 项目成本策划完成情况
     * @param params
     * @return
     */
    @PostMapping(value = "getProjectCostInfo")
    @ResponseBody
    public CommonResponse<JSONObject> getProjectCostInfo(@RequestBody JSONObject params) {
        JSONObject resp = new JSONObject();
        Long orgId = InvocationInfoProxy.getOrgId();
        if(params.containsKey("orgId")) {
            orgId = params.getLong("orgId");
        }
//        int nearlyDays = -30;
//        if(params.containsKey("nearlyDays")) {
//            nearlyDays = params.getInteger("nearlyDays");
//        }
//
//        QueryParam queryParam = new QueryParam();
//        queryParam.getOrderMap().put("createTime", "desc");
//        queryParam.getParams().put("parentOrgId", new Parameter(QueryParam.IN,
//                iOrgApi.findChildrenByParentId(orgId).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
//        queryParam.getParams().put("start_work_date", new Parameter(QueryParam.GE, DateUtils.addDays(new Date(), nearlyDays)));
//        List<StartWorkReportEntity> dbList = service.queryList(queryParam);
//
//        logger.info("*********查询符号条件开工报告数量：{}个", dbList.size());
//        if(CollectionUtils.isNotEmpty(dbList)) {
//            List<Long> projectIds = dbList.stream().map(StartWorkReportEntity::getProjectId).collect(Collectors.toList());



                //查询所有项目
                QueryParam prjQuery = new QueryParam();
//        CommonResponse<JSONArray> prjResp= projectPoolApi.queryArray(prjQuery);
                CommonResponse<List<ProjectPoolSetVO>> prjResp = projectPoolApi.queryProjectList(prjQuery);
                if(!prjResp.isSuccess()) {
                    return CommonResponse.error("查询项目信息失败！");
                }
                List<ProjectPoolSetVO> projectData = prjResp.getData();
                logger.info("*********存在开工报告的 在施项目数：{}", projectData.size());
                if(projectData.size() != 0) {
                    List<Long> validProjectIds = new ArrayList<>();
                    for(ProjectPoolSetVO o : projectData) {
                        validProjectIds.add(o.getId());
                    }

                    //项目数量
                    resp.put("projectNum", projectData.size());
                    resp.put("projectNumIds", JSONObject.toJSONString(validProjectIds));


                //审批中项目数
                List<Long> orgIds = iOrgApi.findChildrenByParentId(orgId).getData().stream().map(OrgVO::getId).collect(Collectors.toList());
                List<Integer> billStateList = new ArrayList<>();
                billStateList.add(BillStateEnum.APPROVING_HAS_STATE.getBillStateCode());
                billStateList.add(BillStateEnum.APPROVING_UNEXAM_STATE.getBillStateCode());
                List<Long> approveNum = finishWorkReportMapper.getApproveNum(orgIds,billStateList);
                resp.put("spzNum", approveNum.size());
                resp.put("spzNumIds", JSONObject.toJSONString(approveNum));

                //已完成审批项目数
                billStateList.clear();
                billStateList.add(BillStateEnum.COMMITED_STATE.getBillStateCode());
                billStateList.add(BillStateEnum.PASSED_STATE.getBillStateCode());
                List<Long> approveFinishNum = finishWorkReportMapper.getApproveNum(orgIds,billStateList);
                resp.put("ywcNum", approveFinishNum.size());
                resp.put("ywcNumIds", JSONObject.toJSONString(approveFinishNum));

                //获取报送滞后数量
                List<Long> getutyNumIds = finishWorkReportMapper.getDutyNum();
                resp.put("bszhNum", 0);
                if (CollectionUtils.isNotEmpty(projectData)){
                    List<ProjectPoolSetVO> filteredList = projectData.stream()
                            .filter(project -> project.getProjectDate() != null)
                            .filter(project -> {
                                LocalDate projectDate = project.getProjectDate().toInstant()
                                        .atZone(ZoneId.systemDefault())
                                        .toLocalDate();
                                return projectDate.plusDays(30).isBefore(LocalDate.now());
                            })
                            .collect(Collectors.toList());
                    if (CollectionUtils.isNotEmpty(filteredList)){
                        List<ProjectPoolSetVO> projectPoolSetVOS = filteredList.stream().filter(s -> !getutyNumIds.contains(s.getId())).collect(Collectors.toList());
                        resp.put("bszhNum", projectPoolSetVOS.size());
                    }


                }


//                Integer bszhNum = finishWorkReportMapper.getBszhNum(orgIds);

//                resp.put("bszhNum", bszhNum);

                //获取审批滞后的数量
                Integer spzhNum = finishWorkReportMapper.getSpzhNum(orgIds);
                resp.put("spzhNum", spzhNum);

                return CommonResponse.success("查询成功！", resp);
            }
//        }

        resp.put("projectNum", 0);
        resp.put("spzNum", 0);
        resp.put("ywcNum", 0);
        resp.put("bszhNum", 0);
        resp.put("spzhNum", 0);
        return CommonResponse.success("查询成功！", resp);
    }

    /**
     * 产值-回款（指标数据）
     * @param params
     * @return
     */
    @PostMapping(value = "getProjectProductData")
    @ResponseBody
    public CommonResponse<JSONObject> getProjectProductData(@RequestBody JSONObject params) {
        JSONObject resp = new JSONObject();
        Long orgId = InvocationInfoProxy.getOrgId();
        if(params.containsKey("orgId")) {
            orgId = params.getLong("orgId");
        }

            //查询所有项目
//        QueryParam prjQuery = new QueryParam();
//        CommonResponse<JSONArray> prjResp= projectPoolApi.queryArray(prjQuery);
//        if(!prjResp.isSuccess()) {
//            return CommonResponse.error("查询项目信息失败！");
//        }
//        JSONArray projectJsonArr = prjResp.getData();
//        logger.info("*********存在开工报告的 在施项目数：{}", projectJsonArr.size());
//        if(projectJsonArr.size() != 0) {
//            List<Long> validProjectIds = new ArrayList<>();
//            JSONObject tmp = null;
//            for(Object o : projectJsonArr) {
//                tmp = JSONObject.parseObject(JSONObject.toJSONString(o));
//                validProjectIds.add(tmp.getLong("id"));
//            }
//
//            //项目数量
//            resp.put("projectNum", validProjectIds.size());
//            resp.put("projectNumIds", JSONObject.toJSONString(validProjectIds));

            //查询所有项目
            QueryParam prjQuery = new QueryParam();
//        CommonResponse<JSONArray> prjResp= projectPoolApi.queryArray(prjQuery);
            CommonResponse<List<ProjectPoolSetVO>> prjResp = projectPoolApi.queryProjectList(prjQuery);
            if(!prjResp.isSuccess()) {
                return CommonResponse.error("查询项目信息失败！");
            }
            List<ProjectPoolSetVO> projectData = prjResp.getData();
            logger.info("*********存在开工报告的 在施项目数：{}", projectData.size());
            if(projectData.size() != 0) {
                List<Long> validProjectIds = new ArrayList<>();
                for(ProjectPoolSetVO o : projectData) {
                    validProjectIds.add(o.getId());
                }

                //项目数量
            resp.put("projectNum", projectData.size());
            resp.put("projectNumIds", JSONObject.toJSONString(validProjectIds));
            List<Long> orgIds = iOrgApi.findChildrenByParentId(orgId).getData().stream().map(OrgVO::getId).collect(Collectors.toList());

            //合同金额
            BigDecimal contractTaxMny = finishWorkReportMapper.getContractTaxMny(orgIds);
            resp.put("contractTaxMny", contractTaxMny);

            //预计结算金额
                BigDecimal preSettleMny = projectData.stream().filter(s ->s.getPreSettleMny() != null).map(ProjectPoolSetVO::getPreSettleMny)
                        .reduce(BigDecimal.ZERO, BigDecimal::add);
//            BigDecimal preSettleMny = finishWorkReportMapper.getPreSettleMny(orgIds);

            resp.put("preSettleMny", ComputeUtil.safeDiv(preSettleMny,new BigDecimal(10000)));

            //当年完成产值
            BigDecimal currentYearMny = finishWorkReportMapper.getCurrentYearMny(orgIds);
            resp.put("currentYearMny", currentYearMny);

            //开工累计完成产值
            BigDecimal allMny = finishWorkReportMapper.getAllMny(orgIds);
            resp.put("allMny", allMny);
            //业主累计审批产值
            BigDecimal allApproveMny = finishWorkReportMapper.getAllApproveMny(orgIds);
            resp.put("allApproveMny", allApproveMny);
            //按合同应回款金额
            BigDecimal receivableMny = finishWorkReportMapper.getReceivableMny(orgIds);
            resp.put("receivableMny", receivableMny);
            //已回款金额
            BigDecimal amountsReceivedMny = finishWorkReportMapper.getAmountsReceivedMny(orgIds);
            resp.put("amountsReceivedMny", amountsReceivedMny);
            //业主欠付金额
            resp.put("backPayMny",  ComputeUtil.safeSub(receivableMny,amountsReceivedMny));

            List<Integer> billStateList = new ArrayList<>();
            billStateList.add(BillStateEnum.APPROVING_HAS_STATE.getBillStateCode());
            billStateList.add(BillStateEnum.APPROVING_UNEXAM_STATE.getBillStateCode());
            List<Long> approveNum = finishWorkReportMapper.getApproveNum(orgIds,billStateList);
            resp.put("spzNum", approveNum.size());

            //已完成审批项目数
            billStateList.clear();
            billStateList.add(BillStateEnum.COMMITED_STATE.getBillStateCode());
            billStateList.add(BillStateEnum.PASSED_STATE.getBillStateCode());
            List<Long> approveFinishNum = finishWorkReportMapper.getApproveNum(orgIds,billStateList);
            resp.put("ywcNum", approveFinishNum.size());

            //获取报送滞后数量
            List<Long> getutyNumIds = finishWorkReportMapper.getDutyNum();
                resp.put("bszhNum", 0);
            if (CollectionUtils.isNotEmpty(projectData)){
                List<ProjectPoolSetVO> filteredList = projectData.stream()
                        .filter(project -> project.getProjectDate() != null)
                        .filter(project -> {
                            LocalDate projectDate = project.getProjectDate().toInstant()
                                    .atZone(ZoneId.systemDefault())
                                    .toLocalDate();
                            return projectDate.plusDays(30).isBefore(LocalDate.now());
                        })
                        .collect(Collectors.toList());
                if (CollectionUtils.isNotEmpty(filteredList)){
                    List<ProjectPoolSetVO> projectPoolSetVOS = filteredList.stream().filter(s -> !getutyNumIds.contains(s.getId())).collect(Collectors.toList());
                    resp.put("bszhNum", projectPoolSetVOS.size());
                }


            }
//            Integer bszhNum = finishWorkReportMapper.getBszhNum(orgIds);




            //获取审批滞后的数量
            Integer spzhNum = finishWorkReportMapper.getSpzhNum(orgIds);
            resp.put("spzhNum", spzhNum);

            return CommonResponse.success("查询成功！", resp);
        }
//        }

        resp.put("projectNum", 0);
        resp.put("contractTaxMny", 0);
        resp.put("preSettleMny", 0);
        resp.put("currentYearMny", 0);
        resp.put("allMny", 0);
        resp.put("allApproveMny",0);
        resp.put("receivableMny",0);
        resp.put("amountsReceivedMny",0);
        resp.put("backPayMny",0);
        resp.put("spzNum",0);
        resp.put("ywcNum",0);
        resp.put("bszhNum",0);
        resp.put("spzhNum",0);
        return CommonResponse.success("查询成功！", resp);
    }
    /**
     * 上游签证（指标数据）
     * @param params
     * @return
     */
    @PostMapping(value = "getVisaData")
    @ResponseBody
    public CommonResponse<JSONObject> getVisaData(@RequestBody JSONObject params) {
        JSONObject resp = new JSONObject();
        Long orgId = InvocationInfoProxy.getOrgId();
        if(params.containsKey("orgId")) {
            orgId = params.getLong("orgId");
        }

        //查询所有项目
        QueryParam prjQuery = new QueryParam();
//        CommonResponse<JSONArray> prjResp= projectPoolApi.queryArray(prjQuery);
        Long projectId = null;
        if(params.containsKey("projectId")){
            //如果传递了项目id,则查询对应项目id下的数据
            projectId = params.getLong("projectId");
            prjQuery.getParams().put("projectId",new Parameter(QueryParam.EQ, projectId));
        }
        CommonResponse<List<ProjectPoolSetVO>> prjResp = projectPoolApi.queryProjectList(prjQuery);
        if(!prjResp.isSuccess()) {
            return CommonResponse.error("查询项目信息失败！");
        }
        List<ProjectPoolSetVO> projectData = prjResp.getData();
        logger.info("*********存在开工报告的 在施项目数：{}", projectData.size());
        if(projectData.size() != 0) {
            List<Long> validProjectIds = new ArrayList<>();
            for(ProjectPoolSetVO o : projectData) {
                validProjectIds.add(o.getId());
            }

            //项目数量
            resp.put("projectNum", projectData.size());
            resp.put("projectNumIds", JSONObject.toJSONString(validProjectIds));
            List<Long> orgIds = iOrgApi.findChildrenByParentId(orgId).getData().stream().map(OrgVO::getId).collect(Collectors.toList());

            //报送率
            //获取发包方签证索赔办理生效的单据数量
            BigDecimal claimNum = finishWorkReportMapper.getClaimNum(orgIds,null,projectId);
//          获取发包方签证索赔记录单的已生效单据数量
            BigDecimal claimRecords = finishWorkReportMapper.getClaimRecords(orgIds);
            resp.put("bsRate", CommonUtils.calculateRate(claimNum,claimRecords));

            //确权率
//          发包方签证索赔办理生效的单据中 “甲方批复状态-已批复”单据数量/ 已生效发包方签证索赔办理生效的单据数量
            BigDecimal claimApproveNum = finishWorkReportMapper.getClaimNum(orgIds,1,projectId);
            resp.put("qqRate", CommonUtils.calculateRate(claimApproveNum,claimNum));
            //确权金额
            BigDecimal claimMny = finishWorkReportMapper.getClaimMny(orgIds);
            resp.put("claimMny", claimMny);

            //合同增幅率
//            确权金额/所有已经生效的施工合同合同金额
            BigDecimal contractTaxMny = finishWorkReportMapper.getContractTaxMny(orgIds);
            resp.put("htzfRate", CommonUtils.calculateRate(claimMny,ComputeUtil.safeMultiply(contractTaxMny,new BigDecimal(10000))));

            return CommonResponse.success("查询成功！", resp);
    }

        resp.put("projectNum", 0);
        resp.put("bsRate", 0);
        resp.put("qqRate", 0);
        resp.put("claimMny", 0);
        resp.put("htzfRate", 0);
        return CommonResponse.success("查询成功！", resp);
    }


    /**
     * 项目情况
     * @param params
     * @return
     */
    @PostMapping(value = "getProjectData")
    @ResponseBody
    public CommonResponse<JSONObject> getProjectData(@RequestBody JSONObject params) {
        JSONObject resp = new JSONObject();
        Long orgId = InvocationInfoProxy.getOrgId();
        if(params.containsKey("orgId")) {
            orgId = params.getLong("orgId");
        }

        //查询所有项目
        QueryParam prjQuery = new QueryParam();
//        CommonResponse<JSONArray> prjResp= projectPoolApi.queryArray(prjQuery);
        CommonResponse<List<ProjectPoolSetVO>> prjResp = projectPoolApi.queryProjectList(prjQuery);
        if(!prjResp.isSuccess()) {
            return CommonResponse.error("查询项目信息失败！");
        }
        List<ProjectPoolSetVO> projectData = prjResp.getData();
        logger.info("*********存在开工报告的 在施项目数：{}", projectData.size());
        if(projectData.size() != 0) {
            List<Long> validProjectIds = new ArrayList<>();
            for(ProjectPoolSetVO o : projectData) {
                validProjectIds.add(o.getId());
            }

            //在建数量
            List<ProjectPoolSetVO> zjList = projectData.stream().filter(s -> "2".equals(s.getBusinessStatus())).collect(Collectors.toList());
            List<Long> zjListIds = zjList.stream().map(ProjectPoolSetVO::getId).collect(Collectors.toList());
            resp.put("zjNum", zjList.size());
            resp.put("zjNumIds", JSONObject.toJSONString(zjListIds));
            //停缓建项目
            List<ProjectPoolSetVO> thjList = projectData.stream().filter(s -> "3".equals(s.getBusinessStatus())).collect(Collectors.toList());
            List<Long> thjListIds = thjList.stream().map(ProjectPoolSetVO::getId).collect(Collectors.toList());
            resp.put("thjNum", thjList.size());
            resp.put( "thjNumIds", JSONObject.toJSONString(thjListIds));
            //退场项目
            List<ProjectPoolSetVO> tcList = projectData.stream().filter(s -> "4".equals(s.getBusinessStatus())).collect(Collectors.toList());
            List<Long> tcListIds = tcList.stream().map(ProjectPoolSetVO::getId).collect(Collectors.toList());
            resp.put("tcNum", tcList.size());
            resp.put( "tcNumIds", JSONObject.toJSONString(tcListIds));

            LambdaQueryWrapper<FinishWorkReportEntity> finishWrapper = new LambdaQueryWrapper<>();
            finishWrapper.in(FinishWorkReportEntity::getBillState,1,3);
            List<FinishWorkReportEntity> finishWorkReportEntities = finishWorkReportService.list(finishWrapper);
            //完工项目主键
            List<Long> wgProjectIds = finishWorkReportEntities.stream().map(FinishWorkReportEntity::getProjectId).collect(Collectors.toList());


            //已完已竣验项目
            LambdaQueryWrapper<CompletionWorkReportEntity> completionWrapper = new LambdaQueryWrapper<>();
            completionWrapper.in(CompletionWorkReportEntity::getBillState,1,3);
            completionWrapper.eq(CompletionWorkReportEntity::isCompletionAcceptanceFlag, true);
            List<CompletionWorkReportEntity> completionEntities = completionWorkReportService.list(completionWrapper);
            List<CompletionWorkReportEntity> ywyjList = completionEntities.stream().filter(s -> wgProjectIds.contains(s.getProjectId())).collect(Collectors.toList());
            List<Long> ywyjListIds = ywyjList.stream().map(CompletionWorkReportEntity::getId).collect(Collectors.toList());
            resp.put("ywyjNum", ywyjList.size());
//            resp.put("ywyjNumIds", JSONObject.toJSONString(ywyjListIds));
            List<Long> completionProjectIds = completionEntities.stream().map(CompletionWorkReportEntity::getProjectId).collect(Collectors.toList());
            List<FinishWorkReportEntity> finishWorkReportEntityList = finishWorkReportEntities.stream().filter(s -> !completionProjectIds.contains(s.getProjectId())).collect(Collectors.toList());
            //已完工未竣验项目
            //完工
            resp.put("ywwjNum", finishWorkReportEntityList.size());
//            resp.put( "ywwjNumIds", JSONObject.toJSONString(finishWorkReportEntityList));



            return CommonResponse.success("查询成功！", resp);
    }

        resp.put("zjNum", 0);
        resp.put("thjNum", 0);
        resp.put("tcNum", 0);
        resp.put("ywyjNum", 0);
        resp.put("ywwjNum", 0);
        return CommonResponse.success("查询成功！", resp);
    }
    /**
     * 项目施工图预算完成情况
     * @param params
     * @return
     */
    @PostMapping(value = "getBudgetData")
    @ResponseBody
    public CommonResponse<JSONObject> getBudgetData(@RequestBody JSONObject params) {
        JSONObject resp = new JSONObject();
        Long orgId = InvocationInfoProxy.getOrgId();
        if(params.containsKey("orgId")) {
            orgId = params.getLong("orgId");
        }

        //查询所有项目
        QueryParam prjQuery = new QueryParam();
//        CommonResponse<JSONArray> prjResp= projectPoolApi.queryArray(prjQuery);
        CommonResponse<List<ProjectPoolSetVO>> prjResp = projectPoolApi.queryProjectList(prjQuery);
        if(!prjResp.isSuccess()) {
            return CommonResponse.error("查询项目信息失败！");
        }
        List<ProjectPoolSetVO> projectData = prjResp.getData();
        logger.info("*********存在开工报告的 在施项目数：{}", projectData.size());
        if(projectData.size() != 0) {
            List<Long> validProjectIds = new ArrayList<>();
            for(ProjectPoolSetVO o : projectData) {
                validProjectIds.add(o.getId());
            }
            //项目数量
            resp.put("projectNum", projectData.size());
            resp.put("projectNumIds", JSONObject.toJSONString(validProjectIds));
            List<Long> orgIds = iOrgApi.findChildrenByParentId(orgId).getData().stream().map(OrgVO::getId).collect(Collectors.toList());
            //审批中项目
            //项目预算书审批中项目,多个算一个
            List<Integer> billStateList = new ArrayList<>();
            billStateList.add(BillStateEnum.APPROVING_HAS_STATE.getBillStateCode());
            billStateList.add(BillStateEnum.APPROVING_UNEXAM_STATE.getBillStateCode());
            List<Long> budgetApproveNum = finishWorkReportMapper.getBudgetApproveNum(orgIds,billStateList);
            List<Long> budgetApproveProjectNum = finishWorkReportMapper.getBudgetProjectNum(orgIds,billStateList);
            resp.put("budgetApproveNum", budgetApproveProjectNum.size());
            resp.put("budgetApproveNumIds", JSONObject.toJSONString(budgetApproveNum));
            //已完成审批项目
            //项目预算书已完成审批项目,多个算一个
            billStateList.clear();
            billStateList.add(BillStateEnum.COMMITED_STATE.getBillStateCode());
            billStateList.add(BillStateEnum.PASSED_STATE.getBillStateCode());
            List<Long> budgetFinishNum = finishWorkReportMapper.getBudgetApproveNum(orgIds,billStateList);
            List<Long> budgetApproveProjectFinishNum = finishWorkReportMapper.getBudgetProjectNum(orgIds,billStateList);
            resp.put("budgetFinishNum", budgetApproveProjectFinishNum.size());
            resp.put("budgetFinishNumIds", JSONObject.toJSONString(budgetFinishNum));
            //滞后项目
            Integer budgetBszhNum = finishWorkReportMapper.getBudgetBszhNum(orgIds);
            resp.put("budgetBszhNum", budgetBszhNum);
            //审批滞后
            Integer budgetSpzhNum = finishWorkReportMapper.getBudgetSpzhNum(orgIds);
            resp.put("budgetSpzhNum", budgetSpzhNum);

            return CommonResponse.success("查询成功！", resp);
    }

        resp.put("zjNum", 0);
        resp.put("thjNum", 0);
        resp.put("tcNum", 0);
        resp.put("ywyjNum", 0);
        resp.put("ywwjNum", 0);
        return CommonResponse.success("查询成功！", resp);
    }

}
