package com.ejianc.business.market.controller.api;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.market.bean.CompletionWorkReportEntity;
import com.ejianc.business.market.bean.FinishWorkReportEntity;
import com.ejianc.business.market.enums.*;
import com.ejianc.business.market.service.ICompletionWorkReportService;
import com.ejianc.business.market.service.IFinishWorkReportService;
import com.ejianc.business.market.vo.CompletionWorkReportVO;
import com.ejianc.business.market.vo.WorkReportQueryVO;
import com.ejianc.foundation.share.api.IProjectSetApi;
import com.ejianc.foundation.share.vo.ProjectPoolSetVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.time.DateUtil;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.Arrays;
import java.util.Date;
import java.util.List;

/***
 * @description: 报告api
 * @author songlx
 * @date: 2022/6/10
 */
@RestController
@RequestMapping
public class WorkReportApi {

    @Autowired
    private ICompletionWorkReportService completionWorkReportService;

    @Autowired
    private IProjectSetApi projectSetApi;

    @Autowired
    private IFinishWorkReportService finishWorkReportService;

    /**
     * @description: 查询竣工报告
     * @return:
     * @author songlx
     * @date: 2022/6/10
     */
    @PostMapping(value = "/api/workReport/queryCompletionWorkReports")
    CommonResponse<List<CompletionWorkReportVO>> queryCompletionWorkReports(@RequestBody WorkReportQueryVO workReportQueryVO) {
        QueryWrapper<CompletionWorkReportEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.in(CollectionUtils.isNotEmpty(workReportQueryVO.getOrgIds()), "org_id", workReportQueryVO.getOrgIds());
        queryWrapper.in(CollectionUtils.isNotEmpty(workReportQueryVO.getProjectIds()), "project_id", workReportQueryVO.getProjectIds());
        queryWrapper.in("bill_state", Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()));
        List<CompletionWorkReportEntity> list = completionWorkReportService.list(queryWrapper);
        List<CompletionWorkReportVO> completionWorkReportVOS = BeanMapper.mapList(list, CompletionWorkReportVO.class);
        return CommonResponse.success(completionWorkReportVOS);
    }

    /**
     * 查询项目状态信息及距离成本关门倒计时统计
     *
     * @param projectId
     * @return
     */
    @GetMapping(value = "/api/workReport/getProjectInfo")
    CommonResponse<JSONObject> getProjectInfo(@RequestParam Long projectId) {
        CommonResponse<ProjectPoolSetVO> projectPoolSetResp = projectSetApi.getProjectId(projectId);
        if(!projectPoolSetResp.isSuccess()) {
            return CommonResponse.error("获取项目信息失败！");
        }
        ProjectPoolSetVO projectPoolVo = projectPoolSetResp.getData();
        JSONObject respData = JSONObject.parseObject(JSONObject.toJSONString(projectPoolVo));
        respData.put("projectStatusName", ProjectStatusEnum.getNameByCode(projectPoolVo.getProjectStatus()));
        respData.put("businessStatusName", BusinessStatusEnum.getNameByCode(projectPoolVo.getBusinessStatus()));
        respData.put("settleStatusName", SettleStatusEnum.getNameByCode(projectPoolVo.getSettleStatus()));
        respData.put("archiveStatusName", ArchiveStatusEnum.getNameByCode(projectPoolVo.getArchiveStatus()));
        respData.put("capitalStatusName", CapitalStatusEnum.getNameByCode(projectPoolVo.getCapitalStatus()));
        respData.put("daysBeforeCostClose", -999999); //默认无成本关门倒计时

        //如果项目的资金管控状态不是成本关门也不是已销账，有生效的完工报告单时，则统计成本关门倒计时天数
        if(!CapitalStatusEnum.已销账.getCode().equals(projectPoolVo.getCapitalStatus()) &&
                !CapitalStatusEnum.成本关门.getCode().equals(projectPoolVo.getCapitalStatus())) {
            QueryWrapper<FinishWorkReportEntity> finishReportQuery = new QueryWrapper<>();
            finishReportQuery.eq("project_id", projectId);
            finishReportQuery.in("bill_state", new Integer[]{
                    BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()
            });

            FinishWorkReportEntity finishWorkReport = finishWorkReportService.getOne(finishReportQuery);
            if(null != finishWorkReport) {
                respData.put("daysBeforeCostClose", DateUtil.daysBetween(new Date(), DateUtils.addDays(finishWorkReport.getRealityFinishWorkDate(), 90)));
            }
        }

        return CommonResponse.success(respData);
    }


}
