/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.market.service.impl;

import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.market.bean.CloseCostEntity;
import com.ejianc.business.market.enums.CapitalStatusEnum;
import com.ejianc.business.market.mapper.CloseCostMapper;
import com.ejianc.business.market.service.ICloseCostService;
import com.ejianc.business.market.service.IFinishWorkReportService;
import com.ejianc.foundation.share.api.IProjectPoolApi;
import com.ejianc.foundation.share.api.IProjectSetApi;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.google.common.base.Stopwatch;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Service(value="closeCostService")
public class CloseCostServiceImpl
extends BaseServiceImpl<CloseCostMapper, CloseCostEntity>
implements ICloseCostService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final IProjectPoolApi projectPoolApi;
    private final IProjectSetApi projectSetApi;
    private final IFinishWorkReportService finishWorkReportService;
    @Value(value="${common.env.base-host}")
    private String BaseHost;

    public CloseCostServiceImpl(IProjectPoolApi projectPoolApi, IProjectSetApi projectSetApi, IFinishWorkReportService finishWorkReportService) {
        this.projectPoolApi = projectPoolApi;
        this.projectSetApi = projectSetApi;
        this.finishWorkReportService = finishWorkReportService;
    }

    @Override
    public void autoCloseCost() {
        HttpServletRequest request = ((ServletRequestAttributes)Objects.requireNonNull(RequestContextHolder.getRequestAttributes())).getRequest();
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("authority", request.getHeader("authority"));
        headers.put("ejc-token", request.getHeader("ejc-token"));
        ExecutorService executorService = Executors.newFixedThreadPool(1);
        CompletableFuture.runAsync(() -> {
            Stopwatch stopwatch = Stopwatch.createStarted();
            QueryParam param = new QueryParam();
            param.setPageIndex(1);
            param.setPageSize(-1);
            param.getParams().put("capitalStatus", new Parameter("ne", (Object)CapitalStatusEnum.\u6210\u672c\u5173\u95e8.getCode()));
            String body = ((HttpRequest)HttpRequest.post((String)(this.BaseHost + "ejc-share-web/api/projectPool/queryProjectIPage")).addHeaders((Map)headers)).body(JSON.toJSONString((Object)param)).timeout(60000).execute().body();
            JSONObject jsonObject = (JSONObject)JSON.parseObject((String)body, JSONObject.class);
            JSONObject data = (JSONObject)jsonObject.get((Object)"data");
            JSONArray records = (JSONArray)data.get((Object)"records");
            this.logger.info("\u67e5\u8be2\u9879\u76ee\u6c60\u7528\u65f6\u300c{}\u300d\u79d2", (Object)stopwatch.stop().elapsed(TimeUnit.SECONDS));
            stopwatch.reset().start();
            if (CollectionUtils.isNotEmpty((Collection)records)) {
                ArrayList<Long> projectIds = new ArrayList<Long>();
                for (Object record : records) {
                    JSONObject json = (JSONObject)record;
                    projectIds.add(Long.parseLong(String.valueOf(json.get((Object)"id"))));
                }
                List<Long> ids = this.finishWorkReportService.queryCanCloseCostProjectIds(projectIds);
                if (CollectionUtils.isNotEmpty(ids)) {
                    this.logger.info("ids\uff1a{}", ids);
                    for (Long projectId : ids) {
                        HashMap<String, Object> paramMaps = new HashMap<String, Object>();
                        paramMaps.put("projectId", projectId);
                        paramMaps.put("capitalStatus", CapitalStatusEnum.\u6210\u672c\u5173\u95e8.getCode());
                        String responseBody = ((HttpRequest)HttpUtil.createGet((String)(this.BaseHost + "ejc-share-web/api/projectPoolSetApi/changeProjectStatus")).addHeaders((Map)headers)).form(paramMaps).execute().body();
                        CommonResponse res = (CommonResponse)JSON.parseObject((String)responseBody, CommonResponse.class);
                        if (res.isSuccess()) continue;
                        this.logger.info("\u81ea\u52a8\u6210\u672c\u5173\u95e8\u66f4\u65b0\u3010\u9879\u76ee\u6c60\u3011\u9879\u76ee\u3010{}\u3011\u8d44\u91d1\u7ba1\u63a7\u72b6\u6001\u4e3a\u3010{}\u3011\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a{}", new Object[]{projectId, CapitalStatusEnum.\u6210\u672c\u5173\u95e8, res.getMsg()});
                    }
                }
            }
            this.logger.info("\u81ea\u52a8\u5173\u95e8\u5904\u7406\u5b8c\u6210\u5171\u7528\u65f6\u300c{}\u300d\u79d2", (Object)stopwatch.stop().elapsed(TimeUnit.SECONDS));
        }, executorService);
        executorService.shutdown();
    }
}

