/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.market.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.constructor.api.IAnnualOperatingIndicatorsApi;
import com.ejianc.business.contractbase.pool.contractpool.api.IContractPoolApi;
import com.ejianc.business.market.service.ProjectSurveyService;
import com.ejianc.business.market.vo.ProjectCountVO;
import com.ejianc.business.market.vo.ProjectDataVO;
import com.ejianc.business.market.vo.ProjectVo;
import com.ejianc.business.market.vo.consts.ProjectSurveyEnum;
import com.ejianc.business.market.vo.util.AddressResolutionUtil;
import com.ejianc.business.market.vo.util.EJCDateUtil;
import com.ejianc.business.profinance.api.IReceiptAndPaymentRegisterApi;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.share.api.IProjectPoolApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service(value="projectSurveyService")
public class ProjectSurveyServiceImpl
implements ProjectSurveyService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IContractPoolApi iContractPoolApi;
    @Autowired
    private IAnnualOperatingIndicatorsApi indicatorsApi;
    @Autowired
    private IProjectPoolApi projectSetApi;
    @Autowired
    private IReceiptAndPaymentRegisterApi receiptAndPaymentRegisterApi;
    @Value(value="${pro.param.currentProvince}")
    private String currentProvince;
    @Value(value="${pro.param.province}")
    private String BASE_PROVINCE;

    /*
     * WARNING - void declaration
     */
    @Override
    public CommonResponse<JSONObject> projectCount(String range, String name, String dateIn, Long orgId) {
        void var18_48;
        void var17_31;
        QueryParam queryParam;
        ProjectVo projectVo;
        ArrayList<ProjectVo> projectVos;
        List<ProjectCountVO> projectCountVOS;
        Map<String, List<ProjectCountVO>> map;
        ProjectDataVO projectDataVO;
        ProjectDataVO pvo;
        BigDecimal contractTaxMny;
        String projectStatus = null;
        if (ProjectSurveyEnum.RANGE_BUILDING.getCode().equals(range)) {
            projectStatus = "1";
        }
        if (ProjectSurveyEnum.THISYEAR.getCode().equals(dateIn)) {
            dateIn = EJCDateUtil.getYear() + "";
        }
        ArrayList<ProjectCountVO> list = new ArrayList<ProjectCountVO>();
        CommonResponse listCommonResponse = this.projectSetApi.queryProjectList(projectStatus, dateIn, orgId, this.currentProvince);
        if (listCommonResponse.isSuccess()) {
            List data = (List)listCommonResponse.getData();
            List projectCountVOS2 = BeanMapper.mapList((Iterable)data, ProjectCountVO.class);
            list.addAll(projectCountVOS2);
        }
        ArrayList<Long> ids = new ArrayList<Long>();
        HashSet<Object> provinceSet = new HashSet<Object>();
        HashSet<String> citySet = new HashSet<String>();
        HashSet<String> countySet = new HashSet<String>();
        String pname = null;
        for (ProjectCountVO vo : list) {
            ids.add(vo.getId());
            if (StringUtils.isNotEmpty((CharSequence)vo.getArea())) {
                if (vo.getArea().equals("\u53f0\u6e7e\u7701")) {
                    vo.setProvince("\u53f0\u6e7e\u7701");
                    vo.setCity("\u53f0\u6e7e\u7701");
                    vo.setCounty("\u53f0\u6e7e\u7701");
                    provinceSet.add("\u53f0\u6e7e\u7701");
                    citySet.add("\u53f0\u6e7e\u7701");
                    countySet.add("\u53f0\u6e7e\u7701");
                    continue;
                }
                Map<String, String> areaMmap = AddressResolutionUtil.addressResolution(vo.getArea());
                if (areaMmap != null) {
                    String province = areaMmap.get("province") == null ? "\u5176\u4ed6" : areaMmap.get("province");
                    String string = areaMmap.get("city") == null ? "\u5176\u4ed6" : areaMmap.get("city");
                    String string2 = areaMmap.get("county") == null ? "\u5176\u4ed6" : areaMmap.get("county");
                    vo.setProvince(province);
                    vo.setCity(string);
                    vo.setCounty(string2);
                    provinceSet.add(province);
                    citySet.add(string);
                    countySet.add(string2);
                    if (!StringUtils.isNotBlank((CharSequence)name) || !string.equals(name)) continue;
                    pname = province;
                    continue;
                }
                vo.setProvince("\u5176\u4ed6");
                vo.setCity("\u5176\u4ed6");
                vo.setCounty("\u5176\u4ed6");
                provinceSet.add("\u5176\u4ed6");
                citySet.add("\u5176\u4ed6");
                countySet.add("\u5176\u4ed6");
                continue;
            }
            vo.setProvince("\u5176\u4ed6");
            vo.setCity("\u5176\u4ed6");
            vo.setCounty("\u5176\u4ed6");
            provinceSet.add("\u5176\u4ed6");
            citySet.add("\u5176\u4ed6");
            countySet.add("\u5176\u4ed6");
        }
        String rangeType = null;
        List<Object> dataVOS = new ArrayList();
        if (StringUtils.isNotBlank((CharSequence)name)) {
            if (provinceSet.contains(name)) {
                rangeType = AddressResolutionUtil.getProvincePinYin(name);
                dataVOS = this.projectCountByName(name, list, 0);
            } else if (citySet.contains(name)) {
                rangeType = AddressResolutionUtil.getProvincePinYin(pname) + "-" + AddressResolutionUtil.getNamePinYinChar(name, 1);
                dataVOS = this.projectCountByName(name, list, 1);
            }
        } else if (provinceSet.size() == 1) {
            if (citySet.size() == 1) {
                rangeType = AddressResolutionUtil.getProvincePinYin((String)provinceSet.iterator().next()) + "-" + AddressResolutionUtil.getNamePinYinChar((String)citySet.iterator().next(), 1);
                HashMap<String, ProjectDataVO> countyMap = new HashMap<String, ProjectDataVO>();
                for (ProjectCountVO projectCountVO : list) {
                    String string = projectCountVO.getCounty();
                    BigDecimal bigDecimal = contractTaxMny = projectCountVO.getContractTaxMny() == null ? BigDecimal.ZERO : projectCountVO.getContractTaxMny();
                    if (!countyMap.containsKey(string)) {
                        pvo = new ProjectDataVO();
                        pvo.setName(string);
                        pvo.setValue(1);
                        pvo.setContractMoney(contractTaxMny);
                        countyMap.put(string, pvo);
                        continue;
                    }
                    projectDataVO = (ProjectDataVO)countyMap.get(string);
                    projectDataVO.setValue(projectDataVO.getValue() + 1);
                    projectDataVO.setContractMoney(projectDataVO.getContractMoney().add(contractTaxMny));
                    countyMap.put(string, projectDataVO);
                }
                dataVOS = new ArrayList(countyMap.values());
                map = list.stream().collect(Collectors.groupingBy(ProjectCountVO::getCounty));
                for (ProjectDataVO projectDataVO2 : dataVOS) {
                    if (!map.containsKey(projectDataVO2.getName())) continue;
                    projectCountVOS = map.get(projectDataVO2.getName());
                    projectVos = new ArrayList();
                    for (ProjectCountVO projectCountVO : projectCountVOS) {
                        projectVo = new ProjectVo();
                        projectVo.setId(projectCountVO.getId());
                        projectVo.setName(projectCountVO.getProjectName());
                        projectVo.setOrgId(projectCountVO.getOrgId());
                        projectVo.setProjectDepartmentId(projectCountVO.getProjectDepartmentId());
                        projectVos.add(projectVo);
                    }
                    projectDataVO2.setProjectList(projectVos);
                }
            } else {
                rangeType = AddressResolutionUtil.getProvincePinYin((String)provinceSet.iterator().next());
                HashMap<String, ProjectDataVO> cityMap = new HashMap<String, ProjectDataVO>();
                for (ProjectCountVO projectCountVO : list) {
                    String string = projectCountVO.getCity();
                    BigDecimal bigDecimal = contractTaxMny = projectCountVO.getContractTaxMny() == null ? BigDecimal.ZERO : projectCountVO.getContractTaxMny();
                    if (!cityMap.containsKey(string)) {
                        pvo = new ProjectDataVO();
                        pvo.setName(string);
                        pvo.setValue(1);
                        pvo.setContractMoney(contractTaxMny);
                        cityMap.put(string, pvo);
                        continue;
                    }
                    projectDataVO = (ProjectDataVO)cityMap.get(string);
                    projectDataVO.setValue(projectDataVO.getValue() + 1);
                    projectDataVO.setContractMoney(projectDataVO.getContractMoney().add(contractTaxMny));
                    cityMap.put(string, projectDataVO);
                }
                dataVOS = new ArrayList(cityMap.values());
                map = list.stream().collect(Collectors.groupingBy(ProjectCountVO::getCity));
                for (ProjectDataVO projectDataVO3 : dataVOS) {
                    if (!map.containsKey(projectDataVO3.getName())) continue;
                    projectCountVOS = map.get(projectDataVO3.getName());
                    projectVos = new ArrayList();
                    for (ProjectCountVO projectCountVO : projectCountVOS) {
                        projectVo = new ProjectVo();
                        projectVo.setId(projectCountVO.getId());
                        projectVo.setName(projectCountVO.getProjectName());
                        projectVo.setOrgId(projectCountVO.getOrgId());
                        projectVo.setProjectDepartmentId(projectCountVO.getProjectDepartmentId());
                        projectVos.add(projectVo);
                    }
                    projectDataVO3.setProjectList(projectVos);
                }
            }
        } else {
            rangeType = "China";
            HashMap<String, ProjectDataVO> provinceMap = new HashMap<String, ProjectDataVO>();
            for (ProjectCountVO projectCountVO : list) {
                String string = projectCountVO.getProvince();
                BigDecimal bigDecimal = contractTaxMny = projectCountVO.getContractTaxMny() == null ? BigDecimal.ZERO : projectCountVO.getContractTaxMny();
                if (!provinceMap.containsKey(string)) {
                    pvo = new ProjectDataVO();
                    pvo.setName(string);
                    pvo.setValue(1);
                    pvo.setContractMoney(contractTaxMny);
                    provinceMap.put(string, pvo);
                    continue;
                }
                projectDataVO = (ProjectDataVO)provinceMap.get(string);
                projectDataVO.setValue(projectDataVO.getValue() + 1);
                projectDataVO.setContractMoney(projectDataVO.getContractMoney().add(contractTaxMny));
                provinceMap.put(string, projectDataVO);
            }
            map = list.stream().collect(Collectors.groupingBy(ProjectCountVO::getProvince));
            dataVOS = new ArrayList(provinceMap.values());
            for (ProjectDataVO projectDataVO4 : dataVOS) {
                if (!map.containsKey(projectDataVO4.getName())) continue;
                projectCountVOS = map.get(projectDataVO4.getName());
                projectVos = new ArrayList<ProjectVo>();
                for (ProjectCountVO projectCountVO : projectCountVOS) {
                    projectVo = new ProjectVo();
                    projectVo.setId(projectCountVO.getId());
                    projectVo.setName(projectCountVO.getProjectName());
                    projectVo.setOrgId(projectCountVO.getOrgId());
                    projectVo.setProjectDepartmentId(projectCountVO.getProjectDepartmentId());
                    projectVos.add(projectVo);
                }
                projectDataVO4.setProjectList(projectVos);
            }
        }
        int allProjectNumber = list.size();
        BigDecimal allInMoney = BigDecimal.ZERO;
        BigDecimal bigDecimal = BigDecimal.ZERO;
        BigDecimal bigDecimal2 = BigDecimal.ZERO;
        BigDecimal allContractMoney = BigDecimal.ZERO;
        BigDecimal targetCompletionRate = BigDecimal.ZERO;
        List projectIds = list.stream().map(ProjectCountVO::getId).collect(Collectors.toList());
        if (dateIn != null) {
            CommonResponse contraction = this.iContractPoolApi.queryThisYearContractMny("contraction", dateIn, orgId);
            if (contraction.isSuccess() && contraction.getData() != null) {
                allContractMoney = (BigDecimal)contraction.getData();
            }
        } else {
            queryParam = new QueryParam();
            queryParam.getParams().put("sourceType", new Parameter("eq", (Object)"contraction"));
            queryParam.getParams().put("projectId", new Parameter("in", projectIds));
            CommonResponse bigDecimalCommonResponse = this.iContractPoolApi.queryContractMny(queryParam);
            if (bigDecimalCommonResponse.isSuccess()) {
                allContractMoney = (BigDecimal)bigDecimalCommonResponse.getData();
            }
        }
        if (CollectionUtils.isNotEmpty(projectIds)) {
            queryParam = new QueryParam();
            queryParam.getParams().put("billState", new Parameter("in", Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode())));
            queryParam.getParams().put("projectId", new Parameter("in", projectIds));
            CommonResponse receiptAndPaymentCommonResponse = this.receiptAndPaymentRegisterApi.queryReceiptAndPaymentMny(queryParam);
            if (receiptAndPaymentCommonResponse.isSuccess()) {
                JSONObject data = (JSONObject)receiptAndPaymentCommonResponse.getData();
                allInMoney = new BigDecimal(data.get((Object)"sumReceivedMny").toString());
                BigDecimal bigDecimal3 = new BigDecimal(data.get((Object)"payMny").toString());
            }
        }
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("allProjectNumber", (Object)allProjectNumber);
        jsonObject.put("allContractMoney", (Object)allContractMoney);
        jsonObject.put("allInMoney", (Object)allInMoney);
        jsonObject.put("allOutMoney", (Object)var17_31);
        this.logger.info("\u672c\u5e74\u65b0\u589e \u8bf7\u6c42\u90d1\u5dde\u4e00\u5efa\u7684\u63a5\u53e3\u83b7\u53d6 \u5e74\u5ea6\u76ee\u6807");
        if (io.micrometer.core.instrument.util.StringUtils.isNotEmpty((String)dateIn)) {
            this.logger.info("\u672c\u5e74\u65b0\u589e \u8bf7\u6c42\u90d1\u5dde\u4e00\u5efa\u7684\u63a5\u53e3\u83b7\u53d6 \u8fdb\u5165");
            Long _orgId = orgId != null ? orgId : InvocationInfoProxy.getOrgId();
            Integer year = EJCDateUtil.getYear();
            this.logger.info("\u672c\u5e74\u65b0\u589e \u8bf7\u6c42\u90d1\u5dde\u4e00\u5efa\u7684\u63a5\u53e3\u83b7\u53d6 \u8c03\u7528\u53c2\u6570orgId" + _orgId);
            this.logger.info("\u672c\u5e74\u65b0\u589e \u8bf7\u6c42\u90d1\u5dde\u4e00\u5efa\u7684\u63a5\u53e3\u83b7\u53d6 \u8c03\u7528\u53c2\u6570year" + year);
            CommonResponse commonResponse = this.indicatorsApi.getDetailByOrgId(_orgId, year);
            this.logger.info("\u672c\u5e74\u65b0\u589e \u8bf7\u6c42\u90d1\u5dde\u4e00\u5efa\u7684\u63a5\u53e3\u83b7\u53d6 \u8c03\u7528" + commonResponse.isSuccess());
            if (commonResponse.isSuccess()) {
                BigDecimal data = (BigDecimal)commonResponse.getData();
                this.logger.info("\u672c\u5e74\u65b0\u589e \u8bf7\u6c42\u90d1\u5dde\u4e00\u5efa\u7684\u63a5\u53e3\u83b7\u53d6 \u7ed3\u679c" + data);
                if (data != null) {
                    BigDecimal bigDecimal4 = ComputeUtil.safeMultiply((BigDecimal)data, (BigDecimal)new BigDecimal(10000));
                    targetCompletionRate = ComputeUtil.safeDiv((BigDecimal)allContractMoney, (BigDecimal)bigDecimal4);
                }
            }
        }
        jsonObject.put("outPutValueTarget", (Object)var18_48);
        jsonObject.put("targetCompletionRate", (Object)targetCompletionRate);
        if (CollectionUtils.isNotEmpty(dataVOS)) {
            Collections.sort(dataVOS, new Comparator<ProjectDataVO>(){

                @Override
                public int compare(ProjectDataVO o1, ProjectDataVO o2) {
                    int a = "\u5176\u4ed6".equals(o1.getName()) ? 100000 : o1.getValue();
                    int b = "\u5176\u4ed6".equals(o2.getName()) ? 100000 : o1.getValue();
                    return a - b;
                }
            });
        }
        jsonObject.put("data", dataVOS);
        if (rangeType != null) {
            if (rangeType.contains("beijing")) {
                rangeType = "beijing";
            } else if (rangeType.contains("shanghai")) {
                rangeType = "beijing";
            } else if (rangeType.contains("chongqing")) {
                rangeType = "chongqing";
            } else if (rangeType.contains("tianjin")) {
                rangeType = "tianjin";
            }
        }
        jsonObject.put("range", (Object)(rangeType == null || rangeType.contains("null") ? "China" : rangeType));
        return CommonResponse.success((String)"\u67e5\u8be2\u6570\u636e\u6210\u529f\uff01", (Object)jsonObject);
    }

    @Override
    public CommonResponse<JSONObject> getProjectColumnarInfo(String range, String name, String dateIn, Long orgId) {
        ProjectVo projectVo;
        Map<String, List<ProjectCountVO>> map;
        String projectStatus = null;
        if (ProjectSurveyEnum.RANGE_BUILDING.getCode().equals(range)) {
            projectStatus = "1";
        }
        if (ProjectSurveyEnum.THISYEAR.getCode().equals(dateIn)) {
            dateIn = EJCDateUtil.getYear() + "";
        }
        ArrayList<ProjectCountVO> list = new ArrayList<ProjectCountVO>();
        CommonResponse listCommonResponse = this.projectSetApi.queryProjectList(projectStatus, dateIn, orgId, this.currentProvince);
        if (listCommonResponse.isSuccess()) {
            List data = (List)listCommonResponse.getData();
            List projectCountVOS2 = BeanMapper.mapList((Iterable)data, ProjectCountVO.class);
            list.addAll(projectCountVOS2);
        }
        ArrayList<Long> ids = new ArrayList<Long>();
        HashSet<Object> provinceSet = new HashSet<Object>();
        HashSet<String> citySet = new HashSet<String>();
        HashSet<String> countySet = new HashSet<String>();
        String pname = null;
        for (ProjectCountVO vo : list) {
            ids.add(vo.getId());
            if (StringUtils.isNotEmpty((CharSequence)vo.getArea())) {
                if (vo.getArea().equals("\u53f0\u6e7e\u7701")) {
                    vo.setProvince("\u53f0\u6e7e\u7701");
                    vo.setCity("\u53f0\u6e7e\u7701");
                    vo.setCounty("\u53f0\u6e7e\u7701");
                    provinceSet.add("\u53f0\u6e7e\u7701");
                    citySet.add("\u53f0\u6e7e\u7701");
                    countySet.add("\u53f0\u6e7e\u7701");
                    continue;
                }
                Map<String, String> areaMmap = AddressResolutionUtil.addressResolution(vo.getArea());
                if (areaMmap != null) {
                    String province = areaMmap.get("province") == null ? "\u5176\u4ed6" : areaMmap.get("province");
                    String string = areaMmap.get("city") == null ? "\u5176\u4ed6" : areaMmap.get("city");
                    String string2 = areaMmap.get("county") == null ? "\u5176\u4ed6" : areaMmap.get("county");
                    vo.setProvince(province);
                    vo.setCity(string);
                    vo.setCounty(string2);
                    provinceSet.add(province);
                    citySet.add(string);
                    countySet.add(string2);
                    if (!StringUtils.isNotBlank((CharSequence)name) || !string.equals(name)) continue;
                    pname = province;
                    continue;
                }
                vo.setProvince("\u5176\u4ed6");
                vo.setCity("\u5176\u4ed6");
                vo.setCounty("\u5176\u4ed6");
                provinceSet.add("\u5176\u4ed6");
                citySet.add("\u5176\u4ed6");
                countySet.add("\u5176\u4ed6");
                continue;
            }
            vo.setProvince("\u5176\u4ed6");
            vo.setCity("\u5176\u4ed6");
            vo.setCounty("\u5176\u4ed6");
            provinceSet.add("\u5176\u4ed6");
            citySet.add("\u5176\u4ed6");
            countySet.add("\u5176\u4ed6");
        }
        String rangeType = null;
        List<Object> dataVOS = new ArrayList();
        if (StringUtils.isNotBlank((CharSequence)name)) {
            if (provinceSet.contains(name)) {
                rangeType = AddressResolutionUtil.getProvincePinYin(name);
                dataVOS = this.projectCountByName(name, list, 0);
            } else if (citySet.contains(name)) {
                rangeType = AddressResolutionUtil.getProvincePinYin(pname) + "-" + AddressResolutionUtil.getNamePinYinChar(name, 1);
                dataVOS = this.projectCountByName(name, list, 1);
            }
        } else if (provinceSet.size() == 1) {
            if (citySet.size() == 1) {
                rangeType = AddressResolutionUtil.getProvincePinYin((String)provinceSet.iterator().next()) + "-" + AddressResolutionUtil.getNamePinYinChar((String)citySet.iterator().next(), 1);
                HashMap<String, ProjectDataVO> countyMap = new HashMap<String, ProjectDataVO>();
                for (ProjectCountVO projectCountVO : list) {
                    BigDecimal bigDecimal;
                    String string = projectCountVO.getCounty();
                    BigDecimal bigDecimal2 = bigDecimal = projectCountVO.getContractTaxMny() == null ? BigDecimal.ZERO : projectCountVO.getContractTaxMny();
                    if (!countyMap.containsKey(string)) {
                        ProjectDataVO projectDataVO = new ProjectDataVO();
                        projectDataVO.setName(string);
                        projectDataVO.setValue(1);
                        projectDataVO.setContractMoney(bigDecimal);
                        countyMap.put(string, projectDataVO);
                        continue;
                    }
                    ProjectDataVO projectDataVO = (ProjectDataVO)countyMap.get(string);
                    projectDataVO.setValue(projectDataVO.getValue() + 1);
                    projectDataVO.setContractMoney(projectDataVO.getContractMoney().add(bigDecimal));
                    countyMap.put(string, projectDataVO);
                }
                dataVOS = new ArrayList(countyMap.values());
                map = list.stream().collect(Collectors.groupingBy(ProjectCountVO::getCounty));
                for (ProjectDataVO projectDataVO : dataVOS) {
                    if (!map.containsKey(projectDataVO.getName())) continue;
                    List<ProjectCountVO> list2 = map.get(projectDataVO.getName());
                    ArrayList<ProjectVo> arrayList = new ArrayList<ProjectVo>();
                    for (ProjectCountVO projectCountVO : list2) {
                        projectVo = new ProjectVo();
                        projectVo.setId(projectCountVO.getId());
                        projectVo.setName(projectCountVO.getProjectName());
                        projectVo.setOrgId(projectCountVO.getOrgId());
                        projectVo.setProjectDepartmentId(projectCountVO.getProjectDepartmentId());
                        arrayList.add(projectVo);
                    }
                    projectDataVO.setProjectList(arrayList);
                }
            } else {
                rangeType = AddressResolutionUtil.getProvincePinYin((String)provinceSet.iterator().next());
                HashMap<String, ProjectDataVO> cityMap = new HashMap<String, ProjectDataVO>();
                for (ProjectCountVO projectCountVO : list) {
                    BigDecimal bigDecimal;
                    String string = projectCountVO.getCity();
                    BigDecimal bigDecimal3 = bigDecimal = projectCountVO.getContractTaxMny() == null ? BigDecimal.ZERO : projectCountVO.getContractTaxMny();
                    if (!cityMap.containsKey(string)) {
                        ProjectDataVO projectDataVO = new ProjectDataVO();
                        projectDataVO.setName(string);
                        projectDataVO.setValue(1);
                        projectDataVO.setContractMoney(bigDecimal);
                        cityMap.put(string, projectDataVO);
                        continue;
                    }
                    ProjectDataVO projectDataVO = (ProjectDataVO)cityMap.get(string);
                    projectDataVO.setValue(projectDataVO.getValue() + 1);
                    projectDataVO.setContractMoney(projectDataVO.getContractMoney().add(bigDecimal));
                    cityMap.put(string, projectDataVO);
                }
                dataVOS = new ArrayList(cityMap.values());
                map = list.stream().collect(Collectors.groupingBy(ProjectCountVO::getCity));
                for (ProjectDataVO projectDataVO : dataVOS) {
                    if (!map.containsKey(projectDataVO.getName())) continue;
                    List<ProjectCountVO> list3 = map.get(projectDataVO.getName());
                    ArrayList<ProjectVo> arrayList = new ArrayList<ProjectVo>();
                    for (ProjectCountVO projectCountVO : list3) {
                        projectVo = new ProjectVo();
                        projectVo.setId(projectCountVO.getId());
                        projectVo.setName(projectCountVO.getProjectName());
                        projectVo.setOrgId(projectCountVO.getOrgId());
                        projectVo.setProjectDepartmentId(projectCountVO.getProjectDepartmentId());
                        arrayList.add(projectVo);
                    }
                    projectDataVO.setProjectList(arrayList);
                }
            }
        } else {
            rangeType = "China";
            HashMap<String, ProjectDataVO> provinceMap = new HashMap<String, ProjectDataVO>();
            for (ProjectCountVO projectCountVO : list) {
                BigDecimal bigDecimal;
                String string = projectCountVO.getProvince();
                BigDecimal bigDecimal4 = bigDecimal = projectCountVO.getContractTaxMny() == null ? BigDecimal.ZERO : projectCountVO.getContractTaxMny();
                if (!provinceMap.containsKey(string)) {
                    ProjectDataVO projectDataVO = new ProjectDataVO();
                    projectDataVO.setName(string);
                    projectDataVO.setValue(1);
                    projectDataVO.setContractMoney(bigDecimal);
                    provinceMap.put(string, projectDataVO);
                    continue;
                }
                ProjectDataVO projectDataVO = (ProjectDataVO)provinceMap.get(string);
                projectDataVO.setValue(projectDataVO.getValue() + 1);
                projectDataVO.setContractMoney(projectDataVO.getContractMoney().add(bigDecimal));
                provinceMap.put(string, projectDataVO);
            }
            map = list.stream().collect(Collectors.groupingBy(ProjectCountVO::getProvince));
            dataVOS = new ArrayList(provinceMap.values());
            for (ProjectDataVO projectDataVO : dataVOS) {
                if (!map.containsKey(projectDataVO.getName())) continue;
                List<ProjectCountVO> list4 = map.get(projectDataVO.getName());
                ArrayList<ProjectVo> arrayList = new ArrayList<ProjectVo>();
                for (ProjectCountVO projectCountVO : list4) {
                    projectVo = new ProjectVo();
                    projectVo.setId(projectCountVO.getId());
                    projectVo.setName(projectCountVO.getProjectName());
                    projectVo.setOrgId(projectCountVO.getOrgId());
                    projectVo.setProjectDepartmentId(projectCountVO.getProjectDepartmentId());
                    arrayList.add(projectVo);
                }
                projectDataVO.setProjectList(arrayList);
            }
        }
        JSONObject jsonObject = new JSONObject();
        if (CollectionUtils.isNotEmpty(dataVOS)) {
            Collections.sort(dataVOS, new Comparator<ProjectDataVO>(){

                @Override
                public int compare(ProjectDataVO o1, ProjectDataVO o2) {
                    int a = "\u5176\u4ed6".equals(o1.getName()) ? 100000 : o1.getValue();
                    int b = "\u5176\u4ed6".equals(o2.getName()) ? 100000 : o1.getValue();
                    return a - b;
                }
            });
        }
        if (rangeType != null) {
            if (rangeType.contains("beijing")) {
                rangeType = "beijing";
            } else if (rangeType.contains("shanghai")) {
                rangeType = "beijing";
            } else if (rangeType.contains("chongqing")) {
                rangeType = "chongqing";
            } else if (rangeType.contains("tianjin")) {
                rangeType = "tianjin";
            }
        }
        if (rangeType == null || rangeType.contains("null")) {
            rangeType = "China";
        }
        ArrayList<ProjectDataVO> projectDataVOS = new ArrayList<ProjectDataVO>();
        if (CollectionUtils.isNotEmpty(dataVOS)) {
            Map<String, ProjectDataVO> map2 = dataVOS.stream().collect(Collectors.toMap(k -> k.getName(), k -> k));
            if (rangeType.equals("China")) {
                BigDecimal totalContractMoney;
                List pids;
                if (this.currentProvince.equals("shanxi")) {
                    if (map2.containsKey(this.BASE_PROVINCE)) {
                        ArrayList<ProjectVo> arrayList = new ArrayList<ProjectVo>();
                        ProjectDataVO projectDataVO = map2.get(this.BASE_PROVINCE);
                        if (projectDataVO != null) {
                            arrayList.addAll(projectDataVO.getProjectList());
                        }
                        List list5 = arrayList.stream().map(ProjectVo::getId).collect(Collectors.toList());
                        BigDecimal totalContractMoney2 = BigDecimal.ZERO;
                        QueryParam queryParam = new QueryParam();
                        queryParam.getParams().put("sourceType", new Parameter("eq", (Object)"contraction"));
                        queryParam.getParams().put("projectId", new Parameter("in", list5));
                        CommonResponse bigDecimalCommonResponse = this.iContractPoolApi.queryContractMny(queryParam);
                        ProjectDataVO projectDataVO3 = new ProjectDataVO();
                        projectDataVO3.setCurrentProvince(this.BASE_PROVINCE);
                        projectDataVO3.setName("\u7701\u5185");
                        if (bigDecimalCommonResponse.isSuccess()) {
                            totalContractMoney2 = (BigDecimal)bigDecimalCommonResponse.getData();
                            projectDataVO3.setContractMoney(totalContractMoney2);
                        }
                        projectDataVO3.setValue(list5.size());
                        projectDataVOS.add(projectDataVO3);
                    }
                    ArrayList arrayList = new ArrayList();
                    for (ProjectDataVO projectDataVO : dataVOS) {
                        if ("\u5176\u4ed6".equals(projectDataVO.getName()) || this.BASE_PROVINCE.equals(projectDataVO.getName())) continue;
                        pids = projectDataVO.getProjectList().stream().map(ProjectVo::getId).collect(Collectors.toList());
                        arrayList.addAll(pids);
                    }
                    QueryParam queryParam = new QueryParam();
                    queryParam.getParams().put("sourceType", new Parameter("eq", (Object)"contraction"));
                    queryParam.getParams().put("projectId", new Parameter("in", arrayList));
                    CommonResponse commonResponse = this.iContractPoolApi.queryContractMny(queryParam);
                    ProjectDataVO projectDataVO = new ProjectDataVO();
                    projectDataVO.setName("\u7701\u5916");
                    totalContractMoney = BigDecimal.ZERO;
                    if (commonResponse.isSuccess()) {
                        totalContractMoney = (BigDecimal)commonResponse.getData();
                        projectDataVO.setContractMoney(totalContractMoney);
                    }
                    projectDataVO.setValue(arrayList.size());
                    projectDataVOS.add(projectDataVO);
                } else {
                    if (map2.containsKey("\u4e91\u5357\u7701")) {
                        ArrayList<ProjectVo> arrayList = new ArrayList<ProjectVo>();
                        ProjectDataVO projectDataVO = map2.get("\u4e91\u5357\u7701");
                        if (projectDataVO != null) {
                            arrayList.addAll(projectDataVO.getProjectList());
                        }
                        List list6 = arrayList.stream().map(ProjectVo::getId).collect(Collectors.toList());
                        BigDecimal totalContractMoney2 = BigDecimal.ZERO;
                        QueryParam queryParam2 = new QueryParam();
                        queryParam2.getParams().put("sourceType", new Parameter("eq", (Object)"contraction"));
                        queryParam2.getParams().put("projectId", new Parameter("in", list6));
                        CommonResponse bigDecimalCommonResponse2 = this.iContractPoolApi.queryContractMny(queryParam2);
                        ProjectDataVO projectDataVO4 = new ProjectDataVO();
                        projectDataVO4.setName("\u7701\u5185");
                        projectDataVO4.setCurrentProvince("\u4e91\u5357\u7701");
                        if (bigDecimalCommonResponse2.isSuccess()) {
                            totalContractMoney2 = (BigDecimal)bigDecimalCommonResponse2.getData();
                            projectDataVO4.setContractMoney(totalContractMoney2);
                        }
                        projectDataVO4.setValue(list6.size());
                        projectDataVOS.add(projectDataVO4);
                    }
                    ArrayList arrayList = new ArrayList();
                    for (ProjectDataVO projectDataVO : dataVOS) {
                        if ("\u5176\u4ed6".equals(projectDataVO.getName()) || "\u9655\u897f\u7701".equals(projectDataVO.getName())) continue;
                        pids = projectDataVO.getProjectList().stream().map(ProjectVo::getId).collect(Collectors.toList());
                        arrayList.addAll(pids);
                    }
                    QueryParam queryParam = new QueryParam();
                    queryParam.getParams().put("sourceType", new Parameter("eq", (Object)"contraction"));
                    queryParam.getParams().put("projectId", new Parameter("in", arrayList));
                    CommonResponse commonResponse = this.iContractPoolApi.queryContractMny(queryParam);
                    ProjectDataVO projectDataVO2 = new ProjectDataVO();
                    projectDataVO2.setName("\u7701\u5916");
                    totalContractMoney = BigDecimal.ZERO;
                    if (commonResponse.isSuccess()) {
                        totalContractMoney = (BigDecimal)commonResponse.getData();
                        projectDataVO2.setContractMoney(totalContractMoney);
                    }
                    projectDataVO2.setValue(arrayList.size());
                    projectDataVOS.add(projectDataVO2);
                }
                jsonObject.put("data", projectDataVOS);
                return CommonResponse.success((String)"\u67e5\u8be2\u6570\u636e\u6210\u529f\uff01", (Object)jsonObject);
            }
            for (ProjectDataVO projectDataVO : dataVOS) {
                BigDecimal bigDecimal = BigDecimal.ZERO;
                List<ProjectVo> projectList = projectDataVO.getProjectList();
                List projectIds = projectList.stream().map(ProjectVo::getId).collect(Collectors.toList());
                QueryParam queryParam = new QueryParam();
                queryParam.getParams().put("sourceType", new Parameter("eq", (Object)"contraction"));
                queryParam.getParams().put("projectId", new Parameter("in", projectIds));
                CommonResponse bigDecimalCommonResponse = this.iContractPoolApi.queryContractMny(queryParam);
                if (bigDecimalCommonResponse.isSuccess()) {
                    BigDecimal bigDecimal5 = (BigDecimal)bigDecimalCommonResponse.getData();
                    projectDataVO.setContractMoney(bigDecimal5);
                }
                projectDataVO.setValue(projectIds.size());
                projectDataVO.setProjectList(null);
            }
        }
        jsonObject.put("data", dataVOS);
        return CommonResponse.success((String)"\u67e5\u8be2\u6570\u636e\u6210\u529f\uff01", (Object)jsonObject);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    private List<ProjectDataVO> projectCountByName(String name, List<ProjectCountVO> list, Integer type) {
        ArrayList dataVOS = new ArrayList();
        HashMap<String, ProjectDataVO> map = new HashMap<String, ProjectDataVO>();
        for (ProjectCountVO vo : list) {
            BigDecimal contractTaxMny;
            String voName = null;
            String childrenName = null;
            if (type == 0) {
                voName = vo.getProvince();
                childrenName = vo.getCity();
            } else {
                voName = vo.getCity();
                childrenName = vo.getCounty();
            }
            if (!voName.equals(name)) continue;
            BigDecimal bigDecimal = contractTaxMny = vo.getContractTaxMny() == null ? BigDecimal.ZERO : vo.getContractTaxMny();
            if (!map.containsKey(childrenName)) {
                ProjectDataVO pvo = new ProjectDataVO();
                pvo.setName(childrenName);
                pvo.setValue(1);
                pvo.setContractMoney(contractTaxMny);
                map.put(childrenName, pvo);
                continue;
            }
            ProjectDataVO projectDataVO = (ProjectDataVO)map.get(childrenName);
            projectDataVO.setValue(projectDataVO.getValue() + 1);
            projectDataVO.setContractMoney(projectDataVO.getContractMoney().add(contractTaxMny));
            map.put(childrenName, projectDataVO);
        }
        Map<String, List<ProjectCountVO>> projectCountVOMap = null;
        projectCountVOMap = type == 0 ? list.stream().collect(Collectors.groupingBy(ProjectCountVO::getCity)) : list.stream().collect(Collectors.groupingBy(ProjectCountVO::getCounty));
        ArrayList<ProjectDataVO> projectDataVOS = new ArrayList<ProjectDataVO>(map.values());
        for (ProjectDataVO dataVO : projectDataVOS) {
            if (!map.containsKey(dataVO.getName())) continue;
            List<ProjectCountVO> projectCountVOS = projectCountVOMap.get(dataVO.getName());
            ArrayList<ProjectVo> projectVos = new ArrayList<ProjectVo>();
            for (ProjectCountVO projectCountVO : projectCountVOS) {
                ProjectVo projectVo = new ProjectVo();
                projectVo.setId(projectCountVO.getId());
                projectVo.setName(projectCountVO.getProjectName());
                projectVo.setOrgId(projectCountVO.getOrgId());
                projectVo.setProjectDepartmentId(projectCountVO.getProjectDepartmentId());
                projectVos.add(projectVo);
            }
            dataVO.setProjectList(projectVos);
        }
        return projectDataVOS;
    }
}

