/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.market.controller;

import cn.hutool.core.io.IoUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.market.bean.CloseCostEntity;
import com.ejianc.business.market.service.ICloseCostService;
import com.ejianc.business.market.vo.CloseCostInfoVO;
import com.ejianc.business.market.vo.CloseCostReportVO;
import com.ejianc.business.market.vo.CloseCostVO;
import com.ejianc.business.market.vo.CloseCostZiReportVO;
import com.ejianc.business.market.vo.TargetCostFitDTO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ClassPathResource;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"closeCost"})
public class CloseCostController
implements Serializable {
    private static final long serialVersionUID = -6108432280361278283L;
    private static final String RULE_CODE = "CLOSE_COST";
    private static final String BILL_CODE = "EJCBT202209000016";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final SessionManager sessionManager;
    private final IBillTypeApi billTypeApi;
    private final IBillCodeApi billCodeApi;
    private final IOrgApi iOrgApi;
    private final ICloseCostService service;
    private static final String INDEX_EX_CONTRACTT = "ex_contractt";

    public CloseCostController(SessionManager sessionManager, IBillTypeApi billTypeApi, IBillCodeApi billCodeApi, IOrgApi iOrgApi, ICloseCostService service) {
        this.sessionManager = sessionManager;
        this.billTypeApi = billTypeApi;
        this.billCodeApi = billCodeApi;
        this.iOrgApi = iOrgApi;
        this.service = service;
    }

    @PostMapping(value={"/saveOrUpdate"})
    public CommonResponse<CloseCostVO> saveOrUpdate(@RequestBody CloseCostVO saveOrUpdateVO) {
        CloseCostEntity entity = (CloseCostEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, CloseCostEntity.class));
        if (null == entity.getId() || 0L == entity.getId()) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)RULE_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        entity.setBillName("\u6210\u672c\u5173\u95e8");
        entity.setBillStateName(BillStateEnum.UNCOMMITED_STATE.getDescription());
        this.service.saveOrUpdate((Object)entity, false);
        CloseCostVO vo = (CloseCostVO)BeanMapper.map((Object)((Object)entity), CloseCostVO.class);
        List list = vo.getCloseCostInfoList().stream().sorted(Comparator.comparing(CloseCostInfoVO::getSequence, Comparator.nullsFirst(Integer::compareTo))).collect(Collectors.toList());
        vo.setCloseCostInfoList(list);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @GetMapping(value={"/queryDetail"})
    public CommonResponse<CloseCostVO> queryDetail(@RequestParam(value="id", required=true) Long id) {
        CloseCostEntity entity = (CloseCostEntity)((Object)this.service.selectById(id));
        CloseCostVO vo = (CloseCostVO)BeanMapper.map((Object)((Object)entity), CloseCostVO.class);
        List list = vo.getCloseCostInfoList().stream().sorted(Comparator.comparing(CloseCostInfoVO::getSequence, Comparator.nullsFirst(Integer::compareTo))).collect(Collectors.toList());
        vo.setCloseCostInfoList(list);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @PostMapping(value={"/delete"})
    public CommonResponse<String> delete(@RequestBody List<CloseCostVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (CloseCostVO vo : vos) {
                CommonResponse resp = this.billTypeApi.checkQuote(BILL_CODE, vo.getId());
                if (resp.isSuccess()) continue;
                return CommonResponse.error((String)("\u5220\u9664\u5931\u8d25\uff01" + resp.getMsg()));
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @PostMapping(value={"/queryList"})
    public CommonResponse<JSONObject> queryList(@RequestBody QueryParam param) {
        JSONObject resp = new JSONObject();
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        List orgVOList = null;
        ArrayList commonOrgIds = new ArrayList();
        if (!param.getParams().containsKey("orgId")) {
            if (OrgVO.ORG_TYPE_DEPARTMENT.equals(Integer.valueOf(InvocationInfoProxy.getOrgType()))) {
                param.getParams().put("orgId", new Parameter("eq", (Object)InvocationInfoProxy.getOrgId()));
            } else {
                CommonResponse orgResp = this.iOrgApi.findChildrenByParentIdWithoutProjectDept(InvocationInfoProxy.getOrgId());
                if (!orgResp.isSuccess()) {
                    this.logger.error("\u5206\u9875\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25, {}", (Object)orgResp.getMsg());
                    return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
                }
                param.getParams().put("parentOrgId", new Parameter("in", ((List)orgResp.getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
            }
        } else {
            Long orgId = Long.valueOf(((Parameter)param.getParams().get("orgId")).getValue().toString());
            param.getParams().remove("orgId");
            orgVOList = (List)this.getRespData(this.iOrgApi.findChildrenByParentId(orgId), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
            orgVOList.stream().forEach(org -> commonOrgIds.add(org.getId()));
            if (CollectionUtils.isNotEmpty(commonOrgIds)) {
                param.getParams().put("parentOrgId", new Parameter("in", commonOrgIds));
            }
        }
        IPage page = this.service.queryPage(param, false);
        List closeCost = BeanMapper.mapList((Iterable)page.getRecords(), CloseCostVO.class);
        resp.put("current", (Object)page.getCurrent());
        resp.put("size", (Object)page.getSize());
        resp.put("pages", (Object)page.getPages());
        resp.put("total", (Object)page.getTotal());
        resp.put("records", (Object)closeCost);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)resp);
    }

    @PostMapping(value={"/excelExport"})
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) throws IOException {
        ClassPathResource resource = new ClassPathResource("excel/\u6210\u672c\u5173\u95e8\u7edf\u8ba1\u8868\u6a21\u677f.xlsx");
        IoUtil.copy((InputStream)resource.getInputStream(), (OutputStream)response.getOutputStream());
    }

    @PostMapping(value={"/autoCloseCost"})
    public CommonResponse<String> autoCloseCost(HttpServletRequest request) {
        this.logger.info("\u81ea\u52a8\u5173\u95e8--------start");
        this.service.autoCloseCost();
        this.logger.info("\u81ea\u52a8\u5173\u95e8--------end");
        return CommonResponse.success((String)"\u8bf7\u6c42\u6210\u529f");
    }

    @RequestMapping(value={"getDetailByProjectId"}, method={RequestMethod.GET})
    CommonResponse<JSONObject> getDetailByProjectId(@RequestParam(value="projectId", required=true) Long projectId) {
        HashMap<String, BigDecimal> result = this.service.getDetailByProjectId(projectId);
        JSONObject jsonObject = new JSONObject();
        jsonObject.putAll(result);
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", (Object)jsonObject);
    }

    @RequestMapping(value={"getByProjectId"}, method={RequestMethod.GET})
    CommonResponse<List<CloseCostVO>> getByProjectId(@RequestParam(value="projectId", required=true) Long projectId) {
        List list = this.service.list((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(CloseCostEntity::getProjectId, (Object)projectId)).in(CloseCostEntity::getBillState, Arrays.asList(1, 3)));
        if (ListUtil.isNotEmpty((List)list)) {
            List closeCostVOS = BeanMapper.mapList((Iterable)list, CloseCostVO.class);
            return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", (Object)closeCostVOS);
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f,\u65e0\u76f8\u5173\u6570\u636e\uff01");
    }

    @RequestMapping(value={"queryESContract"}, method={RequestMethod.GET})
    CommonResponse<List<JSONObject>> queryESContract(@RequestParam(value="projectId", required=true) Long projectId) {
        List<JSONObject> result = this.service.queryESContract(projectId, INDEX_EX_CONTRACTT);
        if (ListUtil.isNotEmpty(result)) {
            return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", result);
        }
        return CommonResponse.error((String)"\u6839\u636e\u9879\u76eeid\u67e5\u8be2es\u6570\u636e\u5931\u8d25\uff0c\u8bf7\u67e5\u8be2\u9879\u76ee\u652f\u51fa\u5408\u540c\u53f0\u8d26\u662f\u5426\u5b58\u5728\u8be5\u9879\u76ee\u6570\u636e\uff01");
    }

    @RequestMapping(value={"/excelCloseCostInfoExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelCloseCostInfoExport(@RequestBody List<CloseCostInfoVO> vo, HttpServletResponse response) {
        HashMap<String, List<CloseCostInfoVO>> beans = new HashMap<String, List<CloseCostInfoVO>>();
        beans.put("records", vo);
        ExcelExport.getInstance().export("CloseCostInfo-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/excelReportExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelReportExport(@RequestBody List<CloseCostZiReportVO> vo, HttpServletResponse response) {
        HashMap<String, List<CloseCostZiReportVO>> beans = new HashMap<String, List<CloseCostZiReportVO>>();
        beans.put("records", vo);
        ExcelExport.getInstance().export("CloseCostZiReport-export.xlsx", beans, response);
    }

    @PostMapping(value={"/queryReportList"})
    public CommonResponse<Page<CloseCostReportVO>> queryReportList(@RequestBody QueryParam param) {
        List orgVOList = null;
        ArrayList commonOrgIds = new ArrayList();
        if (!param.getParams().containsKey("orgId")) {
            if (OrgVO.ORG_TYPE_DEPARTMENT.equals(Integer.valueOf(InvocationInfoProxy.getOrgType()))) {
                param.getParams().put("orgId", new Parameter("eq", (Object)InvocationInfoProxy.getOrgId()));
            } else {
                CommonResponse orgResp = this.iOrgApi.findChildrenByParentIdWithoutProjectDept(InvocationInfoProxy.getOrgId());
                if (!orgResp.isSuccess()) {
                    this.logger.error("\u5206\u9875\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25, {}", (Object)orgResp.getMsg());
                    return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
                }
                param.getParams().put("parentOrgId", new Parameter("in", ((List)orgResp.getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
            }
        } else {
            Long orgId = Long.valueOf(((Parameter)param.getParams().get("orgId")).getValue().toString());
            param.getParams().remove("orgId");
            orgVOList = (List)this.getRespData(this.iOrgApi.findChildrenByParentId(orgId), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
            orgVOList.stream().forEach(org -> commonOrgIds.add(org.getId()));
            if (CollectionUtils.isNotEmpty(commonOrgIds)) {
                param.getParams().put("parentOrgId", new Parameter("in", commonOrgIds));
            }
        }
        param.getFuzzyFields().add("projectName");
        Page<CloseCostReportVO> closeCostReportVOS = this.service.queryReportList(param);
        return CommonResponse.success((String)"\u67e5\u8be2\u53f0\u8d26\u4fe1\u606f\u6210\u529f\uff01", closeCostReportVOS);
    }

    @RequestMapping(value={"/excelCloseCostReportExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelCloseCostReportExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List orgVOList = null;
        ArrayList commonOrgIds = new ArrayList();
        if (!param.getParams().containsKey("orgId")) {
            if (OrgVO.ORG_TYPE_DEPARTMENT.equals(Integer.valueOf(InvocationInfoProxy.getOrgType()))) {
                param.getParams().put("orgId", new Parameter("eq", (Object)InvocationInfoProxy.getOrgId()));
            } else {
                CommonResponse orgResp = this.iOrgApi.findChildrenByParentIdWithoutProjectDept(InvocationInfoProxy.getOrgId());
                if (!orgResp.isSuccess()) {
                    this.logger.error("\u5206\u9875\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25, {}", (Object)orgResp.getMsg());
                }
                param.getParams().put("parentOrgId", new Parameter("in", ((List)orgResp.getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
            }
        } else {
            Long orgId = Long.valueOf(((Parameter)param.getParams().get("orgId")).getValue().toString());
            param.getParams().remove("orgId");
            orgVOList = (List)this.getRespData(this.iOrgApi.findChildrenByParentId(orgId), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
            orgVOList.stream().forEach(org -> commonOrgIds.add(org.getId()));
            if (CollectionUtils.isNotEmpty(commonOrgIds)) {
                param.getParams().put("parentOrgId", new Parameter("in", commonOrgIds));
            }
        }
        param.getFuzzyFields().add("projectName");
        Page<CloseCostReportVO> closeCostReportVOS = this.service.queryReportList(param);
        HashMap<String, Page<CloseCostReportVO>> beans = new HashMap<String, Page<CloseCostReportVO>>();
        beans.put("records", closeCostReportVOS);
        ExcelExport.getInstance().export("closeCostReport-export.xlsx", beans, response);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"getTargetReportFit"}, method={RequestMethod.GET})
    CommonResponse<TargetCostFitDTO> getTargetReportFit(@RequestParam(value="projectId", required=true) Long projectId) {
        TargetCostFitDTO targetReportFit = this.service.getTargetReportFit(projectId);
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", (Object)targetReportFit);
    }
}

