/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.market.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.constructor.vo.NbzzFollowVO;
import com.ejianc.business.market.bean.ProjectSetEntity;
import com.ejianc.business.market.controller.CloseCostController;
import com.ejianc.business.market.mapper.ProjectSetMapper;
import com.ejianc.business.market.service.IAdjustApplicationService;
import com.ejianc.business.market.service.ICloseCostService;
import com.ejianc.business.market.service.IProjectSetService;
import com.ejianc.business.market.vo.CloseCostReportVO;
import com.ejianc.business.market.vo.CostDesktopDTO;
import com.ejianc.business.market.vo.CostDesktopVO;
import com.ejianc.business.market.vo.ProjectSetVO;
import com.ejianc.business.project.vo.ProjectAddressVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.api.IProjectSetApi;
import com.ejianc.foundation.share.vo.ProjectPoolSetVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.support.idworker.util.IdWorker;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="projectSetService")
public class ProjectSetServiceImpl
extends BaseServiceImpl<ProjectSetMapper, ProjectSetEntity>
implements IProjectSetService {
    @Autowired
    private IProjectSetApi iProjectSetApi;
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private IProjectSetService service;
    @Autowired
    private CloseCostController closeCostController;
    @Autowired
    private IAdjustApplicationService adjustApplicationService;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ICloseCostService closeCostService;

    @Override
    public CommonResponse<String> pushProjectPoolSet(ProjectSetEntity projectSetEntity, String billTypeCode) {
        CommonResponse resp;
        ProjectSetVO projectSetVO = (ProjectSetVO)((Object)BeanMapper.map((Object)((Object)projectSetEntity), ProjectSetVO.class));
        OrgVO projectDepartment = null;
        if (null == projectSetVO.getProjectDepartmentId()) {
            throw new BusinessException("\u63d0\u4ea4\u9879\u76ee\u4fe1\u606f\u5931\u8d25\uff0c\u4fdd\u5b58\u9879\u76ee\u90e8\u4fe1\u606f\u51fa\u9519\uff01");
        }
        projectDepartment = (OrgVO)this.orgApi.getOneById(projectSetVO.getProjectDepartmentId()).getData();
        if (projectDepartment != null) {
            projectDepartment.setProjectCode(projectSetVO.getCode());
            projectDepartment.setProjectState(Integer.valueOf(1));
        }
        if (null != projectDepartment && !(resp = this.orgApi.saveOrgInfo(projectDepartment)).isSuccess()) {
            throw new BusinessException("\u63d0\u4ea4\u9879\u76ee\u4fe1\u606f\u5931\u8d25\uff0c\u4fdd\u5b58\u9879\u76ee\u90e8\u4fe1\u606f\u51fa\u9519: " + resp.getMsg());
        }
        this.service.saveOrUpdate((Object)projectSetEntity, false);
        ProjectPoolSetVO projectPoolSetVO = (ProjectPoolSetVO)BeanMapper.map((Object)((Object)projectSetEntity), ProjectPoolSetVO.class);
        this.logger.info("\u63a8\u9001\u9879\u76ee\u6c60\u4fe1\u606f\u4e3a{}", (Object)projectPoolSetVO);
        return this.iProjectSetApi.pushProjectPoolSetNoInitial(JSONObject.toJSONString((Object)projectPoolSetVO).getBytes(StandardCharsets.UTF_8));
    }

    @Override
    public CommonResponse<String> pushProjectPoolSetNoInitial(ProjectSetEntity projectSetEntity, String billTypeCode) {
        CommonResponse resp;
        ProjectSetVO projectSetVO = (ProjectSetVO)((Object)BeanMapper.map((Object)((Object)projectSetEntity), ProjectSetVO.class));
        OrgVO projectDepartment = null;
        if (null == projectSetVO.getProjectDepartmentId()) {
            throw new BusinessException("\u63d0\u4ea4\u9879\u76ee\u4fe1\u606f\u5931\u8d25\uff0c\u4fdd\u5b58\u9879\u76ee\u90e8\u4fe1\u606f\u51fa\u9519\uff01");
        }
        projectDepartment = (OrgVO)this.orgApi.getOneById(projectSetVO.getProjectDepartmentId()).getData();
        if (projectDepartment != null) {
            projectDepartment.setProjectCode(projectSetVO.getCode());
            projectDepartment.setProjectState(Integer.valueOf(1));
        }
        if (null != projectDepartment && !(resp = this.orgApi.saveOrgInfo(projectDepartment)).isSuccess()) {
            throw new BusinessException("\u63d0\u4ea4\u9879\u76ee\u4fe1\u606f\u5931\u8d25\uff0c\u4fdd\u5b58\u9879\u76ee\u90e8\u4fe1\u606f\u51fa\u9519: " + resp.getMsg());
        }
        this.service.saveOrUpdate((Object)projectSetEntity, false);
        ProjectPoolSetVO projectPoolSetVO = (ProjectPoolSetVO)BeanMapper.map((Object)((Object)projectSetEntity), ProjectPoolSetVO.class);
        this.logger.info("\u63a8\u9001\u9879\u76ee\u6c60\u4fe1\u606f\u4e3a{}", (Object)projectPoolSetVO);
        return this.iProjectSetApi.pushProjectPoolSetNoInitial(JSONObject.toJSONString((Object)projectPoolSetVO).getBytes(StandardCharsets.UTF_8));
    }

    @Override
    public CommonResponse<List<ProjectAddressVO>> queryProjectAddress(QueryParam param, String year) {
        param.getParams().put("billState", new Parameter("in", (Object)"1,3"));
        List list = this.service.queryList(param);
        List projectAddressVOList = new ArrayList();
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            projectAddressVOList = BeanMapper.mapList((Iterable)list, ProjectAddressVO.class);
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u9879\u76ee\u5730\u56fe\u5206\u5e03\u6570\u636e\u6210\u529f\uff01", projectAddressVOList);
    }

    @Override
    public CostDesktopVO queryProjectNumCostDesktop() {
        CostDesktopVO costDesktopVO = ((ProjectSetMapper)this.baseMapper).queryProjectNumCostDesktop();
        ArrayList<CostDesktopDTO> fjList = new ArrayList<CostDesktopDTO>();
        ArrayList<CostDesktopDTO> szList = new ArrayList<CostDesktopDTO>();
        ArrayList<CostDesktopDTO> qtList = new ArrayList<CostDesktopDTO>();
        fjList.add(new CostDesktopDTO("12%\u4ee5\u4e0a", 0));
        szList.add(new CostDesktopDTO("12%\u4ee5\u4e0a", 0));
        qtList.add(new CostDesktopDTO("12%\u4ee5\u4e0a", 0));
        fjList.add(new CostDesktopDTO("8%-12%", 0));
        szList.add(new CostDesktopDTO("8%-12%", 0));
        qtList.add(new CostDesktopDTO("8%-12%", 0));
        fjList.add(new CostDesktopDTO("5%-8%", 0));
        szList.add(new CostDesktopDTO("5%-8%", 0));
        qtList.add(new CostDesktopDTO("5%-8%", 0));
        fjList.add(new CostDesktopDTO("3%-5%", 0));
        szList.add(new CostDesktopDTO("3%-5%", 0));
        qtList.add(new CostDesktopDTO("3%-5%", 0));
        fjList.add(new CostDesktopDTO("0%-3%", 0));
        szList.add(new CostDesktopDTO("0%-3%", 0));
        qtList.add(new CostDesktopDTO("0%-3%", 0));
        fjList.add(new CostDesktopDTO("0%\u4ee5\u4e0b", 0));
        szList.add(new CostDesktopDTO("0%\u4ee5\u4e0b", 0));
        qtList.add(new CostDesktopDTO("0%\u4ee5\u4e0b", 0));
        QueryParam param1 = new QueryParam();
        param1.setPageSize(1000);
        param1.setPageIndex(1);
        CommonResponse<Page<CloseCostReportVO>> pageCommonResponse = this.closeCostController.queryReportList(param1);
        if (pageCommonResponse.getCode() == 0) {
            int ksHalfYear = 0;
            int ksAll = 0;
            long time180DayAgo = System.currentTimeMillis() - -1627869184L;
            List records = ((Page)pageCommonResponse.getData()).getRecords();
            for (CloseCostReportVO record : records) {
                int index = -1;
                if (record.getProProfitPer().compareTo(new BigDecimal(0)) > -1) {
                    index = record.getProProfitPer().compareTo(new BigDecimal(3)) > -1 ? (record.getProProfitPer().compareTo(new BigDecimal(5)) > -1 ? (record.getProProfitPer().compareTo(new BigDecimal(8)) > -1 ? (record.getProProfitPer().compareTo(new BigDecimal(12)) > -1 ? 0 : 1) : 2) : 3) : 4;
                } else {
                    index = 5;
                    if (record.getCloseDate().getTime() > time180DayAgo) {
                        ++ksHalfYear;
                        CostDesktopDTO costDesktopDTO = new CostDesktopDTO();
                        costDesktopDTO.setId(record.getId());
                        costDesktopDTO.setName(record.getProjectName());
                        costDesktopDTO.setProProFit(record.getProProfit());
                        costDesktopDTO.setProProFitPer(record.getProProfitPer());
                        costDesktopVO.getKsHalfYearList().add(costDesktopDTO);
                    }
                    ++ksAll;
                }
                if (record.getEngineeringTypeName().contains("\u623f\u5c4b\u5efa\u7b51")) {
                    fjList.get(index).setValue(fjList.get(index).getValue() + 1);
                    continue;
                }
                if (record.getEngineeringTypeName().contains("\u5e02\u653f") || "\u57ce\u5e02\u8f68\u9053\u4ea4\u901a".equals(record.getEngineeringTypeName())) {
                    szList.get(index).setValue(szList.get(index).getValue() + 1);
                    continue;
                }
                qtList.get(index).setValue(qtList.get(index).getValue() + 1);
            }
            costDesktopVO.setKsAll(ksAll);
            costDesktopVO.setKsHalfYear(ksHalfYear);
        }
        costDesktopVO.setFjList(fjList);
        costDesktopVO.setSzList(szList);
        costDesktopVO.setQtList(qtList);
        List<CostDesktopDTO> costDesktopDTOS = this.adjustApplicationService.queryFinishWorkBill();
        costDesktopVO.setFinishWorkList(costDesktopDTOS);
        return costDesktopVO;
    }

    private OrgVO generateProjectDepartment(ProjectSetVO projectSetVO, boolean isSyncProject) {
        if (projectSetVO.getOrgId() == null) {
            throw new BusinessException("\u63d0\u4ea4\u9879\u76ee\u4fe1\u606f\u5931\u8d25\uff0c\u9879\u76ee\u6240\u5c5e\u7ec4\u7ec7\u4fe1\u606f\u4e0d\u5b58\u5728\u3002");
        }
        CommonResponse response = this.orgApi.getOneById(projectSetVO.getOrgId());
        OrgVO parentOrg = null;
        if (!response.isSuccess()) {
            throw new BusinessException("\u63d0\u4ea4\u9879\u76ee\u4fe1\u606f\u5931\u8d25\uff0c\u67e5\u8be2\u9879\u76ee\u6240\u5c5e\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25: " + response.getMsg());
        }
        parentOrg = (OrgVO)response.getData();
        if (null == parentOrg) {
            throw new BusinessException("\u63d0\u4ea4\u9879\u76ee\u4fe1\u606f\u5931\u8d25\uff0c\u9879\u76ee\u6240\u5c5e\u7ec4\u7ec7\u4fe1\u606f\u4e0d\u5b58\u5728\u3002");
        }
        OrgVO projectDepartment = new OrgVO();
        OrgVO paramVo = new OrgVO();
        paramVo.setName(projectSetVO.getName());
        paramVo.setOrgType(Integer.valueOf(5));
        paramVo.setTenantId(InvocationInfoProxy.getTenantid());
        response = this.orgApi.findOneByOrgVO(paramVo);
        if (response.isSuccess()) {
            if (response.getData() != null) {
                projectDepartment = (OrgVO)response.getData();
            } else {
                projectDepartment.setId(Long.valueOf(IdWorker.getId()));
                projectDepartment.setTenantId(parentOrg.getTenantId());
                projectDepartment.setName(projectSetVO.getName());
                projectDepartment.setShortName(projectSetVO.getShortName());
                projectDepartment.setState(Integer.valueOf(1));
                projectDepartment.setOrgType(OrgVO.ORG_TYPE_DEPARTMENT);
            }
        } else {
            throw new BusinessException("\u63d0\u4ea4\u9879\u76ee\u4fe1\u606f\u5931\u8d25\uff0c\u6839\u636e\u9879\u76ee\u540d\u79f0\u67e5\u8be2\u5bf9\u5e94\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25: " + response.getMsg());
        }
        projectDepartment.setIsParent(Boolean.valueOf(false));
        projectDepartment.setProjectCode(projectSetVO.getCode());
        projectDepartment.setEnterpriseId(parentOrg.getEnterpriseId());
        projectDepartment.setParentId(projectSetVO.getOrgId());
        projectDepartment.setProjectState(Integer.valueOf(1));
        return projectDepartment;
    }

    @Override
    public List<NbzzFollowVO> queryFollowListByProjectId(Long projectId) {
        return ((ProjectSetMapper)this.baseMapper).queryFollowListByProjectId(projectId);
    }

    public static void main(String[] args) {
        long l = System.currentTimeMillis();
        long l1 = l - -1627869184L;
        long time = new Date().getTime();
        System.out.println(l);
        System.out.println(l1);
        System.out.println(time);
    }
}

