/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.market.service.impl;

import com.ejianc.business.enums.BusinessStatusEnum;
import com.ejianc.business.enums.ProjectStatusEnum;
import com.ejianc.business.market.bean.ProjectSetEntity;
import com.ejianc.business.market.bean.ResumeWorkReportEntity;
import com.ejianc.business.market.service.IProjectSetService;
import com.ejianc.business.market.service.IResumeWorkReportService;
import com.ejianc.foundation.share.api.IProjectSetApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="resumeWorkReport")
public class ResumeWorkReportBpmServiceImpl
implements ICommonBusinessService {
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IResumeWorkReportService resumeWorkReportService;
    @Autowired
    private IProjectSetApi iProjectSetApi;
    @Autowired
    private IProjectSetService projectSetService;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.error((String)"\u8be5\u5355\u636e\u4e0d\u652f\u6301\u5f03\u5ba1\u548c\u64a4\u56de");
    }

    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        ResumeWorkReportEntity entity = (ResumeWorkReportEntity)((Object)this.resumeWorkReportService.selectById(billId));
        if (entity != null) {
            ProjectSetEntity setEntity = (ProjectSetEntity)((Object)this.projectSetService.getById(entity.getProjectId()));
            setEntity.setProjectStatus(ProjectStatusEnum.\u5728\u5efa.getCode());
            setEntity.setBusinessStatus(BusinessStatusEnum.\u5728\u65bd.getCode());
            setEntity.setChangeStatusDate(new Date());
            this.projectSetService.updateById((Object)setEntity);
            CommonResponse res = this.iProjectSetApi.changeProjectStatus(entity.getProjectId(), ProjectStatusEnum.\u5728\u5efa.getCode(), BusinessStatusEnum.\u5728\u65bd.getCode(), null, null, null);
            if (!res.isSuccess()) {
                this.logger.info("\u590d\u5de5\u62a5\u544a\u3010{}\u3011\u66f4\u65b0\u3010\u9879\u76ee\u6c60\u3011\u4e1a\u52a1\u72b6\u6001\u4e3a\u5728\u65bd\uff0c\u9879\u76ee\u72b6\u6001\u4e3a\u5728\u5efa\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a{}", (Object)entity.getBillCode(), (Object)res.getMsg());
                throw new BusinessException("\u590d\u5de5\u62a5\u544a\u3010" + entity.getBillCode() + "\u3011\u66f4\u65b0\u3010\u9879\u76ee\u6c60\u3011\u4e1a\u52a1\u72b6\u6001\u4e3a\u5728\u65bd\uff0c\u9879\u76ee\u72b6\u6001\u4e3a\u5728\u5efa\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a" + res.getMsg());
            }
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.error((String)"\u8be5\u5355\u636e\u4e0d\u652f\u6301\u5f03\u5ba1\u548c\u64a4\u56de");
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }
}

