/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.projectOverView.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.constructor.vo.JsglViewVO;
import com.ejianc.business.constructor.vo.ProgramReportVO;
import com.ejianc.business.contractbase.pool.enums.ContractTypeEnum;
import com.ejianc.business.danger.vo.DangerProjectVO;
import com.ejianc.business.market.bean.ProjectSetEntity;
import com.ejianc.business.market.service.IProjectSetService;
import com.ejianc.business.outputvalcount.vo.MeetingMinutesVO;
import com.ejianc.business.outputvalcount.vo.MonthlyStatisticsVO;
import com.ejianc.business.outputvalcount.vo.ProjectInfoRegisterCommunicationVO;
import com.ejianc.business.outputvalcount.vo.ProjectInfoRegisterDisputeVO;
import com.ejianc.business.outputvalcount.vo.ProjectInfoRegisterExamineVO;
import com.ejianc.business.outputvalcount.vo.ProjectInfoRegisterVO;
import com.ejianc.business.outputvalcount.vo.XmyxglVO;
import com.ejianc.business.plan.vo.TotalPlanVO;
import com.ejianc.business.pro.rmat.vo.SettleVO;
import com.ejianc.business.probuilddiary.person.vo.PersonVO;
import com.ejianc.business.probuilddiary.project.vo.ProjectLogVO;
import com.ejianc.business.profinance.api.IReceiptAndPaymentRegisterApi;
import com.ejianc.business.project.vo.UserInfoVO;
import com.ejianc.business.projectOverView.mapper.ProjectOverViewMapper;
import com.ejianc.business.projectOverView.service.IProjectOverViewService;
import com.ejianc.business.projectOverView.vo.AchieveData;
import com.ejianc.business.projectOverView.vo.FaDataVO;
import com.ejianc.business.projectOverView.vo.ImageDataVO;
import com.ejianc.business.projectOverView.vo.ImageListVO;
import com.ejianc.business.projectOverView.vo.LogDataVO;
import com.ejianc.business.projectOverView.vo.MeetingMinutesDataVO;
import com.ejianc.business.projectOverView.vo.PaymentRegisterData;
import com.ejianc.business.projectOverView.vo.PlanDataVO;
import com.ejianc.business.projectOverView.vo.QualityAndSafeDataVO;
import com.ejianc.business.projectOverView.vo.RectificationVO;
import com.ejianc.business.projectmanage.vo.PracticeVO;
import com.ejianc.business.promaterial.settlement.vo.SettlementVO;
import com.ejianc.business.qualisafe.vo.CheckVO;
import com.ejianc.business.qualisafe.vo.RectificationNoticeVO;
import com.ejianc.business.qualisafe.vo.RectificationRepeatVO;
import com.ejianc.business.quality.vo.GccymbsdVO;
import com.ejianc.business.rent.vo.RentParameterVO;
import com.ejianc.business.riskManage.vo.RiskAssessLatestVO;
import com.ejianc.business.technology.vo.YjDetailVO;
import com.ejianc.business.utils.DifferentMonth;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.orgcenter.api.IEmployeeApi;
import com.ejianc.foundation.orgcenter.api.IUserApi;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.time.DateUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="projectOverViewService")
public class ProjectOverViewServiceImpl
implements IProjectOverViewService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ProjectOverViewMapper projectOverViewMapper;
    @Autowired
    private IAttachmentApi attachmentApi;
    @Autowired
    private IEmployeeApi employeeApi;
    @Autowired
    private IUserApi userApi;
    @Autowired
    private IReceiptAndPaymentRegisterApi receiptAndPaymentRegisterApi;
    @Autowired
    private IProjectSetService projectSetService;

    @Override
    public FaDataVO queryFaData(Long projectId) {
        FaDataVO faDataVO = new FaDataVO();
        List<JsglViewVO> jsglViewVOS = this.projectOverViewMapper.queryFaData(projectId, null);
        List<ProgramReportVO> reportVOList = this.projectOverViewMapper.queryFaPlanData(projectId, null);
        Map<Object, Object> faNumMap = new HashMap();
        Map<Object, Object> faPlanNumMap = new HashMap();
        if (ListUtil.isNotEmpty(jsglViewVOS)) {
            faNumMap = jsglViewVOS.stream().collect(Collectors.groupingBy(JsglViewVO::getTags, Collectors.counting()));
            faDataVO.setProgramNum(Integer.valueOf(jsglViewVOS.size()));
            faDataVO.setProgramNumMap(faNumMap);
        } else {
            faDataVO.setProgramNum(Integer.valueOf(0));
        }
        if (ListUtil.isNotEmpty(reportVOList)) {
            faPlanNumMap = reportVOList.stream().collect(Collectors.groupingBy(ProgramReportVO::getTags, Collectors.summingLong(ProgramReportVO::getPlanNum)));
            long filterNum = reportVOList.stream().filter(s -> !s.getTags().equals("\u6280\u672f\u4e2d\u5fc3\u5ba1\u6838\u65b9\u6848")).count();
            faDataVO.setProgramPlanNumMap(faPlanNumMap);
            faDataVO.setProgramPlanNum(Integer.valueOf(reportVOList.size()));
            faDataVO.setFilterNum(Long.valueOf(filterNum));
        } else {
            faDataVO.setProgramPlanNum(Integer.valueOf(0));
        }
        return faDataVO;
    }

    @Override
    public QualityAndSafeDataVO queryCheckData(Long projectId) {
        List<RentParameterVO> rentParameterVOS;
        BigDecimal avgScore;
        Integer count;
        BigDecimal score;
        List<CheckVO> checkVOS = this.projectOverViewMapper.queryQualityCheckData(projectId);
        QualityAndSafeDataVO qualityAndSafeDataVO = new QualityAndSafeDataVO();
        List qualityVOS = checkVOS.stream().filter(s -> s.getCheckType().equals("\u8d28\u91cf")).collect(Collectors.toList());
        List safeVOS = checkVOS.stream().filter(s -> s.getCheckType().equals("\u5b89\u5168")).collect(Collectors.toList());
        Date date = new Date();
        if (ListUtil.isNotEmpty(qualityVOS)) {
            score = qualityVOS.stream().map(CheckVO::getScore).reduce(BigDecimal.ZERO, BigDecimal::add);
            count = qualityVOS.size();
            if (count != 0) {
                avgScore = score.divide(new BigDecimal(count), 2, 4);
                qualityAndSafeDataVO.setQualityScore(avgScore);
            } else {
                qualityAndSafeDataVO.setQualityScore(BigDecimal.ZERO);
            }
            qualityAndSafeDataVO.setQualityVOS(qualityVOS);
        }
        if (ListUtil.isNotEmpty(safeVOS)) {
            qualityAndSafeDataVO.setSafeVOS(safeVOS);
            score = safeVOS.stream().map(CheckVO::getScore).reduce(BigDecimal.ZERO, BigDecimal::add);
            count = safeVOS.size();
            if (count != 0) {
                avgScore = score.divide(new BigDecimal(count), 2, 4);
                qualityAndSafeDataVO.setSafeScore(avgScore);
            } else {
                qualityAndSafeDataVO.setSafeScore(BigDecimal.ZERO);
            }
            qualityAndSafeDataVO.setSafeVOS(safeVOS);
        }
        if (ListUtil.isNotEmpty(rentParameterVOS = this.projectOverViewMapper.queryLargeEquipment(projectId))) {
            qualityAndSafeDataVO.setLargeEquipmentNum(Integer.valueOf(rentParameterVOS.size()));
        }
        return qualityAndSafeDataVO;
    }

    @Override
    public MeetingMinutesDataVO queryMeetingMinutesData(Long projectId) {
        List<MeetingMinutesVO> meetingMinutesVOS = this.projectOverViewMapper.queryMeetingMinutesData(projectId);
        MeetingMinutesDataVO meetingMinutesDataVO = new MeetingMinutesDataVO();
        if (ListUtil.isNotEmpty(meetingMinutesVOS)) {
            meetingMinutesDataVO.setNum(Integer.valueOf(meetingMinutesVOS.size()));
        }
        return meetingMinutesDataVO;
    }

    @Override
    public GccymbsdVO queryTarget(Long projectId) {
        return this.projectOverViewMapper.queryTarget(projectId);
    }

    @Override
    public ImageDataVO queryImageData(Long projectId, String dateStr) {
        List<Object> xmyxglVOS = new ArrayList();
        ImageDataVO imageDataVO = new ImageDataVO();
        try {
            Date date = new SimpleDateFormat("yyyy-MM").parse(dateStr);
            Calendar ca = Calendar.getInstance();
            ca.setTime(date);
            int year = ca.get(1);
            int month = ca.get(2) + 1;
            xmyxglVOS = this.projectOverViewMapper.queryImageData(projectId, year, month);
            MonthlyStatisticsVO monthlyStatistics = this.projectOverViewMapper.queryMonthlyStatistics(projectId, year, month);
            if (monthlyStatistics != null) {
                imageDataVO.setMonthlyStatisticsVO(monthlyStatistics);
            }
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        if (ListUtil.isNotEmpty(xmyxglVOS)) {
            List ids = xmyxglVOS.stream().map(BaseVO::getId).collect(Collectors.toList());
            Map voMap = xmyxglVOS.stream().collect(Collectors.toMap(BaseVO::getId, Function.identity()));
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("sourceIds", ids);
            CommonResponse listCommonResponse = this.attachmentApi.queryAllBySourceIdList(jsonObject);
            if (listCommonResponse.isSuccess()) {
                List data = (List)listCommonResponse.getData();
                ArrayList pathData = new ArrayList();
                for (AttachmentVO attachmentVO : data) {
                    String suffix = attachmentVO.getFileName().substring(attachmentVO.getFileName().lastIndexOf(".") + 1);
                    if (!"jpg".equals(suffix) && !"png".equals(suffix)) continue;
                    HashMap<String, String> pathMap = new HashMap<String, String>();
                    pathMap.put("name", ((XmyxglVO)voMap.get(attachmentVO.getSourceId())).getYxmc());
                    pathMap.put("path", attachmentVO.getTruePath());
                    pathData.add(pathMap);
                }
                imageDataVO.setPathMap(pathData);
                imageDataVO.setXmyxglVOS(xmyxglVOS);
            }
        }
        return imageDataVO;
    }

    @Override
    public ImageDataVO queryAllImageData(Long projectId) {
        List<Object> xmyxglVOS = new ArrayList();
        ImageDataVO imageDataVO = new ImageDataVO();
        xmyxglVOS = this.projectOverViewMapper.queryAllImageData(projectId);
        if (ListUtil.isNotEmpty(xmyxglVOS)) {
            List ids = xmyxglVOS.stream().map(BaseVO::getId).collect(Collectors.toList());
            Map voMap = xmyxglVOS.stream().collect(Collectors.toMap(BaseVO::getId, Function.identity()));
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("sourceIds", ids);
            CommonResponse listCommonResponse = this.attachmentApi.queryAllBySourceIdList(jsonObject);
            if (listCommonResponse.isSuccess()) {
                List data = (List)listCommonResponse.getData();
                ArrayList pathData = new ArrayList();
                for (XmyxglVO xmyxglVO : xmyxglVOS) {
                    for (AttachmentVO attachmentVO : data) {
                        if (!xmyxglVO.getId().equals(attachmentVO.getSourceId())) continue;
                        this.logger.info("\u5f71\u50cfid{},\u56fe\u7247id{}", (Object)xmyxglVO.getId(), (Object)attachmentVO.getSourceId());
                        String suffix = attachmentVO.getFileName().substring(attachmentVO.getFileName().lastIndexOf(".") + 1);
                        if (!"jpg".equals(suffix) && !"png".equals(suffix)) continue;
                        HashMap<String, String> pathMap = new HashMap<String, String>();
                        pathMap.put("name", ((XmyxglVO)voMap.get(attachmentVO.getSourceId())).getYxmc());
                        pathMap.put("path", attachmentVO.getTruePath());
                        pathData.add(pathMap);
                    }
                }
                imageDataVO.setPathMap(pathData);
                imageDataVO.setXmyxglVOS(xmyxglVOS);
            }
        }
        return imageDataVO;
    }

    @Override
    public List<ImageListVO> queryImageList(Long projectId, String startDate, String endDate) {
        ArrayList<ImageListVO> imageListVOS = new ArrayList<ImageListVO>();
        List<String> monthBetweenDate = DifferentMonth.getMonthBetweenDate(startDate, endDate);
        for (String dateStr : monthBetweenDate) {
            ImageListVO imageListVO = new ImageListVO();
            Date date = null;
            List<Object> xmyxglVOS = new ArrayList();
            try {
                date = new SimpleDateFormat("yyyy-MM").parse(dateStr);
                Calendar ca = Calendar.getInstance();
                ca.setTime(date);
                int year = ca.get(1);
                int month = ca.get(2) + 1;
                xmyxglVOS = this.projectOverViewMapper.queryImageData(projectId, year, month);
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
            imageListVO.setDate(dateStr);
            if (ListUtil.isNotEmpty(xmyxglVOS)) {
                imageListVO.setCount(Integer.valueOf(xmyxglVOS.size()));
            } else {
                imageListVO.setCount(Integer.valueOf(0));
            }
            imageListVOS.add(imageListVO);
        }
        return imageListVOS;
    }

    @Override
    public LogDataVO queryLogInfo(Long projectId, Long orgId) {
        List<PersonVO> personLogVOS;
        LogDataVO logDataVO = new LogDataVO();
        ArrayList<Long> orgIds = new ArrayList<Long>();
        orgIds.add(orgId);
        CommonResponse userApiEmployeeList = this.userApi.getEmployeeList(orgId);
        if (userApiEmployeeList.isSuccess()) {
            List maps = (List)userApiEmployeeList.getData();
            HashSet<Long> userIds = new HashSet<Long>();
            HashSet postIds = new HashSet();
            for (Map map : maps) {
                if (!"1".equals(map.get("state").toString())) continue;
                if (map.get("userId") != null) {
                    userIds.add(Long.valueOf(map.get("userId").toString()));
                }
                if (map.get("postId") == null) continue;
                postIds.add(Long.valueOf(map.get("postId").toString()));
            }
            logDataVO.setPostNum(Integer.valueOf(postIds.size()));
            logDataVO.setUserNum(Integer.valueOf(userIds.size()));
            logDataVO.setUserPostNum(Integer.valueOf(maps.size()));
        }
        if (ListUtil.isNotEmpty(personLogVOS = this.projectOverViewMapper.queryPersonLog(projectId))) {
            logDataVO.setPersonLogTotalNum(Integer.valueOf(personLogVOS.size()));
            ArrayList<PersonVO> todayPersonLogVOS = new ArrayList<PersonVO>();
            for (PersonVO personLogVO : personLogVOS) {
                Date informantDate = personLogVO.getInformantDate();
                Calendar informantCalendar = Calendar.getInstance();
                informantCalendar.setTime(informantDate);
                Date date = new Date();
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(date);
                if (informantCalendar.get(1) != calendar.get(1) || informantCalendar.get(2) != calendar.get(2) || informantCalendar.get(5) != calendar.get(5)) continue;
                todayPersonLogVOS.add(personLogVO);
            }
            if (ListUtil.isNotEmpty(todayPersonLogVOS)) {
                logDataVO.setPersonLogTodayNum(Integer.valueOf(todayPersonLogVOS.size()));
            }
        } else {
            logDataVO.setPersonLogTotalNum(Integer.valueOf(0));
            logDataVO.setPersonLogTodayNum(Integer.valueOf(0));
        }
        List<ProjectLogVO> projectLogVOS = this.projectOverViewMapper.queryProjectLog(projectId, null);
        if (ListUtil.isNotEmpty(projectLogVOS)) {
            logDataVO.setProjectLogTotalNum(Integer.valueOf(projectLogVOS.size()));
        } else {
            logDataVO.setProjectLogTotalNum(Integer.valueOf(0));
        }
        ArrayList projectLogListMap = new ArrayList();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        int days = calendar.getActualMaximum(5);
        for (int i = 0; i < days; ++i) {
            Calendar monthDay = Calendar.getInstance();
            monthDay.set(calendar.get(1), calendar.get(2), i + 1);
            String formatDate = simpleDateFormat.format(monthDay.getTime());
            List<ProjectLogVO> toDayProjectLogVO = this.projectOverViewMapper.queryProjectLog(projectId, formatDate);
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("date", formatDate);
            if (ListUtil.isNotEmpty(toDayProjectLogVO)) {
                map.put("id", toDayProjectLogVO.get(0).getId().toString());
            } else {
                map.put("id", null);
            }
            projectLogListMap.add(map);
        }
        logDataVO.setProjectLogList(projectLogListMap);
        return logDataVO;
    }

    @Override
    public PlanDataVO queryPlanData(Long projectId) {
        Integer totalPlanData = this.projectOverViewMapper.queryTotalPlanData(projectId);
        Integer yearPlanData = this.projectOverViewMapper.queryYearPlanData(projectId);
        Integer monthPlanData = this.projectOverViewMapper.queryMonthPlanData(projectId);
        Integer weekPlanData = this.projectOverViewMapper.queryWeekPlanData(projectId);
        PlanDataVO planDataVO = new PlanDataVO();
        planDataVO.setTotalPlanNum(totalPlanData);
        planDataVO.setYearPlanNum(yearPlanData);
        planDataVO.setMonthPlanNum(monthPlanData);
        planDataVO.setWeekPlanNum(weekPlanData);
        return planDataVO;
    }

    @Override
    public List<UserInfoVO> queryUserInfo(Page<UserInfoVO> page, QueryParam param) {
        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper((QueryParam)param);
        return this.projectOverViewMapper.getUserInfoByProjectId(page, wrapper);
    }

    @Override
    public AchieveData queryAchieveData(Long projectId) {
        List<YjDetailVO> yjDetailVOS = this.projectOverViewMapper.queryYjDetailList(projectId);
        AchieveData achieveData = new AchieveData();
        if (ListUtil.isNotEmpty(yjDetailVOS)) {
            Map<String, Long> collect = yjDetailVOS.stream().collect(Collectors.groupingBy(YjDetailVO::getTags, Collectors.counting()));
            achieveData.setAchieveNumMap(collect);
        }
        return achieveData;
    }

    @Override
    public PaymentRegisterData queryPaymentRegisterData(Long projectId) {
        PaymentRegisterData paymentRegisterData = new PaymentRegisterData();
        CommonResponse subResponse = this.receiptAndPaymentRegisterApi.queryPayMnyByProjAndContType(projectId, ContractTypeEnum.\u52b3\u52a1\u5206\u5305\u5408\u540c.getTypeCode());
        if (subResponse.isSuccess()) {
            paymentRegisterData.setLaborSub(((JSONObject)subResponse.getData()).getBigDecimal("payMny"));
        }
        CommonResponse contractAC = this.receiptAndPaymentRegisterApi.queryPayMnyByProjAndContType(projectId, ContractTypeEnum.\u5b89\u62c6\u5408\u540c.getTypeCode());
        if (subResponse.isSuccess()) {
            paymentRegisterData.setContractAC(((JSONObject)contractAC.getData()).getBigDecimal("payMny"));
        }
        CommonResponse contractConcrete = this.receiptAndPaymentRegisterApi.queryPayMnyByProjAndContType(projectId, ContractTypeEnum.\u6df7\u51dd\u571f\u5408\u540c.getTypeCode());
        if (subResponse.isSuccess()) {
            paymentRegisterData.setContractConcrete(((JSONObject)contractConcrete.getData()).getBigDecimal("payMny"));
        }
        CommonResponse contractMaterial = this.receiptAndPaymentRegisterApi.queryPayMnyByProjAndContType(projectId, ContractTypeEnum.\u7269\u8d44\u91c7\u8d2d\u5408\u540c.getTypeCode());
        if (subResponse.isSuccess()) {
            paymentRegisterData.setContractMaterial(((JSONObject)contractMaterial.getData()).getBigDecimal("payMny"));
        }
        CommonResponse contractOther = this.receiptAndPaymentRegisterApi.queryPayMnyByProjAndContType(projectId, ContractTypeEnum.\u5176\u4ed6\u652f\u51fa.getTypeCode());
        if (subResponse.isSuccess()) {
            paymentRegisterData.setContractOther(((JSONObject)contractOther.getData()).getBigDecimal("payMny"));
        }
        CommonResponse equipmentPurchase = this.receiptAndPaymentRegisterApi.queryPayMnyByProjAndContType(projectId, ContractTypeEnum.\u8bbe\u5907\u91c7\u8d2d.getTypeCode());
        if (subResponse.isSuccess()) {
            paymentRegisterData.setEquipmentPurchase(((JSONObject)equipmentPurchase.getData()).getBigDecimal("payMny"));
        }
        CommonResponse equipmentRent = this.receiptAndPaymentRegisterApi.queryPayMnyByProjAndContType(projectId, ContractTypeEnum.\u8bbe\u5907\u79df\u8d41.getTypeCode());
        if (subResponse.isSuccess()) {
            paymentRegisterData.setEquipmentRent(((JSONObject)equipmentRent.getData()).getBigDecimal("payMny"));
        }
        CommonResponse equipmentTemp = this.receiptAndPaymentRegisterApi.queryPayMnyByProjAndContType(projectId, ContractTypeEnum.\u4e34\u65f6\u8bbe\u5907.getTypeCode());
        if (subResponse.isSuccess()) {
            paymentRegisterData.setEquipmentTemp(((JSONObject)equipmentTemp.getData()).getBigDecimal("payMny"));
        }
        CommonResponse proSub = this.receiptAndPaymentRegisterApi.queryPayMnyByProjAndContType(projectId, ContractTypeEnum.\u4e13\u4e1a\u5206\u5305\u5408\u540c.getTypeCode());
        if (subResponse.isSuccess()) {
            paymentRegisterData.setProSub(((JSONObject)proSub.getData()).getBigDecimal("payMny"));
        }
        CommonResponse rmat = this.receiptAndPaymentRegisterApi.queryPayMnyByProjAndContType(projectId, ContractTypeEnum.\u5468\u8f6c\u6750\u5408\u540c.getTypeCode());
        if (subResponse.isSuccess()) {
            paymentRegisterData.setRmat(((JSONObject)rmat.getData()).getBigDecimal("payMny"));
        }
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("projectId", new Parameter("eq", (Object)projectId));
        queryParam.getParams().put("billState", new Parameter("in", Arrays.asList(1, 3)));
        CommonResponse mny = this.receiptAndPaymentRegisterApi.queryReceiptAndPaymentMny(queryParam);
        if (mny.isSuccess()) {
            JSONObject mnyData = (JSONObject)mny.getData();
            paymentRegisterData.setTotalPayment(mnyData.getBigDecimal("payMny"));
            paymentRegisterData.setTotalReceive(mnyData.getBigDecimal("sumReceivedMny"));
        }
        return paymentRegisterData;
    }

    @Override
    public Map<String, String> queryStartDate(Long projectId) {
        HashMap<String, String> map = new HashMap<String, String>();
        ProjectSetEntity projectSetEntity = (ProjectSetEntity)((Object)this.projectSetService.selectById(projectId));
        TotalPlanVO totalPlanVO = this.projectOverViewMapper.queryTotalPlanVO(projectId);
        Date trueStartDate = projectSetEntity.getStartWorkDate() != null ? projectSetEntity.getStartWorkDate() : projectSetEntity.getTrueStartDate();
        Date nowDate = new Date();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        if (trueStartDate != null) {
            map.put("trueStartDate", sdf.format(trueStartDate));
            int trueDays = DateUtil.daysBetween((Date)trueStartDate, (Date)nowDate);
            map.put("trueDays", trueDays + "");
        }
        if (totalPlanVO != null) {
            map.put("planBeginDate", sdf.format(totalPlanVO.getPlanBeginDate()));
            map.put("planEndDate", sdf.format(totalPlanVO.getPlanEndDate()));
            int totalDays = DateUtil.daysBetween((Date)totalPlanVO.getPlanBeginDate(), (Date)totalPlanVO.getPlanEndDate());
            int planDays = DateUtil.daysBetween((Date)totalPlanVO.getPlanBeginDate(), (Date)nowDate);
            map.put("totalDays", totalDays + "");
            map.put("planDays", planDays + "");
            map.put("finishFlag", totalPlanVO.getFinishFlag() != null ? totalPlanVO.getFinishFlag().toString() : "");
        }
        return map;
    }

    @Override
    public RectificationVO queryRectificationData(Long projectId) {
        List<RectificationRepeatVO> repeatVOS;
        List<RectificationNoticeVO> noticeVOS = this.projectOverViewMapper.queryNoticeList(projectId);
        RectificationVO rectificationVO = new RectificationVO();
        if (ListUtil.isNotEmpty(noticeVOS)) {
            rectificationVO.setQualityNoticeNum(Long.valueOf(noticeVOS.stream().filter(s -> s.getRectificationType().equals("1")).count()));
            rectificationVO.setSafeNoticeNum(Long.valueOf(noticeVOS.stream().filter(s -> s.getRectificationType().equals("2")).count()));
        }
        if (ListUtil.isNotEmpty(repeatVOS = this.projectOverViewMapper.queryRepeatList(projectId))) {
            rectificationVO.setQualityRepeatNum(Long.valueOf(repeatVOS.stream().filter(s -> s.getRectificationType().equals("1")).count()));
            rectificationVO.setSafeRepeatNum(Long.valueOf(repeatVOS.stream().filter(s -> s.getRectificationType().equals("2") && s.getRepeatStatus().equals("2")).count()));
        }
        return rectificationVO;
    }

    @Override
    public Map<String, Object> queryProjectRelateInfo(Long projectId) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        List<ProjectInfoRegisterVO> registerVOS = this.projectOverViewMapper.queryProjectInfoRegisterList(projectId);
        List<Long> ids = registerVOS.stream().map(BaseVO::getId).collect(Collectors.toList());
        if (ListUtil.isNotEmpty(ids)) {
            List<ProjectInfoRegisterExamineVO> examineVOS = this.projectOverViewMapper.queryProjectInfoExamineList(ids);
            List<ProjectInfoRegisterDisputeVO> disputeVOS = this.projectOverViewMapper.queryProjectInfoDisputeList(ids);
            List<ProjectInfoRegisterCommunicationVO> communicationVOS = this.projectOverViewMapper.queryProjectInfoCommunicationList(ids);
            long examineNoticeNum = examineVOS.stream().filter(s -> "1".equals(s.getExamineState())).count();
            long examineRepeatNum = examineVOS.stream().filter(s -> "1".equals(s.getExamineState()) && "\u7ed3\u675f".equals(s.getTreatmentProgress())).count();
            long communicationEnd = communicationVOS.stream().filter(s -> "\u7ed3\u675f".equals(s.getComplaintProgress())).count();
            map.put("relateNoticeNum", examineNoticeNum + (long)communicationVOS.size());
            map.put("relateRepeatNum", examineRepeatNum + communicationEnd);
            long examineEnd = examineVOS.stream().filter(s -> "\u7ed3\u675f".equals(s.getTreatmentProgress())).count();
            long disputeEnd = disputeVOS.stream().filter(s -> "\u7ed3\u675f".equals(s.getDisputeProgress())).count();
            long relateTotalRepeatNum = examineEnd + disputeEnd + communicationEnd;
            long relateTotalNoticeNum = examineVOS.size() + disputeVOS.size() + communicationVOS.size();
            map.put("relateTotalNoticeNum", relateTotalNoticeNum - relateTotalRepeatNum);
            map.put("relateTotalRepeatNum", relateTotalRepeatNum);
        }
        return map;
    }

    @Override
    public RiskAssessLatestVO queryProjectRiskLevel(Long projectId) {
        Long indexId = 700358634707755064L;
        RiskAssessLatestVO latestVO = this.projectOverViewMapper.queryProjectRiskLevel(projectId, indexId);
        return latestVO;
    }

    @Override
    public Map<String, String> queryDangerProjectData(Long projectId) {
        List<DangerProjectVO> dangerProjectList = this.projectOverViewMapper.getDangerProjectList(projectId);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("totalDangerNum", "0");
        map.put("finishDangerNum", "0");
        if (ListUtil.isNotEmpty(dangerProjectList)) {
            long finishDangerNum = dangerProjectList.stream().filter(s -> "1".equals(s.getIsFinish())).count();
            map.put("totalDangerNum", dangerProjectList.size() + "");
            map.put("finishDangerNum", Long.toString(finishDangerNum));
            long otherDangerNum = dangerProjectList.stream().filter(s -> "2".equals(s.getIsFinish()) && s.getEstimateImplDate().before(new Date())).count();
            map.put("otherDangerNum", Long.toString(otherDangerNum));
        }
        return map;
    }

    @Override
    public Map<String, String> querySettleData(Long projectId) {
        List<com.ejianc.business.settle.vo.SettleVO> laborSubSettleList = this.projectOverViewMapper.queryLaborSubSettle(projectId, null);
        List progressSettleList = laborSubSettleList.stream().filter(s -> s.getSettleType() == 0).collect(Collectors.toList());
        List nodeSettleList = laborSubSettleList.stream().filter(s -> s.getSettleType() == 2).collect(Collectors.toList());
        List finalSettleList = laborSubSettleList.stream().filter(s -> s.getSettleType() == 1).collect(Collectors.toList());
        List<SettlementVO> materialSettleList = this.projectOverViewMapper.queryMaterialSettle(projectId, null);
        List materialProgressSettleList = materialSettleList.stream().filter(s -> s.getSignatureType() == 0 && s.getSettlementType() == 0).collect(Collectors.toList());
        List materialFinalSettleList = materialSettleList.stream().filter(s -> s.getSignatureType() == 1 && s.getSettlementType() == 0).collect(Collectors.toList());
        List concreteProgressSettleList = materialSettleList.stream().filter(s -> s.getSignatureType() == 0 && s.getSettlementType() == 1).collect(Collectors.toList());
        List concreteFinalSettleList = materialSettleList.stream().filter(s -> s.getSignatureType() == 1 && s.getSettlementType() == 1).collect(Collectors.toList());
        List<SettleVO> rmatSettleList = this.projectOverViewMapper.queryRmatSettle(projectId, null);
        List rmatProgressSettleList = rmatSettleList.stream().filter(s -> "0".equals(s.getSettleType())).collect(Collectors.toList());
        List rmatFinalSettleList = rmatSettleList.stream().filter(s -> "1".equals(s.getSettleType())).collect(Collectors.toList());
        HashMap<String, String> map = new HashMap<String, String>();
        BigDecimal laborSettleTaxMny = laborSubSettleList.stream().filter(s -> s.getTaxMny() != null).map(com.ejianc.business.settle.vo.SettleVO::getTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal materialTaxMny = materialSettleList.stream().filter(s -> s.getSettlementTaxMny() != null).map(SettlementVO::getSettlementTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal rmatTaxMny = rmatSettleList.stream().filter(s -> s.getSettleTaxMny() != null).map(SettleVO::getSettleTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);
        map.put("progressSettleNum", progressSettleList.size() + "");
        map.put("nodeSettleNum", nodeSettleList.size() + "");
        map.put("finalSettleNum", finalSettleList.size() + "");
        map.put("laborSettleTaxMny", laborSettleTaxMny.toString());
        map.put("materialProgressSettleNum", materialProgressSettleList.size() + "");
        map.put("materialFinalSettleNum", materialFinalSettleList.size() + "");
        map.put("materialTaxMny", materialTaxMny.toString());
        map.put("concreteProgressSettleNum", concreteProgressSettleList.size() + "");
        map.put("concreteFinalSettleNum", concreteFinalSettleList.size() + "");
        map.put("rmatProgressSettleNum", rmatProgressSettleList.size() + "");
        map.put("rmatFinalSettleNum", rmatFinalSettleList.size() + "");
        map.put("rmatTaxMny", rmatTaxMny.toString());
        return map;
    }

    @Override
    public List<MonthlyStatisticsVO> getStatisticsByOrgIdUnder(QueryParam param) {
        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper((QueryParam)param);
        return this.projectOverViewMapper.getStatisticsByOrgIdUnder(wrapper);
    }

    @Override
    public List<PracticeVO> getPracticeList(QueryParam param) {
        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper((QueryParam)param);
        return this.projectOverViewMapper.getPracticeList(wrapper);
    }
}

