package com.ejianc.business.market.controller;

import java.io.Serializable;

import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.authc.Account;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.market.bean.VwProjectClearEntity;
import com.ejianc.business.market.service.IVwProjectClearService;
import com.ejianc.business.market.vo.VwProjectClearVO;

/**
 * 清欠台账
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("vwProjectClear")
public class VwProjectClearController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "Invoice_Open_Apply_Code";//此处需要根据实际修改

    @Autowired
    private IVwProjectClearService service;

    @Autowired
    private SessionManager sessionManager;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<VwProjectClearVO> saveOrUpdate(@RequestBody VwProjectClearVO saveOrUpdateVO) {
    	VwProjectClearEntity entity = BeanMapper.map(saveOrUpdateVO, VwProjectClearEntity.class);
    	service.saveOrUpdate(entity, false);
    	VwProjectClearVO vo = BeanMapper.map(entity, VwProjectClearVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<VwProjectClearVO> queryDetail(Long id) {
    	VwProjectClearEntity entity = service.selectById(id);
    	VwProjectClearVO vo = BeanMapper.map(entity, VwProjectClearVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<VwProjectClearVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (VwProjectClearVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(VwProjectClearVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<VwProjectClearVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("name");
        param.getParams().put("projectDepartmentId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));


        IPage<VwProjectClearEntity> page = service.queryPage(param,false);
        IPage<VwProjectClearVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), VwProjectClearVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.setPageIndex(1);
        param.setPageSize(-1);
        fuzzyFields.add("name");
        param.getParams().put("projectDepartmentId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<VwProjectClearEntity> list = service.queryList(param);
        List<VwProjectClearVO> vwProjectClearVOS = BeanMapper.mapList(list, VwProjectClearVO.class);
        List<Long> collect = vwProjectClearVOS.stream().map(VwProjectClearVO::getOrgId).collect(Collectors.toList());
        List<OrgVO> orgList = new ArrayList<>();
        CommonResponse<List<OrgVO>> allByIds = iOrgApi.findAllByIds(collect);
        if (allByIds.getCode() == 0){
            orgList = allByIds.getData();
        }
        Map<Long, OrgVO> orgMap = orgList.stream().collect(Collectors.toMap(OrgVO::getId, Function.identity(), (v1, v2) -> v2));

        for (VwProjectClearVO vwProjectClearVO : vwProjectClearVOS) {
            if(vwProjectClearVO.getSettleStatus() != null){
                switch (vwProjectClearVO.getSettleStatus()){
                    case "1" :
                        vwProjectClearVO.setSettleStatus("未结算");
                        break;
                    case "8" :
                        vwProjectClearVO.setSettleStatus("结算中");
                        break;
                    case "9" :
                        vwProjectClearVO.setSettleStatus("已结算");
                        break;
                    default:break;
                }
            }
            if(vwProjectClearVO.getBusinessStatus() != null){
                switch (vwProjectClearVO.getBusinessStatus()){
                    case "1" :
                        vwProjectClearVO.setBusinessStatus("未开工");
                        break;
                    case "2" :
                        vwProjectClearVO.setBusinessStatus("在施");
                        break;
                    case "3" :
                        vwProjectClearVO.setBusinessStatus("停工");
                        break;
                    case "4" :
                        vwProjectClearVO.setBusinessStatus("项目中止");
                        break;
                    case "5" :
                        vwProjectClearVO.setBusinessStatus("待竣工");
                        break;
                    case "6" :
                        vwProjectClearVO.setBusinessStatus("竣工");
                        break;
                    default:break;
                }

            }


            if (vwProjectClearVO.getEngineeringTypeId() != null ){
                if (vwProjectClearVO.getEngineeringTypeId().equals(1463764758564966402L)) {
                    vwProjectClearVO.setEngineeringTypeName("房屋建筑");
                }else if (vwProjectClearVO.getEngineeringTypeId().equals(1463768014330531841L)) {
                    vwProjectClearVO.setEngineeringTypeName("市政公用工程");
                }else if (vwProjectClearVO.getEngineeringTypeId().equals(1463768241259155457L)) {
                    vwProjectClearVO.setEngineeringTypeName("钢结构工程");
                }else if (vwProjectClearVO.getEngineeringTypeId().equals(1463768346460688385L)) {
                    vwProjectClearVO.setEngineeringTypeName("装饰装修工程");
                }else if (vwProjectClearVO.getEngineeringTypeId().equals(1463768455256739841L)) {
                    vwProjectClearVO.setEngineeringTypeName("幕墙工程");
                }else if (vwProjectClearVO.getEngineeringTypeId().equals(1463768566862974977L)) {
                    vwProjectClearVO.setEngineeringTypeName("机电设备消防设施工程");
                }else if (vwProjectClearVO.getEngineeringTypeId().equals(1463768666855182337L)) {
                    vwProjectClearVO.setEngineeringTypeName("地基与基础工程");
                }else if (vwProjectClearVO.getEngineeringTypeId().equals(1463768830231711745L)) {
                    vwProjectClearVO.setEngineeringTypeName("体育场地设施工程");
                }else if (vwProjectClearVO.getEngineeringTypeId().equals(1463768945726066689L)) {
                    vwProjectClearVO.setEngineeringTypeName("公路工程");
                }else if (vwProjectClearVO.getEngineeringTypeId().equals(1463769013942226945L)) {
                    vwProjectClearVO.setEngineeringTypeName("其他");
                }else if (vwProjectClearVO.getEngineeringTypeId().equals(1505831791156957185L)) {
                    vwProjectClearVO.setEngineeringTypeName("房屋建筑（住宅）");
                }else if (vwProjectClearVO.getEngineeringTypeId().equals(1505831871188471810L)) {
                    vwProjectClearVO.setEngineeringTypeName("房屋建筑（工业）");
                }else if (vwProjectClearVO.getEngineeringTypeId().equals(1505831928449110017L)) {
                    vwProjectClearVO.setEngineeringTypeName("房屋建筑（公共建筑）");
                }else if (vwProjectClearVO.getEngineeringTypeId().equals(1505832413738471426L)) {
                    vwProjectClearVO.setEngineeringTypeName("城市轨道交通");
                }else if (vwProjectClearVO.getEngineeringTypeId().equals(1505832481837191170L)) {
                    vwProjectClearVO.setEngineeringTypeName("市政其它");
                }else if (vwProjectClearVO.getEngineeringTypeId().equals(1505832272163934210L)) {
                    vwProjectClearVO.setEngineeringTypeName("市政道路");
                }else if (vwProjectClearVO.getEngineeringTypeId().equals(1505832338534600706L)) {
                    vwProjectClearVO.setEngineeringTypeName("市政桥梁");
                }
            }

            if (orgMap.containsKey(vwProjectClearVO.getOrgId())){
                vwProjectClearVO.setOrgCode(orgMap.get(vwProjectClearVO.getOrgId()).getCode());
            }
        }
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", vwProjectClearVOS);
        ExcelExport.getInstance().export("VwProjectClear-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param
     * @Return void
     */
    @RequestMapping(value = "/refVwProjectClearData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<VwProjectClearVO>> refVwProjectClearData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<VwProjectClearEntity> page = service.queryPage(param,false);
        IPage<VwProjectClearVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), VwProjectClearVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }
}
