package com.ejianc.business.market.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.constructor.vo.NbzzFollowVO;
import com.ejianc.business.market.controller.CloseCostController;
import com.ejianc.business.market.service.IAdjustApplicationService;
import com.ejianc.business.market.service.ICloseCostService;
import com.ejianc.business.market.vo.CloseCostReportVO;
import com.ejianc.business.market.vo.CostDesktopDTO;
import com.ejianc.business.market.vo.CostDesktopVO;
import com.ejianc.business.market.vo.ProjectSetVO;
import com.ejianc.business.project.vo.ProjectAddressVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.api.IProjectSetApi;
import com.ejianc.foundation.share.vo.ProjectPoolSetVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.collections.CollectionUtils;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.market.mapper.ProjectSetMapper;
import com.ejianc.business.market.bean.ProjectSetEntity;
import com.ejianc.business.market.service.IProjectSetService;

import java.io.IOException;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 项目立项
 *
 * @author generator
 *
 */
@Service("projectSetService")
public class ProjectSetServiceImpl extends BaseServiceImpl<ProjectSetMapper, ProjectSetEntity> implements IProjectSetService{

    @Autowired
    private IProjectSetApi iProjectSetApi;

    @Autowired
    private IOrgApi orgApi;

    @Autowired
    private IProjectSetService service;
//    @Autowired
//    private CloseCostController closeCostController;

    @Autowired
    private IAdjustApplicationService adjustApplicationService;

    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private ICloseCostService closeCostService;

    @Override
    public CommonResponse<String> pushProjectPoolSet(ProjectSetEntity projectSetEntity, String billTypeCode) {

        ProjectSetVO projectSetVO = BeanMapper.map(projectSetEntity, ProjectSetVO.class);

        //项目部
        OrgVO projectDepartment = null;
        if(null == projectSetVO.getProjectDepartmentId()) {
            //创建项目部
//            projectDepartment = generateProjectDepartment(projectSetVO, true);
//            projectSetEntity.setProjectDepartmentId(projectDepartment.getId());
//            projectSetEntity.setProjectDepartmentName(projectDepartment.getName());
            throw new BusinessException("提交项目信息失败，保存项目部信息出错！");

        }else {
            projectDepartment = orgApi.getOneById(projectSetVO.getProjectDepartmentId()).getData();
            if(projectDepartment!=null){
                projectDepartment.setProjectCode(projectSetVO.getCode());
                projectDepartment.setProjectState(1);
            }
        }

        //保存更新项目部信息
        if(null != projectDepartment) {
            CommonResponse<OrgVO> resp = orgApi.saveOrgInfo(projectDepartment);
            if(!resp.isSuccess()) {
                throw new BusinessException("提交项目信息失败，保存项目部信息出错: " + resp.getMsg());
            }
        }
        service.saveOrUpdate(projectSetEntity, false);
        ProjectPoolSetVO projectPoolSetVO = BeanMapper.map(projectSetEntity, ProjectPoolSetVO.class);
        logger.info("推送项目池信息为{}",projectPoolSetVO);
        return iProjectSetApi.pushProjectPoolSetNoInitial(JSONObject.toJSONString(projectPoolSetVO).getBytes(StandardCharsets.UTF_8));
    }

    @Override
    public CommonResponse<String> pushProjectPoolSetNoInitial(ProjectSetEntity projectSetEntity, String billTypeCode) {
        ProjectSetVO projectSetVO = BeanMapper.map(projectSetEntity, ProjectSetVO.class);

        //项目部
        OrgVO projectDepartment = null;
        if(null == projectSetVO.getProjectDepartmentId()) {
//            //创建项目部
//            projectDepartment = generateProjectDepartment(projectSetVO, true);
//            projectSetEntity.setProjectDepartmentId(projectDepartment.getId());
//            projectSetEntity.setProjectDepartmentName(projectDepartment.getName());
            throw new BusinessException("提交项目信息失败，保存项目部信息出错！");


        }else {
            projectDepartment = orgApi.getOneById(projectSetVO.getProjectDepartmentId()).getData();
            if(projectDepartment!=null){
                projectDepartment.setProjectCode(projectSetVO.getCode());
                projectDepartment.setProjectState(1);
            }
        }

        //保存更新项目部信息
        if(null != projectDepartment) {
            CommonResponse<OrgVO> resp = orgApi.saveOrgInfo(projectDepartment);
            if(!resp.isSuccess()) {
                throw new BusinessException("提交项目信息失败，保存项目部信息出错: " + resp.getMsg());
            }
        }
        service.saveOrUpdate(projectSetEntity, false);
        ProjectPoolSetVO projectPoolSetVO = BeanMapper.map(projectSetEntity, ProjectPoolSetVO.class);
        logger.info("推送项目池信息为{}",projectPoolSetVO);
        return iProjectSetApi.pushProjectPoolSetNoInitial(JSONObject.toJSONString(projectPoolSetVO).getBytes(StandardCharsets.UTF_8));

    }

    @Override
    public CommonResponse<List<ProjectAddressVO>> queryProjectAddress(QueryParam param, String year) {
        param.getParams().put("billState", new Parameter(QueryParam.IN, "1,3"));// 生效
        List<ProjectSetEntity> list = service.queryList(param);
        List<ProjectAddressVO> projectAddressVOList = new ArrayList<>();
        if (CollectionUtils.isNotEmpty(list)){
            projectAddressVOList = BeanMapper.mapList(list, ProjectAddressVO.class);
        }
        return CommonResponse.success("查询项目地图分布数据成功！", projectAddressVOList);
    }

    @Override
    public CostDesktopVO queryProjectNumCostDesktop() {

        /**
         * 待竣工、竣工、成本关门个数，成本关门归档个数，饼状图利润率信息,近半年年亏损、累计亏损
         */
        CostDesktopVO costDesktopVO = baseMapper.queryProjectNumCostDesktop();

        /**
         * 成本关门利润率饼图
         */
        //房建
        ArrayList<CostDesktopDTO> fjList = new ArrayList<>();
        //市政
        ArrayList<CostDesktopDTO> szList = new ArrayList<>();
        //其他
        ArrayList<CostDesktopDTO> qtList = new ArrayList<>();
        fjList.add(new CostDesktopDTO("12%以上",0));
        szList.add(new CostDesktopDTO("12%以上",0));
        qtList.add(new CostDesktopDTO("12%以上",0));
        fjList.add(new CostDesktopDTO("8%-12%",0));
        szList.add(new CostDesktopDTO("8%-12%",0));
        qtList.add(new CostDesktopDTO("8%-12%",0));
        fjList.add(new CostDesktopDTO("5%-8%",0));
        szList.add(new CostDesktopDTO("5%-8%",0));
        qtList.add(new CostDesktopDTO("5%-8%",0));
        fjList.add(new CostDesktopDTO("3%-5%",0));
        szList.add(new CostDesktopDTO("3%-5%",0));
        qtList.add(new CostDesktopDTO("3%-5%",0));
        fjList.add(new CostDesktopDTO("0%-3%",0));
        szList.add(new CostDesktopDTO("0%-3%",0));
        qtList.add(new CostDesktopDTO("0%-3%",0));
        fjList.add(new CostDesktopDTO("0%以下",0));
        szList.add(new CostDesktopDTO("0%以下",0));
        qtList.add(new CostDesktopDTO("0%以下",0));
        //暂时先查询500条，每年关门项目<10个
        QueryParam param1 = new QueryParam();param1.setPageSize(1000);param1.setPageIndex(1);
//        CommonResponse<Page<CloseCostReportVO>> pageCommonResponse = closeCostController.queryReportList(param1);
        Page<CloseCostReportVO> closeCostReportVOPage = closeCostService.queryReportList(param1);
//        if (pageCommonResponse.getCode() == 0){
        if (ListUtil.isNotEmpty(closeCostReportVOPage.getRecords())){

            //近半年年亏损、累计亏损
            int ksHalfYear = 0;
            //累计亏损ago
            int  ksAll = 0;
            long time180DayAgo = System.currentTimeMillis() - (1000 * 60 * 60 * 24 * 180);

            List<CloseCostReportVO> records = closeCostReportVOPage.getRecords();
            for (CloseCostReportVO record : records) {

//
//                /**
//                 * 利润率动态取值
//                 */
//                BigDecimal proProFitPer = BigDecimal.ZERO;
//                //直接费总额
//                BigDecimal totalPayDirectFees = BigDecimal.ZERO;
//
//
//                //1、预计总支出 = 直接费总额+预计间接费、税金总支出
//                List<JSONObject> exContractt = this.queryESContract(record.getProjectId(), "ex_contractt");
//                for (JSONObject jsonObject : exContractt) {
//                    //累计结算金额
//                    BigDecimal sumsettleMny = jsonObject.getBigDecimal("sumsettleMny");
//                    totalPayDirectFees = totalPayDirectFees.add(sumsettleMny);
//                }
//                if(totalPayDirectFees != null && record.getTotalEstimatedIndirectTaxMny() != null){
//                    record.setTotalEstimatedPayMny(totalPayDirectFees.add(record.getTotalEstimatedIndirectTaxMny()));
//                }
//
//
//
//                //2、盈亏金额 = 施工合同总额（万元） - 预计总支出
//                if(record.getNicContractMny() != null && record.getTotalEstimatedPayMny() != null){
//                    record.setProProFit(record.getNicContractMny().subtract(record.getTotalEstimatedPayMny()));
//                }
//
//
//                //3、利润率 = 盈亏金额 / 施工合同总额（万元）
//                if(record.getNicContractMny() != null && record.getProProFit() != null){
//                    proProFitPer = record.getNicContractMny().divide(record.getProProFit(),2, BigDecimal.ROUND_HALF_UP)
//                    record.setProProFitPer(proProFitPer);
//                }


                //判断利润率范围
                int index = -1;
                if (record.getProProfitPer().compareTo(new BigDecimal(0)) > -1){//大于等于0
                    if (record.getProProfitPer().compareTo(new BigDecimal(3)) > -1){//大于等于3
                        if (record.getProProfitPer().compareTo(new BigDecimal(5)) > -1){//大于等于5
                            if (record.getProProfitPer().compareTo(new BigDecimal(8)) > -1){//大于等于8
                                if (record.getProProfitPer().compareTo(new BigDecimal(12)) > -1){//大于等于12
                                    index = 0;
                                }else {
                                    index = 1;
                                }
                            }else {
                                index = 2;
                            }
                        }else {
                            index = 3;
                        }
                    }else {
                        index = 4;
                    }
                }else {
                    index = 5;

                    //根据时间判断是不是近半年
                    if (record.getCloseDate().getTime() > time180DayAgo){
                        ksHalfYear++;
                        CostDesktopDTO costDesktopDTO = new CostDesktopDTO();
                        costDesktopDTO.setId(record.getId());
                        costDesktopDTO.setName(record.getProjectName());
                        costDesktopDTO.setProProFit(record.getProProfit());
                        costDesktopDTO.setProProFitPer(record.getProProfitPer());
                        costDesktopVO.getKsHalfYearList().add(costDesktopDTO);
                    }
                    ksAll++;
                }
                //
                if (record.getEngineeringTypeName().contains("房屋建筑")){
                    fjList.get(index).setValue(fjList.get(index).getValue()+1);
                }else if (record.getEngineeringTypeName().contains("市政") || "城市轨道交通".equals(record.getEngineeringTypeName())){
                    szList.get(index).setValue(szList.get(index).getValue()+1);
                }else {
                    qtList.get(index).setValue(qtList.get(index).getValue()+1);
                }
            }

            costDesktopVO.setKsAll(ksAll);
            costDesktopVO.setKsHalfYear(ksHalfYear);
        }


        costDesktopVO.setFjList(fjList);
        costDesktopVO.setSzList(szList);
        costDesktopVO.setQtList(qtList);
        /**
         *
         */

        List<CostDesktopDTO> costDesktopDTOS = adjustApplicationService.queryFinishWorkBill();
        costDesktopVO.setFinishWorkList(costDesktopDTOS);
        return costDesktopVO;
    }

    /**
     * 生成项目对应的项目部信息
     *
     * @param
     * @return
     */
    private OrgVO generateProjectDepartment(ProjectSetVO projectSetVO, boolean isSyncProject) {
        if(projectSetVO.getOrgId() == null) {
            throw new BusinessException("提交项目信息失败，项目所属组织信息不存在。");
        }
        CommonResponse<OrgVO> response = orgApi.getOneById(projectSetVO.getOrgId());
        OrgVO parentOrg = null;
        if(response.isSuccess()) {
            parentOrg = response.getData();
        } else {
            throw new BusinessException("提交项目信息失败，查询项目所属组织信息失败: " + response.getMsg() );
        }
        if(null == parentOrg) {
            throw new BusinessException("提交项目信息失败，项目所属组织信息不存在。");
        }
        OrgVO projectDepartment = new OrgVO();
        /** 先根据项目名称查询组织项目部 */
        OrgVO paramVo = new OrgVO();
        paramVo.setName(projectSetVO.getName());
        paramVo.setOrgType(5);
        paramVo.setTenantId(InvocationInfoProxy.getTenantid());
        response = orgApi.findOneByOrgVO(paramVo);
        if(response.isSuccess()) {
            if(response.getData()!=null){
                projectDepartment = response.getData();
            }else {
                projectDepartment.setId(IdWorker.getId());
                projectDepartment.setTenantId(parentOrg.getTenantId());
                projectDepartment.setName(projectSetVO.getName());
                projectDepartment.setShortName(projectSetVO.getShortName());
                projectDepartment.setState(1);
                //项目部类型
                projectDepartment.setOrgType(OrgVO.ORG_TYPE_DEPARTMENT);
            }
            projectDepartment.setIsParent(false);
            projectDepartment.setProjectCode(projectSetVO.getCode());
            projectDepartment.setEnterpriseId(parentOrg.getEnterpriseId());
            projectDepartment.setParentId(projectSetVO.getOrgId());
            projectDepartment.setProjectState(1);
        } else {
            throw new BusinessException("提交项目信息失败，根据项目名称查询对应组织信息失败: " + response.getMsg() );
        }
        return projectDepartment;
    }
//    public List<JSONObject> queryESContract(Long projectId, String index) {
//        JSONObject result = new JSONObject();
//        List<JSONObject> resultList = new ArrayList<>();
//        //1.获取索引库
//        SearchRequest searchRequest = new SearchRequest(index);
//        //2.构建查询条件
//        SearchSourceBuilder sourceBuilder = new SearchSourceBuilder();
//        //TODO 可以根据更多条件去查询
//        //3.放入查询请求中
//        if (INDEX_EX_CONTRACTT.equals(index)) {
//            sourceBuilder.query(QueryBuilders.termQuery("projectId", projectId));
//        } else if (INDEX_srSGHTTZYL.equals(index)) {
//            sourceBuilder.query(QueryBuilders.termQuery("pId", projectId));
//        }
//        searchRequest.source(sourceBuilder);
//        searchRequest.source().size(1000);
//        logger.info("打印查询参数   sourceBuilder------------------：" + JSON.toJSONString(sourceBuilder));
//        //4.发送查询请求
//        try {
//            //查询及转换
//            SearchResponse response = client.search(searchRequest, RequestOptions.DEFAULT);
//            logger.info("打印请求参数  searchRequest------------------：", searchRequest);
//
//            SearchHits hits = response.getHits();
//            for (SearchHit hit : hits) {
//                String sourceAsString = hit.getSourceAsString();
//                logger.info("----------------ES获取数据为--------------：{}", sourceAsString);
//                result = JSON.parseObject(sourceAsString);
//                if (result.getBigDecimal("lu:yueqianfujine") != null) {
//                    result.put("luyueqianfujine", result.getBigDecimal("lu:yueqianfujine"));
//                }
//                resultList.add(result);
//            }
//            //TODO 如需要可对数据进行二次加工处理
//
//        } catch (IOException e) {
//            logger.error(e.getMessage());
//            throw new BusinessException("根据查询条件，查询全部记录索引失败，MSG：" + e.getMessage());
//        }
//        return resultList;
//    }


    @Override
    public List<NbzzFollowVO> queryFollowListByProjectId(Long projectId) {
        return baseMapper.queryFollowListByProjectId(projectId);
    }

    public static void main(String[] args) {
        long l = System.currentTimeMillis();
        long l1 = l - (1000 * 60 * 60 * 24 * 180);
        long time = new Date().getTime();
        System.out.println(l);
        System.out.println(l1);
        System.out.println(time);
    }
}
