package com.ejianc.business.market.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.constructor.api.IZjllApi;
import com.ejianc.business.market.bean.*;
import com.ejianc.business.market.service.*;
import com.ejianc.business.market.vo.CompletionWorkReportVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 竣工报告
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("completionWorkReport")
@Api(value = "竣工报告", tags = {"竣工报告"})
public class CompletionWorkReportController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "CompletionWorkReport";//此处需要根据实际修改

    @Autowired
    private ICompletionWorkReportService service;
    @Autowired
    private IFinishWorkReportService finishWorkReportService;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IResumeWorkReportService resumeWorkReportService;
    @Autowired
    private IStopWorkReportService stopWorkReportService;
    @Autowired
    private IStartWorkReportService startWorkReportService;
    @Autowired
    private IZjllApi zjllApi;

    @ApiOperation("新增或者修改")
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<CompletionWorkReportVO> saveOrUpdate(@ApiParam(name="saveOrUpdateVO", required=true) @RequestBody CompletionWorkReportVO saveOrUpdateVO) {
    	CompletionWorkReportEntity entity = BeanMapper.map(saveOrUpdateVO, CompletionWorkReportEntity.class);
    	if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
    	service.saveOrUpdate(entity, false);

    	//如果是全部验收，并且上传竣工联合验收意见书后，释放投标占用人员
        if("是".equals(entity.getFinishFlag())){
            if(entity.getFileFlag() != null && entity.getFileFlag().equals("是")){
                //TODO
                List<Long> projectIds = new ArrayList<>();
                projectIds.add(entity.getProjectId());
                zjllApi.finishReleaseByProjectIds(projectIds);
            }
        }

    	CompletionWorkReportVO vo = BeanMapper.map(entity, CompletionWorkReportVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }


    @ApiOperation("查询详情")
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<CompletionWorkReportVO> queryDetail(@RequestParam Long id) {
    	CompletionWorkReportEntity entity = service.selectById(id);
    	CompletionWorkReportVO vo = BeanMapper.map(entity, CompletionWorkReportVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }


    @ApiOperation("批量删除单据")
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<CompletionWorkReportVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (CompletionWorkReportVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(CompletionWorkReportVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }


    @ApiOperation("查询列表")
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<CompletionWorkReportVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        UserContext userContextCache =sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if(StringUtils.isNotBlank(authOrgIds)){//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        }else {//pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        //项目部 id
        List<Long> departmentIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            if(5 == org.getOrgType()) {
                //项目部
                departmentIds.add(org.getId());
            } else {
                //普通组织
                commonOrgIds.add(org.getId());
            }
        });
        if(CollectionUtils.isNotEmpty(commonOrgIds)) {
            /** 要求主表有orgId字段，保存单据所属组织 */
            param.getParams().put("parentOrgId", new Parameter(QueryParam.IN, commonOrgIds));
        } else if(CollectionUtils.isNotEmpty(departmentIds)) {
            /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
            param.getParams().put("orgId", new Parameter(QueryParam.IN, departmentIds));
        }
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */

        IPage<CompletionWorkReportEntity> page = service.queryPage(param,false);
        IPage<CompletionWorkReportVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), CompletionWorkReportVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    @ApiOperation("导出")
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<CompletionWorkReportEntity> list = service.queryList(param);
        //todo:字段翻译等等
        List<CompletionWorkReportVO> completionWorkReportVOS = BeanMapper.mapList(list, CompletionWorkReportVO.class);
        completionWorkReportVOS.forEach(vo -> {
            vo.setBillStateName(BillStateEnum.getEnumByStateCode(vo.getBillState()).getDescription());
        });
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", completionWorkReportVOS);
        ExcelExport.getInstance().export("CompletionWorkReport-export.xlsx", beans, response);
    }


    @ApiOperation("参照")
    @RequestMapping(value = "/refCompletionWorkReportData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<CompletionWorkReportVO>> refCompletionWorkReportData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<CompletionWorkReportEntity> page = service.queryPage(param,false);
        IPage<CompletionWorkReportVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), CompletionWorkReportVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }



    @ApiOperation("校验是否有自由态开工登记、停工登记、复工登记、完工登记")
    @RequestMapping(value = "/checkOnlyReprt", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<Map> checkOnlyReprt(@RequestParam Long projectId) {
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("projectId",new Parameter(QueryParam.EQ,projectId));
        queryParam.getParams().put("billState", new Parameter(QueryParam.IN,
                Arrays.asList(new Integer[]{BillStateEnum.UNCOMMITED_STATE.getBillStateCode()})));
        //在未生效的开工登记、停工登记、复工登记、完工登记如果存在提示
        List<StartWorkReportEntity> startWorkReportEntities = startWorkReportService.queryList(queryParam);
        List<ResumeWorkReportEntity> resumeWorkReportEntities = resumeWorkReportService.queryList(queryParam);
        List<StopWorkReportEntity> stopWorkReportEntities = stopWorkReportService.queryList(queryParam);
        List<FinishWorkReportEntity> finishWorkReportEntities = finishWorkReportService.queryList(queryParam);
        //只能存在一个完工登记
        // QueryParam completionQueryParam = new QueryParam();
        // completionQueryParam.getParams().put("projectId",new Parameter(QueryParam.EQ,projectId));
        // List<CompletionWorkReportEntity> completionWorkReportEntities = service.queryList(completionQueryParam);
        HashMap<String,  Object> map = new HashMap<>();
        map.put("startWorkReport",startWorkReportEntities);
        map.put("resumeWorkReport",resumeWorkReportEntities);
        map.put("stopWorkReport",stopWorkReportEntities);
        map.put("finishWorkReport",finishWorkReportEntities);
        // map.put("completionWorkReport",completionWorkReportEntities);
        return CommonResponse.success("校验是否有自由态开工登记、停工登记、复工登记、完工登记！",map);
    }

    /**
     * 一个项目只有一个验收报告是否竣工验收为是
     *
     * @param id        主键
     * @param projectId 项目id
     *
     * @return CommonResponse<String>
     */
    @ResponseBody
    @GetMapping(value = "/checkOnlyCompletionAcceptance")
    public CommonResponse<String> checkOnlyCompletionAcceptance(@RequestParam(value = "id", required = false) Long id,
                                                                @RequestParam(value = "projectId", required = true) Long projectId) {
        service.checkOnlyCompletionAcceptance(id, projectId);
        return CommonResponse.success("校验成功！");
    }

}
