package com.ejianc.business.projectOverView.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.hr.vo.TypeVO;
import com.ejianc.business.market.bean.ProjectSetEntity;
import com.ejianc.business.market.service.IProjectSetService;
import com.ejianc.business.outputvalcount.vo.MonthlyStatisticsVO;
import com.ejianc.business.project.vo.UserInfoVO;
import com.ejianc.business.projectOverView.service.IProjectManageService;
import com.ejianc.business.projectOverView.service.IProjectOverViewService;
import com.ejianc.business.projectOverView.vo.*;
import com.ejianc.business.projectmanage.vo.PracticeVO;
import com.ejianc.business.quality.vo.GccymbsdVO;
import com.ejianc.business.riskManage.vo.RiskAssessLatestVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.time.DateUtil;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.Utils;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.lang.time.DateFormatUtils;
import org.apache.ibatis.annotations.Param;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.*;
import java.util.Date;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 工程管理中心门户 2024-7-22
 * @author generator
 */
@Controller
@RequestMapping("projectManage")
public class ProjectManageController implements Serializable {

    @Autowired
    private IProjectManageService projectManageService;

    private Logger logger = LoggerFactory.getLogger(this.getClass());



    /**
     * @Description
     *      根据项目部分类，查询劳务纠纷数量
     * @Return
     */
    @RequestMapping(value = "/queryLaborSubAccountType", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> queryLaborSubAccountType(@RequestBody QueryParam param) {
        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper(param);
        List<TypeVO> totalTypeVOS = projectManageService.queryLaborSubAccountType(wrapper);

        /**
         * 查找已处理的
         */
        QueryParam deepCopy = Utils.deepCopy(param);
        deepCopy.getParams().put("processing_status_name",new Parameter(QueryParam.EQ,"已解决"));
        QueryWrapper copyWrapper = BaseServiceImpl.changeToQueryWrapper(deepCopy);

        /**
         * 已处理的根据劳务纠纷数量排序
         */
        List<TypeVO> dealVOS = projectManageService.queryLaborSubAccountType(copyWrapper);
        List<TypeVO> sortDealVOS = new ArrayList<>();
        for (TypeVO totalTypeVO : totalTypeVOS) {
            TypeVO typeVO = new TypeVO();
            typeVO.setType(totalTypeVO.getType());
            typeVO.setTypeCode(totalTypeVO.getTypeCode());
            for (TypeVO dealVO : dealVOS) {
                if(dealVO.getTypeCode().equals(totalTypeVO.getTypeCode())){
                    typeVO.setValue(dealVO.getValue());
                }
            }
            sortDealVOS.add(typeVO);
        }
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("totalValue",totalTypeVOS);
        jsonObject.put("sortDealValue",sortDealVOS);
        return CommonResponse.success("查询技术管理方案数量数据成功！", jsonObject);
    }
}
