/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.market.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.ejianc.business.enums.ArchiveStatusEnum;
import com.ejianc.business.enums.BusinessStatusEnum;
import com.ejianc.business.enums.CapitalStatusEnum;
import com.ejianc.business.enums.ProjectStatusEnum;
import com.ejianc.business.enums.SettleStatusEnum;
import com.ejianc.business.market.bean.AdjustApplicationEntity;
import com.ejianc.business.market.bean.ProjectSetEntity;
import com.ejianc.business.market.service.IAdjustApplicationService;
import com.ejianc.business.market.service.IProjectSetService;
import com.ejianc.foundation.share.api.IProjectSetApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import com.ejianc.framework.skeleton.template.BaseEntity;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="adjustApplication")
public class AdjustApplicationBpmServiceImpl
implements ICommonBusinessService {
    private static final String BUSINESS_STATUS1 = "\u5728\u5efa";
    private static final String BUSINESS_STATUS2 = "\u9879\u76ee\u4e2d\u6b62";
    private static final String BUSINESS_STATUS3 = "\u7ae3\u5de5";
    private static final String BUSINESS_STATUS4 = "\u5408\u540c\u72b6\u6001";
    private static final String SETTLE_STATUS = "\u51b3\u7b97\u72b6\u6001";
    private static final String ARCHIVE_STATUS = "\u8d44\u6599\u72b6\u6001";
    private static final String CAPITAL_STATUS = "\u8d44\u91d1\u7ba1\u63a7\u72b6\u6001";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final SessionManager sessionManager;
    private final IBillTypeApi billTypeApi;
    private final IProjectSetApi projectSetApi;
    private final IAdjustApplicationService service;
    @Autowired
    private IProjectSetService projectSetService;

    public AdjustApplicationBpmServiceImpl(SessionManager sessionManager, IBillTypeApi billTypeApi, IProjectSetApi projectSetApi, IAdjustApplicationService service) {
        this.sessionManager = sessionManager;
        this.billTypeApi = billTypeApi;
        this.projectSetApi = projectSetApi;
        this.service = service;
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        this.logger.info("\u7ec8\u5ba1\u5ba1\u6838\u5b8c\u56de\u8c03--start\uff0cbillId={},state={},billTypeCode={}", new Object[]{billId, state, billTypeCode});
        AdjustApplicationEntity entity = (AdjustApplicationEntity)((Object)this.service.selectById(billId));
        if (entity == null) {
            throw new BusinessException("\u67e5\u8be2\u4e0d\u5230\u5355\u636e\u4fe1\u606f");
        }
        UserContext userContext = this.sessionManager.getUserContext();
        if (state.equals(BillStateEnum.COMMITED_STATE.getBillStateCode())) {
            entity.setCommitDate(new Date());
            entity.setCommitUserCode(userContext.getUserCode());
            entity.setCommitUserName(userContext.getUserName());
        }
        entity.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)state).getDescription());
        entity.setEffectiveDate(new Date());
        this.service.saveOrUpdate((Object)entity, false);
        ProjectSetEntity setEntity = (ProjectSetEntity)((Object)this.projectSetService.getById(entity.getProjectId()));
        this.syncProjectSet(entity, setEntity);
        this.syncProjectPool(entity);
        this.logger.info("\u7ec8\u5ba1\u5ba1\u6838\u5b8c\u56de\u8c03--end");
        return CommonResponse.success((String)"\u7ec8\u5ba1\u5ba1\u6838\u5b8c\u56de\u8c03\u6210\u529f");
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return this.bpmBackCheck(billId, state, billTypeCode);
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return this.bpmBackCheck(billId, state, billTypeCode);
    }

    private CommonResponse<String> bpmBackCheck(Long billId, Integer state, String billTypeCode) {
        AdjustApplicationEntity entity = (AdjustApplicationEntity)((Object)this.service.selectById(billId));
        if (entity == null) {
            throw new BusinessException("\u67e5\u8be2\u4e0d\u5230\u5355\u636e\u4fe1\u606f");
        }
        LambdaQueryWrapper lambdaQuery = Wrappers.lambdaQuery();
        lambdaQuery.eq(AdjustApplicationEntity::getProjectId, (Object)entity.getProjectId());
        lambdaQuery.orderByDesc((Object[])new SFunction[]{AdjustApplicationEntity::getApplyDate, BaseEntity::getCreateTime});
        List entityList = this.service.list((Wrapper)lambdaQuery);
        if (CollectionUtils.isNotEmpty((Collection)entityList) && !Objects.equals(entity.getId(), ((AdjustApplicationEntity)((Object)entityList.get(0))).getId())) {
            throw new BusinessException("\u64cd\u4f5c\u5931\u8d25\uff01\u53ea\u80fd\u64a4\u9500\u6700\u65b0\u7533\u8bf7\u7684\u5355\u636e\u3002");
        }
        ProjectSetEntity setEntity = (ProjectSetEntity)((Object)this.projectSetService.getById(entity.getProjectId()));
        setEntity.setProjectStatus(ProjectStatusEnum.getCodeByName((String)entity.getProjectStatus()));
        setEntity.setBusinessStatus(BusinessStatusEnum.getCodeByName((String)entity.getBusinessStatus()));
        setEntity.setSettleStatus(SettleStatusEnum.getCodeByName((String)entity.getSettleStatus()));
        setEntity.setArchiveStatus(ArchiveStatusEnum.getCodeByName((String)entity.getArchiveStatus()));
        setEntity.setCapitalStatus(CapitalStatusEnum.getCodeByName((String)entity.getCapitalStatus()));
        setEntity.setChangeStatusDate(entity.getApplyDate());
        this.projectSetService.updateById((Object)setEntity);
        this.revertProjectPool(entity);
        return CommonResponse.success((String)"\u5355\u636e\u64a4\u56de/\u5f03\u5ba1\u6210\u529f");
    }

    private void syncProjectPool(AdjustApplicationEntity entity) {
        CommonResponse res;
        if ((BUSINESS_STATUS1.equals(entity.getAdjustStateType()) || BUSINESS_STATUS2.equals(entity.getAdjustStateType()) || BUSINESS_STATUS3.equals(entity.getAdjustStateType()) || BUSINESS_STATUS4.equals(entity.getAdjustStateType())) && !(res = this.projectSetApi.changeProjectStatus(entity.getProjectId(), ProjectStatusEnum.getCodeByName((String)entity.getAdjustStateType()), BusinessStatusEnum.getCodeByCode((String)entity.getStateAfterAdjustment()), null, null, null)).isSuccess()) {
            this.logger.info("\u5de5\u7a0b\u72b6\u6001\u8c03\u6574\u7533\u8bf7\u3010{}\u3011\u66f4\u65b0\u3010\u9879\u76ee\u6c60\u3011\u4e1a\u52a1\u72b6\u6001\u4e3a\u3010{}\u3011\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a{}", new Object[]{entity.getBillCode(), entity.getStateAfterAdjustment(), res.getMsg()});
            throw new BusinessException("\u5de5\u7a0b\u72b6\u6001\u8c03\u6574\u7533\u8bf7\u3010" + entity.getBillCode() + "\u3011\u66f4\u65b0\u3010\u9879\u76ee\u6c60\u3011\u4e1a\u52a1\u72b6\u6001\u4e3a\u3010" + entity.getStateAfterAdjustment() + "\u3011\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a" + res.getMsg());
        }
        if (SETTLE_STATUS.equals(entity.getAdjustStateType())) {
            if ("18".equals(entity.getStateAfterAdjustment())) {
                entity.setStateAfterAdjustment("1");
            }
            if (!(res = this.projectSetApi.changeProjectStatus(entity.getProjectId(), null, null, entity.getStateAfterAdjustment(), null, null)).isSuccess()) {
                this.logger.info("\u5de5\u7a0b\u72b6\u6001\u8c03\u6574\u7533\u8bf7\u3010{}\u3011\u66f4\u65b0\u3010\u9879\u76ee\u6c60\u3011\u7ed3\u7b97\u72b6\u6001\u4e3a\u3010{}\u3011\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a{}", new Object[]{entity.getBillCode(), entity.getStateAfterAdjustment(), res.getMsg()});
                throw new BusinessException("\u5de5\u7a0b\u72b6\u6001\u8c03\u6574\u7533\u8bf7\u3010" + entity.getBillCode() + "\u3011\u66f4\u65b0\u3010\u9879\u76ee\u6c60\u3011\u7ed3\u7b97\u72b6\u6001\u4e3a\u3010" + entity.getStateAfterAdjustment() + "\u3011\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a" + res.getMsg());
            }
        }
        if (ARCHIVE_STATUS.equals(entity.getAdjustStateType()) && !(res = this.projectSetApi.changeProjectStatus(entity.getProjectId(), null, null, null, entity.getStateAfterAdjustment(), null)).isSuccess()) {
            this.logger.info("\u5de5\u7a0b\u72b6\u6001\u8c03\u6574\u7533\u8bf7\u3010{}\u3011\u66f4\u65b0\u3010\u9879\u76ee\u6c60\u3011\u8d44\u6599\u5f52\u6863\u72b6\u6001\u4e3a\u3010{}\u3011\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a{}", new Object[]{entity.getBillCode(), entity.getStateAfterAdjustment(), res.getMsg()});
            throw new BusinessException("\u5de5\u7a0b\u72b6\u6001\u8c03\u6574\u7533\u8bf7\u3010" + entity.getBillCode() + "\u3011\u66f4\u65b0\u3010\u9879\u76ee\u6c60\u3011\u8d44\u6599\u5f52\u6863\u72b6\u6001\u4e3a\u3010" + entity.getStateAfterAdjustment() + "\u3011\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a" + res.getMsg());
        }
        if (CAPITAL_STATUS.equals(entity.getAdjustStateType()) && !(res = this.projectSetApi.changeProjectStatus(entity.getProjectId(), null, null, null, null, entity.getStateAfterAdjustment())).isSuccess()) {
            this.logger.info("\u5de5\u7a0b\u72b6\u6001\u8c03\u6574\u7533\u8bf7\u3010{}\u3011\u66f4\u65b0\u3010\u9879\u76ee\u6c60\u3011\u8d44\u91d1\u7ba1\u63a7\u72b6\u6001\u4e3a\u3010{}\u3011\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a{}", new Object[]{entity.getBillCode(), entity.getStateAfterAdjustment(), res.getMsg()});
            throw new BusinessException("\u5de5\u7a0b\u72b6\u6001\u8c03\u6574\u7533\u8bf7\u3010" + entity.getBillCode() + "\u3011\u66f4\u65b0\u3010\u9879\u76ee\u6c60\u3011\u8d44\u91d1\u7ba1\u63a7\u72b6\u6001\u4e3a\u3010" + entity.getStateAfterAdjustment() + "\u3011\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a" + res.getMsg());
        }
    }

    private void syncProjectSet(AdjustApplicationEntity entity, ProjectSetEntity projectSetEntity) {
        if (BUSINESS_STATUS1.equals(entity.getAdjustStateType()) || BUSINESS_STATUS2.equals(entity.getAdjustStateType()) || BUSINESS_STATUS3.equals(entity.getAdjustStateType()) || BUSINESS_STATUS4.equals(entity.getAdjustStateType())) {
            projectSetEntity.setProjectStatus(ProjectStatusEnum.getCodeByName((String)entity.getAdjustStateType()));
            projectSetEntity.setBusinessStatus(BusinessStatusEnum.getCodeByCode((String)entity.getStateAfterAdjustment()));
            if (BusinessStatusEnum.\u5728\u65bd.getCode().equals(entity.getStateAfterAdjustment())) {
                projectSetEntity.setChangeStatusDate(entity.getApplyDate());
            }
            if (BusinessStatusEnum.\u5f85\u7ae3\u5de5.getCode().equals(entity.getStateAfterAdjustment())) {
                projectSetEntity.setChangeStatusDate(entity.getFinishWorkDate());
            }
            if (BusinessStatusEnum.\u505c\u5de5.getCode().equals(entity.getStateAfterAdjustment())) {
                projectSetEntity.setChangeStatusDate(entity.getStopWorkCreateDate());
            }
            if (BusinessStatusEnum.\u7ae3\u5de5.getCode().equals(entity.getStateAfterAdjustment())) {
                projectSetEntity.setChangeStatusDate(entity.getCheckDate());
            }
            if (BusinessStatusEnum.\u672a\u5f00\u5de5.getCode().equals(entity.getStateAfterAdjustment())) {
                projectSetEntity.setChangeStatusDate(entity.getApplyDate());
            }
            if (BusinessStatusEnum.\u9879\u76ee\u4e2d\u6b62.getCode().equals(entity.getStateAfterAdjustment())) {
                projectSetEntity.setChangeStatusDate(entity.getApplyDate());
            }
        }
        if (SETTLE_STATUS.equals(entity.getAdjustStateType())) {
            if ("18".equals(entity.getStateAfterAdjustment())) {
                entity.setStateAfterAdjustment("1");
            }
            projectSetEntity.setSettleStatus(entity.getStateAfterAdjustment());
        }
        if (ARCHIVE_STATUS.equals(entity.getAdjustStateType())) {
            projectSetEntity.setArchiveStatus(entity.getStateAfterAdjustment());
        }
        if (CAPITAL_STATUS.equals(entity.getAdjustStateType())) {
            projectSetEntity.setCapitalStatus(entity.getStateAfterAdjustment());
        }
        this.projectSetService.updateById((Object)projectSetEntity);
    }

    private void revertProjectPool(AdjustApplicationEntity entity) {
        CommonResponse res = this.projectSetApi.changeProjectStatus(entity.getProjectId(), ProjectStatusEnum.getCodeByName((String)entity.getProjectStatus()), BusinessStatusEnum.getCodeByName((String)entity.getBusinessStatus()), SettleStatusEnum.getCodeByName((String)entity.getSettleStatus()), ArchiveStatusEnum.getCodeByName((String)entity.getArchiveStatus()), CapitalStatusEnum.getCodeByName((String)entity.getCapitalStatus()));
        if (!res.isSuccess()) {
            this.logger.info("\u5de5\u7a0b\u72b6\u6001\u8c03\u6574\u7533\u8bf7\u3010{}\u3011\u66f4\u65b0\u3010\u9879\u76ee\u6c60\u3011\u4e1a\u52a1\u72b6\u6001\u4e3a\u3010{}\u3011\uff0c\u7ed3\u7b97\u72b6\u6001\u4e3a\u3010{}\u3011\uff0c\u8d44\u6599\u5f52\u6863\u72b6\u6001\u4e3a\u3010{}\u3011\uff0c\u8d44\u91d1\u7ba1\u63a7\u72b6\u6001\u4e3a\u3010{}\u3011\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a{}", new Object[]{entity.getBillCode(), entity.getBusinessStatus(), entity.getSettleStatus(), entity.getArchiveStatus(), entity.getCapitalStatus(), res.getMsg()});
            throw new BusinessException("\u5de5\u7a0b\u72b6\u6001\u8c03\u6574\u7533\u8bf7\u3010" + entity.getBillCode() + "\u3011\u66f4\u65b0\u3010\u9879\u76ee\u6c60\u3011\u4e1a\u52a1\u72b6\u6001\u4e3a\u3010" + entity.getBusinessStatus() + "\u3011\uff0c\u7ed3\u7b97\u72b6\u6001\u4e3a\u3010" + entity.getSettleStatus() + "\u3011\uff0c\u8d44\u6599\u5f52\u6863\u72b6\u6001\u4e3a\u3010" + entity.getArchiveStatus() + "\u3011\uff0c\u8d44\u91d1\u7ba1\u63a7\u72b6\u6001\u4e3a\u3010" + entity.getCapitalStatus() + "\u3011\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a" + res.getMsg());
        }
    }
}

