package com.ejianc.business.market.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.constructor.api.IZjllApi;
import com.ejianc.business.constructor.vo.ZjllVO;
import com.ejianc.business.market.api.IProjectPartApi;
import com.ejianc.business.market.bean.ProjectPartEntity;
import com.ejianc.business.market.service.IProjectPartService;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;

import java.util.Date;
import java.util.List;

@Service("projectPart") 
public class ProjectPartBpmServiceImpl implements ICommonBusinessService {


	private Logger logger = LoggerFactory.getLogger(this.getClass());

	@Autowired
	private IProjectPartService projectPartService;
	@Autowired
	private IZjllApi zjllApi;

	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		ProjectPartEntity projectPartEntity = projectPartService.selectById(billId);
		Long summaryId = projectPartEntity.getBidSummaryId();
		Long enrollId = projectPartEntity.getEnrollId();
		Long projectId = projectPartEntity.getProjectId();

		QueryParam queryParam = new QueryParam();
		if (enrollId == null){
			throw new BusinessException("投标数据为空，请联系管理员！");
		}
		queryParam.getParams().put("projectId",new Parameter(QueryParam.EQ, enrollId));
		queryParam.getParams().put("yxzt",new Parameter(QueryParam.EQ, 0));
		CommonResponse<JSONArray> commonResponse = zjllApi.queryListByParam(queryParam);
		if(!commonResponse.isSuccess()){
			throw new BusinessException("在建履历查询失败!");
		}
		JSONArray data = commonResponse.getData();
		List<ZjllVO> zjllVOS = data.toJavaList(ZjllVO.class);
		for (ZjllVO zjllVO : zjllVOS) {
			//关闭历史在建履历
			zjllVO.setYxzt(1);
			zjllVO.setJssj(new Date());
			zjllVO.setXmId(zjllVO.getXmId());
			zjllVO.setChangeId(projectPartEntity.getId());
			zjllVO.setChangeType("执行标段");
			zjllApi.updateWrapper(zjllVO);
			//生成新的在建履历
			ZjllVO newZjllVO = new ZjllVO();
			newZjllVO.setXmId(zjllVO.getXmId());
			newZjllVO.setXmName(zjllVO.getXmName());
			newZjllVO.setGwId(zjllVO.getGwId());
			newZjllVO.setGw(zjllVO.getGw());
			newZjllVO.setProjectId(zjllVO.getProjectId());
			newZjllVO.setProjectName(zjllVO.getProjectName());
			newZjllVO.setKssj(new Date());
			newZjllVO.setZt(2);
			newZjllVO.setYxzt(0); //0:是 1 否
			newZjllVO.setOrgId(zjllVO.getOrgId());
			newZjllVO.setOrgName(zjllVO.getOrgName());
			newZjllVO.setTags("在建履历");
			newZjllVO.setRemark("执行标段");
			newZjllVO.setProPid(projectPartEntity.getProjectId());
			newZjllVO.setProPname(projectPartEntity.getProjectName());
			newZjllVO.setProjectPartId(projectPartEntity.getId());
			newZjllVO.setContractId(projectPartEntity.getContractId());
			zjllApi.save(newZjllVO);
			logger.info("执行标段写入状态为2到 在建人员履历！");
		}
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

}
