package com.ejianc.business.projectOverView.service;


import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Constants;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.outputvalcount.vo.MonthlyStatisticsVO;
import com.ejianc.business.project.vo.UserInfoVO;
import com.ejianc.business.projectOverView.vo.*;
import com.ejianc.business.projectmanage.vo.PracticeVO;
import com.ejianc.business.quality.vo.GccymbsdVO;
import com.ejianc.business.riskManage.vo.RiskAssessLatestVO;
import com.ejianc.business.technology.vo.YjDetailVO;
import com.ejianc.framework.core.response.QueryParam;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;

/**
 * 项目一览门户
 * 
 * @author generator
 * 
 */
public interface IProjectOverViewService {

    /**
     * 根据项目id查询查找方案数据
     * @param projectId
     * @return
     */
    FaDataVO queryFaData(Long projectId);
    /**
     * 根据项目id查询查找方案数据
     * @param projectId
     * @return
     */
    QualityAndSafeDataVO queryCheckData(Long projectId);


    /**
     * 根据项目id查询监理会议纪要数据
     * @param projectId
     * @return
     */
    MeetingMinutesDataVO queryMeetingMinutesData(Long projectId);

    /**
     * 根据项目id查询工程创优目标审定
     * @param projectId
     * @return
     */
    GccymbsdVO queryTarget(Long projectId);

    /**
     * 根据项目id，日期月份查询工程项目影像管理图片数据
     * @param projectId
     * @param dateStr
     * @return
     */
    ImageDataVO queryImageData(Long projectId,String dateStr);
    /**
     * 根据项目id，查询工程所有项目影像管理图片数据
     * @param projectId
     * @return
     */
    ImageDataVO queryAllImageData(Long projectId);

    /**
     * 根据项目id，项目起止时间计算项目影像管理列表展示页面
     * @param projectId
     * @param startDate
     * @param endDate
     * @return
     */
    List<ImageListVO> queryImageList(Long projectId,String startDate, String endDate);

    /**
     * 根据项目id,组织id查询施工日志数据
     * @param projectId
     * @param orgId
     * @return
     */
    LogDataVO queryLogInfo(Long projectId,Long orgId);

    /**
     * 根据项目id,查询计划数据
     * @param projectId
     * @return
     */
    PlanDataVO queryPlanData(Long projectId);

    /**
     * 查询报备人员
     * @param param
     * @return
     */
    List<UserInfoVO> queryUserInfo(Page<UserInfoVO> page,QueryParam param);


    /**
     * 根据项目id，查询成果管理得奖数量
     * @param projectId
     * @return
     */
    AchieveData queryAchieveData(Long projectId);


    /**
     * 根据项目id，查询各类支付
     * @param projectId
     * @return
     */
    PaymentRegisterData queryPaymentRegisterData(Long projectId);

    /**
     * 根据项目id，查询进度管理总计划开始时间、结束时间、项目实际开始时间
     * @param projectId
     * @Return
     */
    Map<String,String> queryStartDate(Long projectId);


    /**
     * 根据项目id，查询整改通知单、回复单数据
     * @param projectId
     * @Return
     */
    RectificationVO queryRectificationData(Long projectId);

    /**
     * 根据项目id，查询相关方信息
     * @param projectId
     * @Return
     */
    Map<String,Object> queryProjectRelateInfo(Long projectId);
    /**
     *
     * 根据项目id，查询施工风险综合评价风险级别
     * @param projectId
     * @Return
     */
    RiskAssessLatestVO queryProjectRiskLevel(Long projectId);

    /**
     * 根据项目id，查询危大工程数量
     * @param projectId
     * @Return
     */
    Map<String,String> queryDangerProjectData(Long projectId);

    /**
     * 根据项目id，查询劳务分包结算数据、材料结算数据
     * @param projectId
     * @Return
     */
    Map<String,String> querySettleData(Long projectId);
    /**
     * 查询项目进度明细
     * @param param
     * @return
     */
    List<MonthlyStatisticsVO> getStatisticsByOrgIdUnder(QueryParam param);
    /**
     * 查询应急演练
     * @param param
     * @return
     */
    List<PracticeVO> getPracticeList(QueryParam param);
}
