package com.ejianc.business.market.controller;

import java.io.Serializable;

import com.ejianc.foundation.orgcenter.api.IEmployeeApi;
import com.ejianc.foundation.orgcenter.api.IUserApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.auth.session.SessionManager;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.market.service.IProjectTeamService;
import com.ejianc.business.market.vo.ProjectTeamVO;

/**
 * 项目团队
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("projectTeam")
public class ProjectTeamController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    @Autowired
    private IProjectTeamService service;

    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IEmployeeApi employeeApi;
    @Autowired
    private IUserApi userApi;
    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<List<Map<String, Object>>> saveOrUpdate(@RequestBody List<ProjectTeamVO> projectTeamVOList) {

        service.saveOrUpdates(projectTeamVOList);
        Long projectDepartmentId= 0L;
        if(CollectionUtils.isNotEmpty(projectTeamVOList)){
            projectDepartmentId =projectTeamVOList.get(0).getProjectDepartmentId();
        }
        CommonResponse<List<Map<String, Object>>> commonResponse =userApi.getEmployeeList(projectDepartmentId);

        return CommonResponse.success("保存或修改单据成功！",commonResponse.getData());
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<List<Map<String, Object>>> queryList(@RequestBody Long projectDepartmentId) {
        CommonResponse<List<Map<String, Object>>> commonResponse =userApi.getEmployeeList(Long.valueOf(projectDepartmentId));
        return CommonResponse.success("查询列表数据成功！",commonResponse.getData());
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     *
     * @param vos
     * @return
     */
    @RequestMapping(value = "/updateType", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> updateType(@RequestBody Map<String, Object> map) {
        service.updateType(map);
        return CommonResponse.success("修改成功！");
    }
}
