package com.ejianc.business.project.service.impl;

import com.ejianc.business.project.vo.ProjectInfoVO;
import com.ejianc.business.project.vo.UserInfoVO;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.project.mapper.ProjectInfoMapper;
import com.ejianc.business.project.bean.ProjectInfoEntity;
import com.ejianc.business.project.service.IProjectInfoService;

import java.util.List;

/**
 * 项目信息统计表
 * 
 * @author generator
 * 
 */
@Service("projecInfoService")
public class ProjectInfoServiceImpl extends BaseServiceImpl<ProjectInfoMapper, ProjectInfoEntity> implements IProjectInfoService {

    @Override
    public List<UserInfoVO> getUserInfoByProjectId(Long project) {
        return baseMapper.getUserInfoByProjectId(project);
    }

    @Override
    public ProjectInfoVO getOutputvalueInfoByProjectId(Long project) {
        return baseMapper.getOutputvalueInfoByProjectId(project);
    }

    @Override
    public Long getTechnologyNumByProjectId(Long project) {
        return baseMapper.getTechnologyNumByProjectId(project);
    }

    @Override
    public ProjectInfoVO getLabsubByProjectId(Long project) {
        return baseMapper.getLabsubByProjectId(project);
    }

    @Override
    public ProjectInfoVO getProsubByProjectId(Long project) {
        return baseMapper.getProsubByProjectId(project);
    }

    @Override
    public ProjectInfoVO getRentByProjectId(Long project) {
        return baseMapper.getRentByProjectId(project);
    }

    @Override
    public ProjectInfoVO getMeetCountByProjectId(Long project) {
        return baseMapper.getMeetCountByProjectId(project);
    }

    @Override
    public ProjectInfoVO getBuildPersonCountByProjectId(Long project) {
        return baseMapper.getBuildPersonCountByProjectId(project);
    }
}
