package com.ejianc.business.market.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 成本关门
 *
 * @author baipengyan
 */
@TableName("ejc_promarket_close_cost")
public class CloseCostEntity extends BaseEntity {
	private static final long serialVersionUID = 2247520749894125873L;

	@TableField(value = "commit_date")
	private Date commitDate; // 提交日期
	@TableField(value = "commit_user_name")
	private String commitUserName; // 提交人名称
	@TableField(value = "commit_user_code")
	private String commitUserCode; // 提交人账号
	@TableField(value = "effective_date")
	private Date effectiveDate; // 生效日期
	@TableField(value = "bill_code")
	private String billCode; // 单据编号
	@TableField(value = "bill_name")
	private String billName; // 单据名称
	@TableField(value = "bill_state")
	private Integer billState; // 单据状态
	@TableField(value = "bill_state_name")
	private String billStateName; // 单据状态名称
	@TableField(value = "org_id")
	private Long orgId; // 项目部id
	@TableField(value = "org_code")
	private String orgCode; // 项目部编码
	@TableField(value = "org_name")
	private String orgName; // 项目部名称
	@TableField(value = "parent_org_id")
	private Long parentOrgId; // 项目部所属组织id
	@TableField(value = "parent_org_code")
	private String parentOrgCode; // 项目部所属组织编码
	@TableField(value = "parent_org_name")
	private String parentOrgName; // 项目部所属组织名称
	@TableField(value = "project_id")
	private Long projectId; // 项目id
	@TableField(value = "project_code")
	private String projectCode; // 项目编码
	@TableField(value = "project_name")
	private String projectName; // 项目名称
	@TableField(value = "close_date")
	private Date closeDate; // 关门日期
	@TableField(value = "employee_id")
	private Long employeeId; // 经办人id
	@TableField(value = "employee_name")
	private String employeeName; // 经办人名称
	@TableField(value = "department_id")
	private Long departmentId; // 经办部门id
	@TableField(value = "department_code")
	private String departmentCode; // 经办部门编码
	@TableField(value = "department_name")
	private String departmentName; // 经办部门名称
	@TableField(value = "close_memo")
	private String closeMemo; // 成本关门说明
	private String projectStatus; // 项目状态：1、在建 2、项目中止 3、竣工 4、保修 5、其他
	@TableField(value="contract_mny")
	private BigDecimal contractMny; // 合同额
	@TableField(value="finalized_mny")
	private BigDecimal finalizedMny; // 工程定案金额
	@TableField(value="pre_total_cost")
	private BigDecimal preTotalCost; // 预计总成本
	@TableField(value="pre_total_out")
	private BigDecimal preTotalOut; // 预计总欠付
	@TableField(value="pro_profit")
	private BigDecimal proProfit; // 预计净利润
	@TableField(value="pro_profit_per")
	private BigDecimal proProfitPer; // 预计利润率
	@TableField(value="business_status")
	private String businessStatus;

	@TableField(exist = false)
	@SubEntity(serviceName = "closeCostZiReportService", pidName = "zhuId")//此处有pid="xxx"，默认值pid="pid"
	private List<CloseCostZiReportEntity> zcDetail = new ArrayList<>(); // 成本关门-子表台账信息

	@TableField(exist = false)
	@SubEntity(serviceName = "closeCostInfoService", pidName = "closeCostId")//此处有pid="xxx"，默认值pid="pid"
	private List<CloseCostInfoEntity> closeCostInfoList = new ArrayList<>(); // 成本关门-金额信息

	@TableField(value="targetcost_profit")
	private BigDecimal targetcostProfit; // 目标利润率
	@TableField(value="process_profit")
	private BigDecimal processProfit; // 过程分析利润率
	@TableField(value="finish_profit")
	private BigDecimal finishProfit; // 完工分析利润率
	@TableField(value="dispose_state")
	private String disposeState; // 处置状态
	@TableField(exist=false)
	@SubEntity(serviceName="closeCostDisposeService")
	private List<CloseCostDisposeEntity> closeCostDisposeList = new ArrayList<>(); // 成本关门-处置子表

	public List<CloseCostDisposeEntity> getCloseCostDisposeList() {
		return closeCostDisposeList;
	}

	public void setCloseCostDisposeList(List<CloseCostDisposeEntity> closeCostDisposeList) {
		this.closeCostDisposeList = closeCostDisposeList;
	}

	public String getDisposeState() {
		return disposeState;
	}

	public void setDisposeState(String disposeState) {
		this.disposeState = disposeState;
	}

	public BigDecimal getTargetcostProfit() {
		return targetcostProfit;
	}

	public void setTargetcostProfit(BigDecimal targetcostProfit) {
		this.targetcostProfit = targetcostProfit;
	}

	public BigDecimal getProcessProfit() {
		return processProfit;
	}

	public void setProcessProfit(BigDecimal processProfit) {
		this.processProfit = processProfit;
	}

	public BigDecimal getFinishProfit() {
		return finishProfit;
	}

	public void setFinishProfit(BigDecimal finishProfit) {
		this.finishProfit = finishProfit;
	}

	public Date getCommitDate() {
		return commitDate;
	}

	public void setCommitDate(Date commitDate) {
		this.commitDate = commitDate;
	}

	public String getCommitUserName() {
		return commitUserName;
	}

	public void setCommitUserName(String commitUserName) {
		this.commitUserName = commitUserName;
	}

	public String getCommitUserCode() {
		return commitUserCode;
	}

	public void setCommitUserCode(String commitUserCode) {
		this.commitUserCode = commitUserCode;
	}

	public Date getEffectiveDate() {
		return effectiveDate;
	}

	public void setEffectiveDate(Date effectiveDate) {
		this.effectiveDate = effectiveDate;
	}

	public String getBillCode() {
		return billCode;
	}

	public void setBillCode(String billCode) {
		this.billCode = billCode;
	}

	public String getBillName() {
		return billName;
	}

	public void setBillName(String billName) {
		this.billName = billName;
	}

	public Integer getBillState() {
		return billState;
	}

	public void setBillState(Integer billState) {
		this.billState = billState;
	}

	public String getBillStateName() {
		return billStateName;
	}

	public void setBillStateName(String billStateName) {
		this.billStateName = billStateName;
	}

	public Long getOrgId() {
		return orgId;
	}

	public void setOrgId(Long orgId) {
		this.orgId = orgId;
	}

	public String getOrgCode() {
		return orgCode;
	}

	public void setOrgCode(String orgCode) {
		this.orgCode = orgCode;
	}

	public String getOrgName() {
		return orgName;
	}

	public void setOrgName(String orgName) {
		this.orgName = orgName;
	}

	public Long getParentOrgId() {
		return parentOrgId;
	}

	public void setParentOrgId(Long parentOrgId) {
		this.parentOrgId = parentOrgId;
	}

	public String getParentOrgCode() {
		return parentOrgCode;
	}

	public void setParentOrgCode(String parentOrgCode) {
		this.parentOrgCode = parentOrgCode;
	}

	public String getParentOrgName() {
		return parentOrgName;
	}

	public void setParentOrgName(String parentOrgName) {
		this.parentOrgName = parentOrgName;
	}

	public Long getProjectId() {
		return projectId;
	}

	public void setProjectId(Long projectId) {
		this.projectId = projectId;
	}

	public String getProjectCode() {
		return projectCode;
	}

	public void setProjectCode(String projectCode) {
		this.projectCode = projectCode;
	}

	public String getProjectName() {
		return projectName;
	}

	public void setProjectName(String projectName) {
		this.projectName = projectName;
	}

	public Date getCloseDate() {
		return closeDate;
	}

	public void setCloseDate(Date closeDate) {
		this.closeDate = closeDate;
	}

	public Long getEmployeeId() {
		return employeeId;
	}

	public void setEmployeeId(Long employeeId) {
		this.employeeId = employeeId;
	}

	public String getEmployeeName() {
		return employeeName;
	}

	public void setEmployeeName(String employeeName) {
		this.employeeName = employeeName;
	}

	public Long getDepartmentId() {
		return departmentId;
	}

	public void setDepartmentId(Long departmentId) {
		this.departmentId = departmentId;
	}

	public String getDepartmentCode() {
		return departmentCode;
	}

	public void setDepartmentCode(String departmentCode) {
		this.departmentCode = departmentCode;
	}

	public String getDepartmentName() {
		return departmentName;
	}

	public void setDepartmentName(String departmentName) {
		this.departmentName = departmentName;
	}

	public String getCloseMemo() {
		return closeMemo;
	}

	public void setCloseMemo(String closeMemo) {
		this.closeMemo = closeMemo;
	}

	public String getProjectStatus() {
		return projectStatus;
	}

	public void setProjectStatus(String projectStatus) {
		this.projectStatus = projectStatus;
	}

	public BigDecimal getContractMny() {
		return contractMny;
	}

	public void setContractMny(BigDecimal contractMny) {
		this.contractMny = contractMny;
	}

	public BigDecimal getFinalizedMny() {
		return finalizedMny;
	}

	public void setFinalizedMny(BigDecimal finalizedMny) {
		this.finalizedMny = finalizedMny;
	}

	public BigDecimal getPreTotalCost() {
		return preTotalCost;
	}

	public void setPreTotalCost(BigDecimal preTotalCost) {
		this.preTotalCost = preTotalCost;
	}

	public BigDecimal getPreTotalOut() {
		return preTotalOut;
	}

	public void setPreTotalOut(BigDecimal preTotalOut) {
		this.preTotalOut = preTotalOut;
	}

	public BigDecimal getProProfit() {
		return proProfit;
	}

	public void setProProfit(BigDecimal proProfit) {
		this.proProfit = proProfit;
	}

	public BigDecimal getProProfitPer() {
		return proProfitPer;
	}

	public void setProProfitPer(BigDecimal proProfitPer) {
		this.proProfitPer = proProfitPer;
	}

	public List<CloseCostZiReportEntity> getZcDetail() {
		return zcDetail;
	}

	public void setZcDetail(List<CloseCostZiReportEntity> zcDetail) {
		this.zcDetail = zcDetail;
	}

	public List<CloseCostInfoEntity> getCloseCostInfoList() {
		return closeCostInfoList;
	}

	public void setCloseCostInfoList(List<CloseCostInfoEntity> closeCostInfoList) {
		this.closeCostInfoList = closeCostInfoList;
	}

	public String getBusinessStatus() {
		return businessStatus;
	}

	public void setBusinessStatus(String businessStatus) {
		this.businessStatus = businessStatus;
	}
}
